/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.turbocharger;

import com.intellij.codeWithMe.ClientId;
import com.intellij.indexing.shared.download.SharedIndexAuthKt;
import com.intellij.indexing.shared.download.SharedIndexLookup;
import com.intellij.indexing.shared.download.SharedIndexLookupRequest;
import com.intellij.indexing.shared.download.SharedIndexLookupResult;
import com.intellij.indexing.shared.download.SharedIndexLookupResultKt;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.platform.api.SharedIndexInfrastructureVersion;
import com.intellij.indexing.shared.turbocharger.IsolatedCachePaths;
import com.intellij.indexing.shared.turbocharger.SharedCachesRequest;
import com.intellij.indexing.shared.turbocharger.SharedCachesRequestKt;
import com.intellij.indexing.shared.turbocharger.TurbochargedSharedCachesProjectStarterKt;
import com.intellij.indexing.shared.ultimate.project.ProjectIndexLookupRequest;
import com.intellij.indexing.shared.ultimate.project.ProjectSharedIndexSetting;
import com.intellij.indexing.shared.ultimate.project.ProjectSharedIndexSuggestion;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.concurrency.Semaphore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/intellij/indexing/shared/turbocharger/SharedCachesCdnRequest;", "Lcom/intellij/indexing/shared/turbocharger/SharedCachesRequest;", "setting", "Lcom/intellij/indexing/shared/ultimate/project/ProjectSharedIndexSetting;", "<init>", "(Lcom/intellij/indexing/shared/ultimate/project/ProjectSharedIndexSetting;)V", "presentableString", "", "getPresentableString", "()Ljava/lang/String;", "download", "", "target", "Lcom/intellij/indexing/shared/turbocharger/IsolatedCachePaths;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.indexing.shared.turbocharger"})
@SourceDebugExtension(value={"SMAP\nSharedCachesRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedCachesRequest.kt\ncom/intellij/indexing/shared/turbocharger/SharedCachesCdnRequest\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,263:1\n40#2,3:264\n1#3:267\n*S KotlinDebug\n*F\n+ 1 SharedCachesRequest.kt\ncom/intellij/indexing/shared/turbocharger/SharedCachesCdnRequest\n*L\n79#1:264,3\n*E\n"})
public final class SharedCachesCdnRequest
implements SharedCachesRequest {
    @NotNull
    private final ProjectSharedIndexSetting setting;

    public SharedCachesCdnRequest(@NotNull ProjectSharedIndexSetting setting) {
        Intrinsics.checkNotNullParameter((Object)setting, (String)"setting");
        this.setting = setting;
    }

    @Override
    @NlsContexts.Checkbox
    @NotNull
    public String getPresentableString() {
        Object[] objectArray = new Object[]{this.setting.getUrl()};
        String string = SharedIndexesBundle.message((String)"shared.caches.cdn.download.req.presentable.str", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download(@NotNull IsolatedCachePaths target, @NotNull ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        ProjectSharedIndexSuggestion suggestion = new ProjectSharedIndexSuggestion(this.setting, null);
        ProjectIndexLookupRequest request = suggestion.resolveRequest(progressIndicator);
        Semaphore semaphore = new Semaphore(1);
        List list = CollectionsKt.listOf((Object)TuplesKt.to((Object)suggestion, (Object)request));
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        SharedIndexAuthKt.initiateAuthIfNeeded((List)list, (ProgressIndicator)progressIndicator, (Disposable)((Disposable)application), arg_0 -> SharedCachesCdnRequest.download$lambda$0(semaphore, arg_0));
        ProgressIndicatorUtils.awaitWithCheckCanceled((Semaphore)semaphore, (ProgressIndicator)progressIndicator);
        boolean $i$f$service = false;
        Class<SharedIndexLookup> serviceClass$iv = SharedIndexLookup.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        SharedIndexLookup sharedIndexLookup = (SharedIndexLookup)object;
        SharedIndexLookupRequest sharedIndexLookupRequest = (SharedIndexLookupRequest)request;
        SharedIndexInfrastructureVersion sharedIndexInfrastructureVersion = SharedIndexInfrastructureVersion.getIdeVersion();
        Intrinsics.checkNotNullExpressionValue((Object)sharedIndexInfrastructureVersion, (String)"getIdeVersion(...)");
        SharedIndexLookupResult sharedIndexLookupResult = sharedIndexLookup.lookupSharedIndex(sharedIndexLookupRequest, sharedIndexInfrastructureVersion, progressIndicator);
        if (sharedIndexLookupResult == null) {
            throw new RuntimeException("Can't find shared caches to download");
        }
        SharedIndexLookupResult result = sharedIndexLookupResult;
        TurbochargedSharedCachesProjectStarterKt.getLog().info("Shared caches " + result.getSharedIndexMetadata() + " will be used to open project");
        Path isolatedPath = target.getDataPath();
        Path tempFile = isolatedPath.resolve(result.getChunkUniqueId() + "_" + System.currentTimeMillis() + "_temp.zip");
        try {
            SharedCachesRequestKt.access$copyFromIjx(target, progressIndicator, () -> SharedCachesCdnRequest.download$lambda$2(tempFile, result, progressIndicator));
        }
        finally {
            Files.deleteIfExists(tempFile);
        }
    }

    private static final Unit download$lambda$0(Semaphore $semaphore, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $semaphore.up();
        return Unit.INSTANCE;
    }

    private static final Path download$lambda$2(Path $tempFile, SharedIndexLookupResult $result, ProgressIndicator $progressIndicator) {
        Path path;
        Path it = path = $tempFile;
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$tempFile);
        return SharedIndexLookupResultKt.downloadChunk((SharedIndexLookupResult)$result, (Path)$tempFile, null, (ProgressIndicator)$progressIndicator) ? path : null;
    }
}

