/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.turbocharger;

import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.turbocharger.IsolatedCachePaths;
import com.intellij.indexing.shared.turbocharger.RepositoryDataWithProjectPath;
import com.intellij.indexing.shared.turbocharger.SharedCachesRequest;
import com.intellij.indexing.shared.turbocharger.SharedCachesRequestKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NlsContexts;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/intellij/indexing/shared/turbocharger/SharedCachesCopyRequest;", "Lcom/intellij/indexing/shared/turbocharger/SharedCachesRequest;", "source", "Lcom/intellij/indexing/shared/turbocharger/RepositoryDataWithProjectPath;", "<init>", "(Lcom/intellij/indexing/shared/turbocharger/RepositoryDataWithProjectPath;)V", "presentableString", "", "getPresentableString", "()Ljava/lang/String;", "download", "", "target", "Lcom/intellij/indexing/shared/turbocharger/IsolatedCachePaths;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.indexing.shared.turbocharger"})
public final class SharedCachesCopyRequest
implements SharedCachesRequest {
    @NotNull
    private final RepositoryDataWithProjectPath source;

    public SharedCachesCopyRequest(@NotNull RepositoryDataWithProjectPath source) {
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        this.source = source;
    }

    @Override
    @NlsContexts.Checkbox
    @NotNull
    public String getPresentableString() {
        Object[] objectArray = new Object[]{this.source.getProjectPath()};
        String string = SharedIndexesBundle.message((String)"shared.caches.copy.req.presentable.str", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    public void download(@NotNull IsolatedCachePaths target, @NotNull ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        SharedCachesRequestKt.access$copyCaches(IsolatedCachePaths.Companion.forProjectPath(this.source.getProjectLocation()), target, progressIndicator);
    }
}

