/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.turbocharger.git;

import com.intellij.indexing.shared.turbocharger.ProjectLabelDetector;
import com.intellij.indexing.shared.turbocharger.git.ProjectGitHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.newvfs.persistent.SemanticLabel;
import com.intellij.util.text.StringKt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/indexing/shared/turbocharger/git/GitLabelDetector;", "Lcom/intellij/indexing/shared/turbocharger/ProjectLabelDetector;", "<init>", "()V", "detectLabel", "Lcom/intellij/openapi/vfs/newvfs/persistent/SemanticLabel;", "projectPath", "Ljava/nio/file/Path;", "adjustIntellijUrl", "", "address", "intellij.indexing.shared.turbocharger.git"})
@SourceDebugExtension(value={"SMAP\nGitLabelDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabelDetector.kt\ncom/intellij/indexing/shared/turbocharger/git/GitLabelDetector\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,39:1\n24#2:40\n*S KotlinDebug\n*F\n+ 1 GitLabelDetector.kt\ncom/intellij/indexing/shared/turbocharger/git/GitLabelDetector\n*L\n19#1:40\n*E\n"})
public final class GitLabelDetector
implements ProjectLabelDetector {
    @Override
    @Nullable
    public SemanticLabel detectLabel(@NotNull Path projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            boolean bl;
            ApplicationManager.getApplication().assertIsNonDispatchThread();
            boolean bl2 = bl = !ApplicationManager.getApplication().isReadAccessAllowed();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
        }
        if (!ProjectGitHelper.INSTANCE.isInsideWorkTree(projectPath)) {
            GitLabelDetector $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(GitLabelDetector.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Project path is not inside work tree: " + projectPath);
            return null;
        }
        String string = StringKt.nullize((String)ProjectGitHelper.INSTANCE.getRepositoryUrl(projectPath), (boolean)true);
        if (string == null) {
            return null;
        }
        String address = string;
        String string2 = StringKt.nullize((String)ProjectGitHelper.INSTANCE.getHead(projectPath), (boolean)true);
        if (string2 == null) {
            return null;
        }
        String version = string2;
        String string3 = ProjectGitHelper.INSTANCE.getPathFromRoot(projectPath);
        if (string3 == null) {
            return null;
        }
        String pathFromRoot = string3;
        return StringsKt.isBlank((CharSequence)pathFromRoot) ? new SemanticLabel(this.adjustIntellijUrl(address), "GIT", version) : null;
    }

    private final String adjustIntellijUrl(String address) {
        return Intrinsics.areEqual((Object)address, (Object)"ssh://git@git.jetbrains.team/intellij.git") ? "ssh://git@git.jetbrains.team/ij/intellij.git" : address;
    }
}

