/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.turbocharger.vfs;

import com.intellij.codeWithMe.ClientId;
import com.intellij.indexing.shared.turbocharger.ProjectRepositoryDataKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.persistent.SemanticLabel;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0006J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/intellij/indexing/shared/turbocharger/vfs/LabeledPathService;", "", "<init>", "()V", "labeledPaths", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/openapi/vfs/newvfs/persistent/SemanticLabel;", "getLabeledPaths", "()Ljava/util/concurrent/ConcurrentHashMap;", "clear", "", "addAutoLabel", "path", "Ljava/nio/file/Path;", "addLabel", "label", "addSemanticLabel", "Companion", "intellij.indexing.shared.turbocharger"})
public final class LabeledPathService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, SemanticLabel> labeledPaths = new ConcurrentHashMap();

    @NotNull
    public final ConcurrentHashMap<String, SemanticLabel> getLabeledPaths() {
        return this.labeledPaths;
    }

    public final void clear() {
        this.labeledPaths.clear();
    }

    @Nullable
    public final SemanticLabel addAutoLabel(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = path.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
        Path normalizedPath = path2.normalize();
        Intrinsics.checkNotNull((Object)normalizedPath);
        SemanticLabel semanticRoot = ProjectRepositoryDataKt.detectSemanticLabel(normalizedPath);
        if (semanticRoot == null) {
            return null;
        }
        this.addSemanticLabel(normalizedPath, semanticRoot);
        return semanticRoot;
    }

    @NotNull
    public final SemanticLabel addLabel(@NotNull Path path, @NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Path path2 = path.toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toAbsolutePath(...)");
        Path normalizedPath = path2.normalize();
        SemanticLabel semanticLabel = new SemanticLabel(label, "LABEL", null);
        Intrinsics.checkNotNull((Object)normalizedPath);
        this.addSemanticLabel(normalizedPath, semanticLabel);
        return semanticLabel;
    }

    private final void addSemanticLabel(Path path, SemanticLabel label) {
        for (Map.Entry entry : ((Map)this.labeledPaths).entrySet()) {
            String p = (String)entry.getKey();
            SemanticLabel l = (SemanticLabel)entry.getValue();
            if (!Intrinsics.areEqual((Object)label, (Object)l)) continue;
            throw new Error("Duplicated label " + label + " for paths " + p + " and " + path);
        }
        String string = VirtualFileManager.constructUrl((String)LocalFileSystem.getInstance().getProtocol(), (String)FileUtil.normalize((String)((Object)path.toAbsolutePath()).toString()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"constructUrl(...)");
        String url = string;
        ((Map)this.labeledPaths).put(url, label);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/indexing/shared/turbocharger/vfs/LabeledPathService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/indexing/shared/turbocharger/vfs/LabeledPathService;", "intellij.indexing.shared.turbocharger"})
    @SourceDebugExtension(value={"SMAP\nLabeledRootSemanticAddressProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LabeledRootSemanticAddressProvider.kt\ncom/intellij/indexing/shared/turbocharger/vfs/LabeledPathService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,61:1\n40#2,3:62\n*S KotlinDebug\n*F\n+ 1 LabeledRootSemanticAddressProvider.kt\ncom/intellij/indexing/shared/turbocharger/vfs/LabeledPathService$Companion\n*L\n26#1:62,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LabeledPathService getInstance() {
            boolean $i$f$service = false;
            Class<LabeledPathService> serviceClass$iv = LabeledPathService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (LabeledPathService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

