/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.turbocharger.vfs;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.persistent.RootSemanticAddressProvider;
import com.intellij.openapi.vfs.newvfs.persistent.SemanticLabel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\bH\u0002J2\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u00192\u0006\u0010\u001a\u001a\u00020\bJ\f\u0010\u001b\u001a\u00020\b*\u00020\tH\u0002J\b\u0010\u001c\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/indexing/shared/turbocharger/vfs/LocalFileSystemRootPartitioner;", "", "<init>", "()V", "connected", "", "roots", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/openapi/vfs/newvfs/persistent/SemanticLabel;", "usedSemanticRoots", "getSemanticAddress", "path", "fs", "Lcom/intellij/openapi/vfs/newvfs/NewVirtualFileSystem;", "acquireSemanticLabel", "semanticLabel", "rootUrl", "replaceRootToLabel", "rootProtocol", "rootPath", "asSemanticRoot", "reset", "", "resolveSemanticAddress", "", "address", "toMacros", "ensureConnected", "Companion", "intellij.indexing.shared.turbocharger"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLocalFileSystemRootPartitioner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalFileSystemRootPartitioner.kt\ncom/intellij/indexing/shared/turbocharger/vfs/LocalFileSystemRootPartitioner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1#2:150\n*E\n"})
public final class LocalFileSystemRootPartitioner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private volatile boolean connected;
    @NotNull
    private final ConcurrentHashMap<String, SemanticLabel> roots = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<SemanticLabel, String> usedSemanticRoots = new ConcurrentHashMap();
    @NotNull
    private static final ExtensionPointName<RootSemanticAddressProvider> SEMANTIC_ROOT_PROVIDER_EP = new ExtensionPointName("com.intellij.semanticRootProvider");

    @Nullable
    public final String getSemanticAddress(@NotNull String path, @NotNull NewVirtualFileSystem fs) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
        this.ensureConnected();
        for (Map.Entry entry : ((Map)this.roots).entrySet()) {
            String rootPath;
            String rootUrl = (String)entry.getKey();
            SemanticLabel semanticLabel = (SemanticLabel)entry.getValue();
            String rootProtocol = VirtualFileManager.extractProtocol((String)rootUrl);
            Intrinsics.checkNotNullExpressionValue((Object)VirtualFileManager.extractPath((String)rootUrl), (String)"extractPath(...)");
            if (Intrinsics.areEqual((Object)rootProtocol, (Object)fs.getProtocol()) && FileUtil.isAncestor((String)rootPath, (String)path, (boolean)false) && this.acquireSemanticLabel(semanticLabel, rootUrl)) {
                return this.replaceRootToLabel(path, fs, rootProtocol, rootPath, semanticLabel);
            }
            if (!(fs instanceof ArchiveFileSystem) || !Intrinsics.areEqual((Object)rootProtocol, (Object)LocalFileSystem.getInstance().getProtocol()) || !FileUtil.isAncestor((String)rootPath, (String)ArchiveFileSystem.getLocalPath((ArchiveFileSystem)((ArchiveFileSystem)fs), (String)path), (boolean)false) || !this.acquireSemanticLabel(semanticLabel, rootUrl)) continue;
            return this.replaceRootToLabel(path, fs, rootProtocol, rootPath, semanticLabel);
        }
        return null;
    }

    private final boolean acquireSemanticLabel(SemanticLabel semanticLabel, String rootUrl) {
        String holderRoot = this.usedSemanticRoots.putIfAbsent(semanticLabel, rootUrl);
        return holderRoot == null || Intrinsics.areEqual((Object)holderRoot, (Object)rootUrl);
    }

    private final String replaceRootToLabel(String path, NewVirtualFileSystem fs, String rootProtocol, String rootPath, SemanticLabel semanticLabel) {
        String result = StringsKt.replace$default((String)path, (String)rootPath, (String)this.toMacros(semanticLabel), (boolean)false, (int)4, null);
        if (Intrinsics.areEqual((Object)result, (Object)path)) {
            String string = VirtualFileManager.constructUrl((String)rootProtocol, (String)rootPath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"constructUrl(...)");
            String rootUrl = string;
            String string2 = VirtualFileManager.constructUrl((String)fs.getProtocol(), (String)path);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"constructUrl(...)");
            String pathUrl = string2;
            LocalFileSystemRootPartitioner.Companion.getLOG().warn("By some reason " + rootUrl + " should but was not replaced in " + pathUrl + " to " + this.toMacros(semanticLabel));
            return null;
        }
        return result;
    }

    @Nullable
    public final String asSemanticRoot(@NotNull String path, @NotNull NewVirtualFileSystem fs) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
        this.ensureConnected();
        String string = VirtualFileManager.constructUrl((String)fs.getProtocol(), (String)path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"constructUrl(...)");
        String rootUrl = string;
        SemanticLabel semanticLabel = this.roots.get(rootUrl);
        if (semanticLabel == null || !this.acquireSemanticLabel(semanticLabel, rootUrl)) {
            return null;
        }
        return this.toMacros(semanticLabel);
    }

    public final void reset() {
        this.roots.clear();
        this.usedSemanticRoots.clear();
        this.connected = false;
    }

    @NotNull
    public final List<String> resolveSemanticAddress(@NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        this.ensureConnected();
        List result = new ArrayList();
        for (Map.Entry entry : ((Map)this.roots).entrySet()) {
            String addressProtocol;
            String noProtocolRootUrl;
            String noProtocolAddress;
            String rootUrl = (String)entry.getKey();
            SemanticLabel semanticLabel = (SemanticLabel)entry.getValue();
            String it = this.usedSemanticRoots.get(semanticLabel);
            boolean bl = false;
            if (it != null && !Intrinsics.areEqual((Object)it, (Object)rootUrl) || VirtualFileManager.extractProtocol((String)address) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)VirtualFileManager.extractPath((String)address), (String)"extractPath(...)");
            Intrinsics.checkNotNullExpressionValue((Object)VirtualFileManager.extractPath((String)rootUrl), (String)"extractPath(...)");
            String expanded = StringsKt.replace$default((String)noProtocolAddress, (String)this.toMacros(semanticLabel), (String)noProtocolRootUrl, (boolean)false, (int)4, null);
            if (Intrinsics.areEqual((Object)expanded, (Object)noProtocolAddress)) continue;
            String string = VirtualFileManager.constructUrl((String)addressProtocol, (String)expanded);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"constructUrl(...)");
            result.add(string);
        }
        return result;
    }

    private final String toMacros(SemanticLabel $this$toMacros) {
        return "[" + $this$toMacros.getType() + "](" + $this$toMacros.getName() + ")";
    }

    private final void ensureConnected() {
        if (!this.connected) {
            for (RootSemanticAddressProvider rootSemanticAddressProvider : SEMANTIC_ROOT_PROVIDER_EP.getExtensionList()) {
                for (Pair predefinedSemanticRoot : rootSemanticAddressProvider.getPredefinedSemanticRoots()) {
                    String rootPath = (String)predefinedSemanticRoot.first;
                    SemanticLabel semanticRoot = (SemanticLabel)predefinedSemanticRoot.second;
                    LocalFileSystemRootPartitioner.Companion.getLOG().info(semanticRoot + " is provided for " + rootPath);
                    ((Map)this.roots).put(rootPath, semanticRoot);
                }
            }
            this.connected = true;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/intellij/indexing/shared/turbocharger/vfs/LocalFileSystemRootPartitioner$Companion;", "", "<init>", "()V", "SEMANTIC_ROOT_PROVIDER_EP", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/openapi/vfs/newvfs/persistent/RootSemanticAddressProvider;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/indexing/shared/turbocharger/vfs/LocalFileSystemRootPartitioner;", "intellij.indexing.shared.turbocharger"})
    @SourceDebugExtension(value={"SMAP\nLocalFileSystemRootPartitioner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalFileSystemRootPartitioner.kt\ncom/intellij/indexing/shared/turbocharger/vfs/LocalFileSystemRootPartitioner$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,149:1\n14#2:150\n40#3,3:151\n*S KotlinDebug\n*F\n+ 1 LocalFileSystemRootPartitioner.kt\ncom/intellij/indexing/shared/turbocharger/vfs/LocalFileSystemRootPartitioner$Companion\n*L\n27#1:150\n29#1:151,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLOG() {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(LocalFileSystemRootPartitioner.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            return logger;
        }

        @NotNull
        public final LocalFileSystemRootPartitioner getInstance() {
            boolean $i$f$service = false;
            Class<LocalFileSystemRootPartitioner> serviceClass$iv = LocalFileSystemRootPartitioner.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (LocalFileSystemRootPartitioner)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

