/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupActionProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementAction;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.spring.boot.SpringBootApiBundle;
import com.intellij.spring.boot.SpringBootApiIcons;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringBootReplacementTokenCompletionContributor
extends CompletionContributor
implements LookupActionProvider {
    @NotNull
    private final Key<Couple<String>> myTokenKey;
    @Nullable
    private final String myInspectionId;
    private final TokenInsertHandler myTokenInsertHandler;

    @NotNull
    protected abstract List<Couple<String>> getReplacementTokens(@NotNull PsiElement var1);

    protected SpringBootReplacementTokenCompletionContributor(@NotNull ElementPattern<? extends PsiElement> place, @NotNull Key<Couple<String>> tokenKey, @Nullable String inspectionId) {
        if (place == null) {
            SpringBootReplacementTokenCompletionContributor.$$$reportNull$$$0(0);
        }
        if (tokenKey == null) {
            SpringBootReplacementTokenCompletionContributor.$$$reportNull$$$0(1);
        }
        this.myTokenInsertHandler = new TokenInsertHandler();
        this.myTokenKey = tokenKey;
        this.myInspectionId = inspectionId;
        this.extend(CompletionType.BASIC, place, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!parameters.isExtendedCompletion()) {
                    String shortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"CodeCompletion");
                    result.addLookupAdvertisement(SpringBootApiBundle.message("SpringBootReplacementTokenCompletionContributor.press.again.to.show.replacement.tokens", shortcut));
                    return;
                }
                List<Couple<String>> replacementTokens = SpringBootReplacementTokenCompletionContributor.this.getReplacementTokens(parameters.getPosition());
                String text = parameters.getPosition().getText();
                for (Couple<String> token : replacementTokens) {
                    if (!StringUtil.contains((CharSequence)text, (CharSequence)((CharSequence)token.first))) continue;
                    return;
                }
                CompletionResultSet noPrefixResult = result.withPrefixMatcher("");
                for (Couple<String> token : replacementTokens) {
                    this.addCompletionVariant(noPrefixResult, token, "Replacement token");
                }
                this.addCompletionVariant(noPrefixResult, (Couple<String>)Couple.of((Object)"${", (Object)"}"), "Placeholder");
            }

            private void addCompletionVariant(CompletionResultSet completionResultSet, Couple<String> token, String typeText) {
                LookupElementBuilder lookupElement = LookupElementBuilder.create((String)((String)token.first + (String)token.second)).withPresentableText((String)token.first + "..." + (String)token.second).withBoldness(true).withIcon(SpringBootApiIcons.SpringBoot).withTypeText(typeText, true).withInsertHandler((InsertHandler)SpringBootReplacementTokenCompletionContributor.this.myTokenInsertHandler);
                lookupElement.putUserData(SpringBootReplacementTokenCompletionContributor.this.myTokenKey, token);
                completionResultSet.addElement(PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)-50.0));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/spring/boot/application/config/SpringBootReplacementTokenCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void fillActions(@NotNull LookupElement element, final @NotNull Lookup lookup, @NotNull @NotNull Consumer<? super @NotNull LookupElementAction> consumer) {
        if (element == null) {
            SpringBootReplacementTokenCompletionContributor.$$$reportNull$$$0(2);
        }
        if (lookup == null) {
            SpringBootReplacementTokenCompletionContributor.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            SpringBootReplacementTokenCompletionContributor.$$$reportNull$$$0(4);
        }
        if (this.myInspectionId != null && this.myTokenKey.isIn((UserDataHolder)element)) {
            consumer.consume((Object)new LookupElementAction(PlatformIcons.EDIT, SpringBootApiBundle.message("SpringBootReplacementTokenCompletionContributor.configure.replacement.tokens", new Object[0])){

                public LookupElementAction.Result performLookupAction() {
                    Project project = lookup.getProject();
                    ApplicationManager.getApplication().invokeLater(() -> {
                        InspectionProfileImpl profile = InspectionProfileManager.getInstance((Project)project).getCurrentProfile();
                        EditInspectionToolsSettingsAction.editToolSettings((Project)project, (InspectionProfileImpl)profile, (String)SpringBootReplacementTokenCompletionContributor.this.myInspectionId);
                    }, project.getDisposed());
                    return LookupElementAction.Result.HIDE_LOOKUP;
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenKey";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookup";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/application/config/SpringBootReplacementTokenCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "fillActions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class TokenInsertHandler
    implements InsertHandler<LookupElement> {
        private TokenInsertHandler() {
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                TokenInsertHandler.$$$reportNull$$$0(0);
            }
            if (item == null) {
                TokenInsertHandler.$$$reportNull$$$0(1);
            }
            Couple token = (Couple)item.getUserData(SpringBootReplacementTokenCompletionContributor.this.myTokenKey);
            assert (token != null);
            context.getEditor().getCaretModel().moveCaretRelatively(-((String)token.second).length(), 0, false, false, false);
            AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/intellij/spring/boot/application/config/SpringBootReplacementTokenCompletionContributor$TokenInsertHandler";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

