/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.hints.HintReferenceBase;
import com.intellij.microservices.jvm.config.hints.HintReferenceProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.SpringBootApiIcons;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.ConfigurationValueResult;
import com.intellij.spring.boot.model.ConfigurationValueSearchParams;
import com.intellij.spring.boot.model.SpringBootConfigValueSearcher;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoggingGroupReferenceProvider
implements HintReferenceProvider {
    public PsiReference[] getReferences(@NotNull PsiElement element, @NotNull List<TextRange> textRanges, @NotNull ProcessingContext context) {
        Module module;
        if (element == null) {
            LoggingGroupReferenceProvider.$$$reportNull$$$0(0);
        }
        if (textRanges == null) {
            LoggingGroupReferenceProvider.$$$reportNull$$$0(1);
        }
        if (context == null) {
            LoggingGroupReferenceProvider.$$$reportNull$$$0(2);
        }
        if (!SpringBootLibraryUtil.isAtLeastVersion(module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element), SpringBootLibraryUtil.SpringBootVersion.VERSION_2_1_0)) {
            return PsiReference.EMPTY_ARRAY;
        }
        return (PsiReference[])ContainerUtil.map2Array(textRanges, PsiReference.class, textRange -> new LoggingGroupReference(element, (TextRange)textRange));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "textRanges";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/boot/application/config/hints/LoggingGroupReferenceProvider";
        objectArray[2] = "getReferences";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class LoggingGroupReference
    extends HintReferenceBase {
        private static final String LOGGING_GROUP_KEY = "logging.group";

        private LoggingGroupReference(PsiElement element, TextRange range) {
            super(element, range);
            this.mySoft = true;
        }

        @Nullable
        public PsiElement doResolve() {
            String groupName = this.getCanonicalText();
            CommonProcessors.FindFirstProcessor resolveProcessor = new CommonProcessors.FindFirstProcessor();
            this.processLoggingGroups((Processor<ConfigurationValueResult>)resolveProcessor, groupName);
            ConfigurationValueResult value = (ConfigurationValueResult)resolveProcessor.getFoundValue();
            return value != null ? value.getKeyElement() : null;
        }

        public Object @NotNull [] getHintVariants() {
            HashSet groups = new HashSet();
            SmartList variants = new SmartList();
            Processor variantProcessor = arg_0 -> LoggingGroupReference.lambda$getHintVariants$0(groups, (List)variants, arg_0);
            this.processLoggingGroups((Processor<ConfigurationValueResult>)variantProcessor, "");
            Object[] objectArray = variants.toArray();
            if (objectArray == null) {
                LoggingGroupReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        private void processLoggingGroups(Processor<ConfigurationValueResult> processor, String groupName) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
            if (module == null) {
                return;
            }
            MetaConfigKey loggingGroupKey = SpringBootApplicationMetaConfigKeyManager.getInstance().findCanonicalApplicationMetaConfigKey(module, LOGGING_GROUP_KEY);
            if (loggingGroupKey == null) {
                return;
            }
            ConfigurationValueSearchParams params = new ConfigurationValueSearchParams(module, true, ConfigurationValueSearchParams.PROCESS_ALL_VALUES, loggingGroupKey, groupName, null, true, new HashSet<VirtualFile>());
            SpringBootConfigValueSearcher.processConfigFilesWithPropertySources(params, true, processor);
        }

        private static /* synthetic */ boolean lambda$getHintVariants$0(Set groups, List variants, ConfigurationValueResult result) {
            PsiElement keyElement = result.getKeyElement();
            String logGroupName = result.getKeyIndexText();
            if (StringUtil.isNotEmpty((String)logGroupName) && groups.add(logGroupName)) {
                variants.add(LookupElementBuilder.createWithSmartPointer((String)logGroupName, (PsiElement)keyElement).withIcon(SpringBootApiIcons.SpringBoot).withTailText(" (" + result.getValueText() + ")", true).withTypeText(keyElement.getContainingFile().getName()));
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/LoggingGroupReferenceProvider$LoggingGroupReference", "getHintVariants"));
        }
    }
}

