/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.highlighting.HighlightedReference;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyManager;
import com.intellij.microservices.jvm.config.MetaConfigKeyReference;
import com.intellij.microservices.jvm.config.properties.AutoPopupTailTypes;
import com.intellij.psi.PsiElement;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u0006H\u0016J\u0015\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fH\u0016\u00a2\u0006\u0002\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/intellij/spring/boot/application/properties/DynamicPropertyRegistryReference;", "Lcom/intellij/microservices/jvm/config/MetaConfigKeyReference;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInsight/highlighting/HighlightedReference;", "psiElement", "propertyName", "", "<init>", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;)V", "getPsiElement", "()Lcom/intellij/psi/PsiElement;", "getPropertyName", "()Ljava/lang/String;", "getReferenceDisplayText", "getVariants", "", "", "()[Ljava/lang/Object;", "intellij.spring.boot.core"})
@SourceDebugExtension(value={"SMAP\nSpringBootDynamicPropertyReferenceContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBootDynamicPropertyReferenceContributor.kt\ncom/intellij/spring/boot/application/properties/DynamicPropertyRegistryReference\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,49:1\n37#2,2:50\n*S KotlinDebug\n*F\n+ 1 SpringBootDynamicPropertyReferenceContributor.kt\ncom/intellij/spring/boot/application/properties/DynamicPropertyRegistryReference\n*L\n47#1:50,2\n*E\n"})
final class DynamicPropertyRegistryReference
extends MetaConfigKeyReference<PsiElement>
implements HighlightedReference {
    @NotNull
    private final PsiElement psiElement;
    @NotNull
    private final String propertyName;

    public DynamicPropertyRegistryReference(@NotNull PsiElement psiElement, @NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        super((MetaConfigKeyManager)SpringBootApplicationMetaConfigKeyManager.getInstance(), psiElement, propertyName);
        this.psiElement = psiElement;
        this.propertyName = propertyName;
    }

    @NotNull
    public final PsiElement getPsiElement() {
        return this.psiElement;
    }

    @NotNull
    public final String getPropertyName() {
        return this.propertyName;
    }

    @NotNull
    public String getReferenceDisplayText() {
        return this.propertyName;
    }

    @NotNull
    public Object[] getVariants() {
        List configKeys = this.getConfigKeyManager().getAllMetaConfigKeys(this.getElement());
        List result = new ArrayList(configKeys.size());
        for (MetaConfigKey configKey : configKeys) {
            LookupElementBuilder builder = configKey.getPresentation().getLookupElement();
            MetaConfigKey.AccessType[] accessTypeArray = MetaConfigKey.AccessType.MAP_GROUP;
            TailType tailType = configKey.isAccessType(Arrays.copyOf(accessTypeArray, accessTypeArray.length)) ? AutoPopupTailTypes.dotType() : null;
            TailTypeDecorator tailTypeDecorator = TailTypeDecorator.withTail((LookupElement)((LookupElement)builder), (TailType)tailType);
            LookupElement lookupElement = configKey.getPresentation().tuneLookupElement((LookupElement)tailTypeDecorator);
            Intrinsics.checkNotNullExpressionValue((Object)lookupElement, (String)"tuneLookupElement(...)");
            result.add(lookupElement);
        }
        Collection $this$toTypedArray$iv = result;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Object[0]);
    }
}

