/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyReference;
import com.intellij.microservices.jvm.config.properties.IndexAccessTextProcessor;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.application.config.SpringBootConfigFileAnnotatorBase;
import com.intellij.spring.boot.model.SpringBootConfigurationFileService;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;

final class SpringBootApplicationPropertiesAnnotator
extends SpringBootConfigFileAnnotatorBase {
    SpringBootApplicationPropertiesAnnotator() {
    }

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            SpringBootApplicationPropertiesAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            SpringBootApplicationPropertiesAnnotator.$$$reportNull$$$0(1);
        }
        if (!(element instanceof PropertyValueImpl) && !(element instanceof PropertyKeyImpl)) {
            return;
        }
        PsiFile file = holder.getCurrentAnnotationSession().getFile();
        if (!(file instanceof PropertiesFile)) {
            return;
        }
        if (!SpringCommonUtils.isSpringConfigured((Project)file.getProject()) || !SpringBootConfigurationFileService.getInstance().isApplicationConfigurationFile(file)) {
            return;
        }
        if (element instanceof PropertyValueImpl) {
            this.annotateValue(element, holder);
        }
        if (element instanceof PropertyKeyImpl) {
            this.doAnnotateKey((PropertyKeyImpl)element, holder);
        }
    }

    @Override
    protected TextAttributesKey getPlaceholderTextAttributesKey() {
        return PropertiesHighlighter.PropertiesComponent.PROPERTY_KEY.getTextAttributesKey();
    }

    private void doAnnotateKey(PropertyKeyImpl element, AnnotationHolder holder) {
        MetaConfigKey configKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)element);
        if (configKey == null) {
            return;
        }
        String keyText = element.getText();
        int elementStartOffset = element.getNode().getStartOffset();
        this.annotateIndexAccessExpressions(holder, keyText, configKey, elementStartOffset);
        if (configKey.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL})) {
            return;
        }
        this.annotateKey((PsiElement)element, holder);
        if (configKey.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.MAP}) && configKey.getKeyItemHint() != MetaConfigKey.ItemHint.NONE) {
            int configKeyNameLength = -1;
            for (PsiReference reference : element.getReferences()) {
                if (!(reference instanceof MetaConfigKeyReference)) continue;
                configKeyNameLength = reference.getRangeInElement().getEndOffset();
                break;
            }
            assert (configKeyNameLength != -1) : keyText;
            int endOffset = keyText.length() - configKeyNameLength - (StringUtil.endsWithChar((CharSequence)keyText, (char)']') ? 2 : 1);
            if (endOffset < 0) {
                return;
            }
            TextRange genericKeyRange = TextRange.from((int)(configKeyNameLength + 1), (int)endOffset).shiftRight(elementStartOffset);
            this.doAnnotateEnforced(holder, genericKeyRange, SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES, "REGULAR_ITALIC_ATTRIBUTES");
        }
    }

    private void annotateIndexAccessExpressions(final AnnotationHolder holder, String text, MetaConfigKey configKey, final int elementStartOffset) {
        new IndexAccessTextProcessor(text, configKey){

            protected void onMissingClosingBracket(int startIdx) {
            }

            protected void onMissingIndexValue(int startIdx) {
            }

            protected void onBracket(int startIdx) {
                SpringBootApplicationPropertiesAnnotator.this.doAnnotate(holder, TextRange.from((int)startIdx, (int)1).shiftRight(elementStartOffset), DefaultLanguageHighlighterColors.BRACKETS);
            }

            protected void onIndexValue(TextRange indexValueRange) {
                SpringBootApplicationPropertiesAnnotator.this.doAnnotate(holder, indexValueRange.shiftRight(elementStartOffset), DefaultLanguageHighlighterColors.NUMBER);
            }

            protected void onIndexValueNotInteger(TextRange indexValueRange) {
            }
        }.process();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

