/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyReference;
import com.intellij.microservices.jvm.config.properties.IndexAccessTextProcessor;
import com.intellij.microservices.jvm.config.yaml.ConfigYamlUtils;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.boot.application.config.SpringBootConfigFileAnnotatorBase;
import com.intellij.spring.boot.model.SpringBootConfigurationFileService;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLHighlighter;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

final class SpringBootApplicationYamlAnnotator
extends SpringBootConfigFileAnnotatorBase {
    SpringBootApplicationYamlAnnotator() {
    }

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            SpringBootApplicationYamlAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            SpringBootApplicationYamlAnnotator.$$$reportNull$$$0(1);
        }
        if (!(element instanceof YAMLKeyValue)) {
            return;
        }
        YAMLKeyValue yamlKeyValue = (YAMLKeyValue)element;
        PsiFile file = holder.getCurrentAnnotationSession().getFile();
        if (!(file instanceof YAMLFile)) {
            return;
        }
        if (!SpringCommonUtils.isSpringConfigured((Project)file.getProject()) || !SpringBootConfigurationFileService.getInstance().isApplicationConfigurationFile(file)) {
            return;
        }
        PsiElement yamlKeyElement = yamlKeyValue.getKey();
        if (yamlKeyElement == null) {
            return;
        }
        this.doAnnotateKey(yamlKeyValue, yamlKeyElement, holder);
        YAMLValue yamlValue = yamlKeyValue.getValue();
        if (yamlValue instanceof YAMLScalar) {
            this.annotateValue((PsiElement)yamlValue, holder);
        } else if (yamlValue instanceof YAMLSequence) {
            YAMLSequence sequence = (YAMLSequence)yamlValue;
            for (YAMLSequenceItem item : sequence.getItems()) {
                YAMLValue value = item.getValue();
                if (!(value instanceof YAMLScalar)) continue;
                this.annotateValue((PsiElement)value, holder);
            }
        }
    }

    @Override
    protected TextAttributesKey getPlaceholderTextAttributesKey() {
        return YAMLHighlighter.SCALAR_KEY;
    }

    private void doAnnotateKey(YAMLKeyValue keyValue, PsiElement yamlKeyElement, AnnotationHolder holder) {
        MetaConfigKey configKey;
        String keyName = ConfigYamlUtils.getQualifiedConfigKeyName((YAMLKeyValue)keyValue);
        Object[] references = keyValue.getReferences();
        MetaConfigKeyReference keyReference = (MetaConfigKeyReference)ContainerUtil.findInstance((Object[])references, MetaConfigKeyReference.class);
        MetaConfigKey metaConfigKey = configKey = keyReference != null ? keyReference.getResolvedKey() : null;
        if ("spring.profiles".equals(keyName) && configKey == null) {
            holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(yamlKeyElement).textAttributes(DefaultLanguageHighlighterColors.KEYWORD).create();
        }
        this.annotateKey((PsiElement)keyValue, holder);
        PsiElement keyElement = keyValue.getKey();
        if (keyElement != null && configKey != null) {
            String keyElementText;
            TextRange textRange = ConfigYamlUtils.getKeyReferenceRange((YAMLKeyValue)keyValue);
            boolean annotateIndex = !StringUtil.startsWithChar((CharSequence)textRange.substring(keyElementText = keyElement.getText()), (char)'[');
            int elementStartOffset = keyValue.getNode().getStartOffset();
            this.annotateIndexAccessExpressions(holder, keyElementText, configKey, elementStartOffset, annotateIndex);
        }
    }

    private void annotateIndexAccessExpressions(final AnnotationHolder holder, String text, MetaConfigKey configKey, final int elementStartOffset, final boolean annotateIndex) {
        new IndexAccessTextProcessor(text, configKey){

            protected void onMissingClosingBracket(int startIdx) {
            }

            protected void onMissingIndexValue(int startIdx) {
            }

            protected void onBracket(int startIdx) {
                SpringBootApplicationYamlAnnotator.this.doAnnotate(holder, TextRange.from((int)startIdx, (int)1).shiftRight(elementStartOffset), DefaultLanguageHighlighterColors.BRACKETS);
            }

            protected void onIndexValue(TextRange indexValueRange) {
                if (annotateIndex) {
                    SpringBootApplicationYamlAnnotator.this.doAnnotate(holder, indexValueRange.shiftRight(elementStartOffset), DefaultLanguageHighlighterColors.NUMBER);
                }
            }

            protected void onIndexValueNotInteger(TextRange indexValueRange) {
            }
        }.process();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

