/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.microservices.jvm.config.yaml.ConfigYamlUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.spring.boot.application.structure.AbstractApplicationPropertiesLogicalElementsProvider;
import com.intellij.spring.boot.model.SpringBootConfigurationFileService;
import com.intellij.spring.boot.model.logical.ApplicationConfigLogicalGroup;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/spring/boot/application/yaml/SpringBootApplicationYamlLogicalElementsProvider;", "Lcom/intellij/spring/boot/application/structure/AbstractApplicationPropertiesLogicalElementsProvider;", "Lorg/jetbrains/yaml/psi/YAMLFile;", "<init>", "()V", "getElements", "", "Lcom/intellij/spring/boot/model/logical/ApplicationConfigLogicalGroup;", "parent", "intellij.spring.boot.configYaml"})
public final class SpringBootApplicationYamlLogicalElementsProvider
extends AbstractApplicationPropertiesLogicalElementsProvider<YAMLFile> {
    @NotNull
    public List<ApplicationConfigLogicalGroup> getElements(@NotNull YAMLFile parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if (!Registry.Companion.is("spring.boot.config.file.logical.structure")) {
            return CollectionsKt.emptyList();
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)parent));
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module module2 = module;
        if (!SpringBootConfigurationFileService.getInstance().isApplicationConfigurationFile((PsiFile)parent)) {
            return CollectionsKt.emptyList();
        }
        List allProperties = new ArrayList();
        for (YAMLDocument document : parent.getDocuments()) {
            document.acceptChildren((PsiElementVisitor)new PsiRecursiveElementVisitor(allProperties){
                final /* synthetic */ List<AbstractApplicationPropertiesLogicalElementsProvider.Property> $allProperties;
                {
                    this.$allProperties = $allProperties;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    super.visitElement(element);
                    YAMLKeyValue yAMLKeyValue = element instanceof YAMLKeyValue ? (YAMLKeyValue)element : null;
                    if (yAMLKeyValue == null) {
                        return;
                    }
                    YAMLKeyValue keyValueElement = yAMLKeyValue;
                    if (!(keyValueElement.getValue() instanceof YAMLScalar)) {
                        return;
                    }
                    String string = ConfigYamlUtils.getQualifiedConfigKeyName((YAMLKeyValue)keyValueElement);
                    String string2 = keyValueElement.getValueText();
                    SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)element);
                    Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
                    this.$allProperties.add(new AbstractApplicationPropertiesLogicalElementsProvider.Property(string, string2, smartPsiElementPointer));
                }
            });
        }
        return this.groupProperties(module2, allProperties);
    }
}

