/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.facet;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.spring.boot.SpringBootApiBundle;
import com.intellij.spring.boot.SpringBootIconServiceImplKt;
import com.intellij.spring.boot.model.SpringBootConfigurationFileService;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.boot.model.SpringBootModelConfigFileNameContributor;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.beans.CustomSetting;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xml.config.ConfigFileSearcher;
import com.intellij.xml.config.ConfigFilesTreeBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SpringBootCustomizationDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private JPanel myTreePanel;
    private JPanel myTextFieldPanel;
    private JBLabel myKeyLabel;
    private JPanel myConfigurationPanel;
    private TextFieldWithAutoCompletion<SpringConfigNameProposal> mySpringConfigNameTextField;
    private final Project myProject;
    private final SpringFileSet myFileSet;
    private final SpringBootModelConfigFileNameContributor myFileNameContributor;
    private CheckboxTreeBase myFilesTree;
    private ConfigFilesTreeBuilder myFilesTreeBuilder;
    private final Set<PsiFile> myPsiFiles;
    private boolean foundConfigFilesByName;
    private final List<VirtualFile> myCustomConfigFiles;
    private final Module myModule;

    SpringBootCustomizationDialog(Project project, SpringFileSet fileSet, SpringBootModelConfigFileNameContributor fileNameContributor) {
        super(project);
        this.$$$setupUI$$$();
        this.myPsiFiles = new HashSet<PsiFile>();
        this.myCustomConfigFiles = new ArrayList<VirtualFile>();
        this.myProject = project;
        this.myFileSet = fileSet;
        this.myFileNameContributor = fileNameContributor;
        this.myModule = fileSet.getFacet().getModule();
        this.setTitle(SpringBootApiBundle.message("spring.boot.customization.dialog.title", this.myFileSet.getName()));
        this.initUI();
        this.init();
    }

    protected void doOKAction() {
        CustomSetting.STRING configFileNameSetting = this.getConfigFileNameSetting();
        String configFileName = this.getConfigFileName();
        if (StringUtil.isEmpty((String)configFileName)) {
            configFileNameSetting.clear();
        } else {
            configFileNameSetting.setStringValue(configFileName);
        }
        CustomSetting.STRING customConfigFilesSetting = this.getCustomConfigFilesSetting();
        if (!this.myCustomConfigFiles.isEmpty()) {
            customConfigFilesSetting.setStringValue(StringUtil.join(this.myCustomConfigFiles, file -> file.getUrl(), (String)";"));
        } else {
            customConfigFilesSetting.clear();
        }
        super.doOKAction();
    }

    @NotNull
    private CustomSetting.STRING getConfigFileNameSetting() {
        return this.getCustomSetting(this.myFileNameContributor.getCustomNameSettingDescriptor().key);
    }

    @NotNull
    private CustomSetting.STRING getCustomConfigFilesSetting() {
        return this.getCustomSetting(this.myFileNameContributor.getCustomFilesSettingDescriptor().key);
    }

    @NotNull
    private CustomSetting.STRING getCustomSetting(Key<CustomSetting.STRING> id) {
        CustomSetting.STRING setting = (CustomSetting.STRING)this.myFileSet.getFacet().findSetting(id);
        assert (setting != null);
        CustomSetting.STRING sTRING = setting;
        if (sTRING == null) {
            SpringBootCustomizationDialog.$$$reportNull$$$0(0);
        }
        return sTRING;
    }

    protected boolean postponeValidation() {
        return false;
    }

    private void initUI() {
        SpringBootModelConfigFileNameContributor.CustomizationPresentation presentation = this.myFileNameContributor.getCustomizationPresentation();
        this.myConfigurationPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)presentation.customizationPanelTitle, (boolean)false));
        this.myKeyLabel.setText(String.format("<html><code>%s</code>:</html>", presentation.configFileKey));
        this.mySpringConfigNameTextField = new TextFieldWithAutoCompletion(this.myProject, (TextFieldWithAutoCompletionListProvider)new SpringConfigNameAutoCompletionListProvider(this.getSpringConfigNameProposals()), true, null);
        this.myTextFieldPanel.add((Component)this.mySpringConfigNameTextField);
        CustomSetting.STRING configFileNameSetting = this.getConfigFileNameSetting();
        @NlsSafe String defaultValue = configFileNameSetting.getDefaultValue();
        if (!Objects.equals(configFileNameSetting.getStringValue(), defaultValue)) {
            this.mySpringConfigNameTextField.setText(configFileNameSetting.getStringValue());
        }
        this.mySpringConfigNameTextField.setPlaceholder((CharSequence)SpringBootApiBundle.message("spring.boot.customization.dialog.config.not.set", defaultValue));
        this.mySpringConfigNameTextField.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                SpringBootCustomizationDialog.this.updateTree();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/spring/boot/facet/SpringBootCustomizationDialog$1", "documentChanged"));
            }
        });
        CustomSetting.STRING customConfigFilesSetting = this.getCustomConfigFilesSetting();
        String urls = customConfigFilesSetting.getStringValue();
        if (urls != null) {
            for (String url : StringUtil.split((String)urls, (String)";")) {
                VirtualFile customConfigFile = VirtualFileManager.getInstance().findFileByUrl(url);
                ContainerUtil.addIfNotNull(this.myCustomConfigFiles, (Object)customConfigFile);
            }
        }
        this.myFilesTree = new CheckboxTreeBase(new CheckboxTreeBase.CheckboxTreeCellRendererBase(){

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                ConfigFilesTreeBuilder.renderNode((Object)value, (boolean)expanded, (ColoredTreeCellRenderer)this.getTextRenderer());
                if (!(value instanceof DefaultMutableTreeNode)) {
                    return;
                }
                Object object = ((DefaultMutableTreeNode)value).getUserObject();
                if (object instanceof PsiFile) {
                    this.getTextRenderer().setIcon(SpringBootCustomizationDialog.this.myFileNameContributor.getFileIcon());
                } else if (object instanceof FileType) {
                    this.getTextRenderer().setIcon((Icon)SpringBootIconServiceImplKt.getSpringBootIconWithOverlay(AllIcons.Nodes.Folder));
                }
            }
        }, null, new CheckboxTreeBase.CheckPolicy(false, false, true, true)){

            protected boolean shouldShowBusyIconIfNeeded() {
                return true;
            }
        };
        ConfigFilesTreeBuilder.installSearch((JTree)this.myFilesTree);
        this.myFilesTreeBuilder = new ConfigFilesTreeBuilder((JTree)this.myFilesTree){

            protected DefaultMutableTreeNode createFileNode(Object file) {
                CheckedTreeNode node = new CheckedTreeNode(file);
                if (file instanceof PsiFile) {
                    node.setChecked(true);
                    node.setEnabled(SpringBootCustomizationDialog.this.myCustomConfigFiles.contains(((PsiFile)file).getVirtualFile()));
                } else {
                    node.setChecked(false);
                    node.setEnabled(false);
                }
                return node;
            }
        };
        this.myFilesTree.addCheckboxTreeListener(new CheckboxTreeListener(){

            public void nodeStateChanged(@NotNull CheckedTreeNode node) {
                Object userObject;
                if (node == null) {
                    5.$$$reportNull$$$0(0);
                }
                if ((userObject = node.getUserObject()) instanceof PsiFile) {
                    VirtualFile configFile = ((PsiFile)userObject).getVirtualFile();
                    if (node.isChecked()) {
                        SpringBootCustomizationDialog.this.myCustomConfigFiles.add(configFile);
                    } else {
                        SpringBootCustomizationDialog.this.myCustomConfigFiles.remove(configFile);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/spring/boot/facet/SpringBootCustomizationDialog$5", "nodeStateChanged"));
            }
        });
        this.myFilesTree.setRootVisible(false);
        this.myFilesTree.setShowsRootHandles(true);
        this.updateTree();
        JPanel panel = ToolbarDecorator.createDecorator((JTree)this.myFilesTree).setAddAction(button -> this.addCustomFiles()).setAddActionName(SpringBootApiBundle.message("spring.boot.customization.add.config.files.action", new Object[0])).createPanel();
        this.myTreePanel.add(panel);
    }

    private List<SpringConfigNameProposal> getSpringConfigNameProposals() {
        SmartList defaultConfigNames = new SmartList();
        for (SpringBootModelConfigFileNameContributor contributor : (SpringBootModelConfigFileNameContributor[])SpringBootModelConfigFileNameContributor.EP_NAME.getExtensions()) {
            if (!contributor.accept(this.myModule)) continue;
            defaultConfigNames.add(contributor.getCustomNameSettingDescriptor().defaultValue);
        }
        ArrayList<SpringConfigNameProposal> results = new ArrayList<SpringConfigNameProposal>();
        List<VirtualFile> directories = SpringBootModelConfigFileContributor.getConfigFileDirectories(this.myModule, false);
        if (directories.isEmpty()) {
            return results;
        }
        GlobalSearchScope searchScope = GlobalSearchScopesCore.directoriesScope((Project)this.myModule.getProject(), (boolean)false, (VirtualFile[])directories.toArray(VirtualFile.EMPTY_ARRAY));
        for (SpringBootModelConfigFileContributor contributor : (SpringBootModelConfigFileContributor[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions()) {
            FileType fileType = contributor.getFileType();
            Collection allFiles = FileTypeIndex.getFiles((FileType)fileType, (GlobalSearchScope)searchScope);
            for (VirtualFile file : allFiles) {
                String nameWithoutExtension = file.getNameWithoutExtension();
                if (StringUtil.containsChar((String)nameWithoutExtension, (char)'-') || defaultConfigNames.contains(nameWithoutExtension)) continue;
                Pair<List<VirtualFile>, List<VirtualFile>> configFiles = contributor.findApplicationConfigFiles(this.myModule, false, nameWithoutExtension);
                results.add(new SpringConfigNameProposal(fileType, nameWithoutExtension, ContainerUtil.concat((List)((List)configFiles.first), (List)((List)configFiles.second))));
            }
        }
        results.sort((o1, o2) -> StringUtil.naturalCompare((String)o1.myName, (String)o2.myName));
        return results;
    }

    private void addCustomFiles() {
        FileType[] configFileTypes = (FileType[])SpringBootModelConfigFileContributor.EP_NAME.getExtensionList().stream().map(SpringBootModelConfigFileContributor::getFileType).toArray(FileType[]::new);
        List<VirtualFile> configFiles = SpringBootConfigurationFileService.getInstance().findConfigFiles(this.myModule, false, (Condition<? super SpringBootModelConfigFileNameContributor>)((Condition)contributor -> !contributor.equals(this.myFileNameContributor) && contributor.accept(this.myModule)));
        HashSet<VirtualFile> configFilesFromDifferentContributors = new HashSet<VirtualFile>(configFiles);
        configFilesFromDifferentContributors.addAll(SpringBootConfigurationFileService.getInstance().collectImports(this.myModule, configFiles));
        FileChooserDescriptor chooserDescriptor = FileChooserDescriptorFactory.createMultipleFilesNoJarsDescriptor().withExtensionFilter(SpringBootApiBundle.message("application.config.rename.option", new Object[0]), configFileTypes).withFileFilter(file -> !configFilesFromDifferentContributors.contains(file) && !ContainerUtil.exists(this.myPsiFiles, psiFile -> psiFile.getVirtualFile().equals(file))).withShowHiddenFiles(false).withTitle(SpringBootApiBundle.message("spring.boot.config.chooser.dialog.title", new Object[0])).withRoots(ModuleRootManager.getInstance((Module)this.myModule).getContentRoots());
        FileChooserDialog fileChooser = FileChooserFactory.getInstance().createFileChooser(chooserDescriptor, this.myProject, (Component)this.myMainPanel);
        Object[] files = fileChooser.choose(this.myProject, new VirtualFile[0]);
        if (files.length != 0) {
            ContainerUtil.addAll(this.myCustomConfigFiles, (Object[])files);
            this.updateTree();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTree() {
        CheckedTreeNode myRoot = new CheckedTreeNode(null);
        this.myFilesTree.setModel((TreeModel)new DefaultTreeModel((TreeNode)myRoot));
        this.myPsiFiles.clear();
        this.myFilesTree.setPaintBusy(true);
        try {
            ConfigFileSearcher[] searchers;
            for (ConfigFileSearcher searcher : searchers = this.getSearchers()) {
                this.myPsiFiles.addAll(searcher.searchWithFiles());
            }
            this.myFilesTreeBuilder.buildTree((DefaultMutableTreeNode)this.myFilesTree.getModel().getRoot(), searchers);
            TreeUtil.expandAll((JTree)this.myFilesTree);
        }
        finally {
            this.myFilesTree.setPaintBusy(false);
        }
    }

    private ConfigFileSearcher[] getSearchers() {
        final PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        final String defaultConfigName = this.getConfigFileNameSetting().getDefaultValue();
        this.foundConfigFilesByName = false;
        SmartList searchers = new SmartList();
        for (final SpringBootModelConfigFileContributor contributor : (SpringBootModelConfigFileContributor[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions()) {
            ConfigFileSearcher searcher = new ConfigFileSearcher(this.myModule, this.myModule.getProject()){

                public Set<PsiFile> search(@Nullable Module module, @NotNull Project project) {
                    if (project == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    assert (module != null);
                    SmartList allConfigFiles = new SmartList();
                    String configName = StringUtil.defaultIfEmpty((String)SpringBootCustomizationDialog.this.getConfigFileName(), (String)defaultConfigName);
                    Pair<List<VirtualFile>, List<VirtualFile>> configFiles = contributor.findApplicationConfigFiles(module, false, configName);
                    if (!((List)configFiles.first).isEmpty() || !((List)configFiles.second).isEmpty()) {
                        SpringBootCustomizationDialog.this.foundConfigFilesByName = true;
                    }
                    allConfigFiles.addAll((Collection)configFiles.first);
                    allConfigFiles.addAll((Collection)configFiles.second);
                    allConfigFiles.addAll(SpringBootConfigurationFileService.getInstance().collectImports(module, (List<VirtualFile>)allConfigFiles));
                    return new LinkedHashSet<PsiFile>(PsiUtilCore.toPsiFiles((PsiManager)psiManager, (Collection)allConfigFiles));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/facet/SpringBootCustomizationDialog$6", "search"));
                }
            };
            searchers.add(searcher);
        }
        searchers.add(new ConfigFileSearcher(this.myModule, this.myModule.getProject()){

            public Set<PsiFile> search(@Nullable Module module, @NotNull Project project) {
                if (project == null) {
                    7.$$$reportNull$$$0(0);
                }
                List customConfigFiles = module == null ? SpringBootCustomizationDialog.this.myCustomConfigFiles : ContainerUtil.concat(SpringBootCustomizationDialog.this.myCustomConfigFiles, SpringBootConfigurationFileService.getInstance().collectImports(module, SpringBootCustomizationDialog.this.myCustomConfigFiles));
                return new LinkedHashSet<PsiFile>(PsiUtilCore.toPsiFiles((PsiManager)psiManager, (Collection)customConfigFiles));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/facet/SpringBootCustomizationDialog$7", "search"));
            }
        });
        return searchers.toArray(new ConfigFileSearcher[0]);
    }

    private String getConfigFileName() {
        return this.mySpringConfigNameTextField.getText();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (!this.foundConfigFilesByName) {
            return new ValidationInfo(SpringBootApiBundle.message("spring.boot.customization.dialog.no.configs", StringUtil.defaultIfEmpty((String)this.getConfigFileName(), (String)this.getConfigFileNameSetting().getDefaultValue())), this.mySpringConfigNameTextField).asWarning().withOKEnabled();
        }
        return null;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "SpringBootCustomization";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBLabel jBLabel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myMainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myConfigurationPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myTreePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.setToolTipText(DynamicBundle.getBundle((String)"messages/SpringBootApiBundle", SpringBootCustomizationDialog.class).getString("spring.boot.customization.dialog.config.tree.tooltip"));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 7, 3, null, null, null));
        this.myKeyLabel = jBLabel = new JBLabel();
        jBLabel.setText("");
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 2, 2, 1, 0, 1, 6, 1, null, null, null));
        this.myTextFieldPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, new Dimension(250, -1), null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/facet/SpringBootCustomizationDialog", "getCustomSetting"));
    }

    private static final class SpringConfigNameAutoCompletionListProvider
    extends TextFieldWithAutoCompletionListProvider<SpringConfigNameProposal> {
        private SpringConfigNameAutoCompletionListProvider(List<SpringConfigNameProposal> variants) {
            super(variants);
        }

        @NotNull
        protected String getLookupString(@NotNull SpringConfigNameProposal item) {
            if (item == null) {
                SpringConfigNameAutoCompletionListProvider.$$$reportNull$$$0(0);
            }
            String string = item.myName;
            if (string == null) {
                SpringConfigNameAutoCompletionListProvider.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected String getTypeText(@NotNull SpringConfigNameProposal item) {
            if (item == null) {
                SpringConfigNameAutoCompletionListProvider.$$$reportNull$$$0(2);
            }
            return "(." + item.myFileType.getDefaultExtension() + ")";
        }

        public String getAdvertisement() {
            return SpringBootApiBundle.message("spring.boot.config.files.add.ad", new Object[0]);
        }

        protected String getTailText(@NotNull SpringConfigNameProposal item) {
            if (item == null) {
                SpringConfigNameAutoCompletionListProvider.$$$reportNull$$$0(3);
            }
            List<VirtualFile> configFiles = item.myConfigFilesByName;
            StringBuilder tailText = new StringBuilder(" ");
            if (configFiles.size() > 1) {
                tailText.append("[Detected Profiles: ");
                SmartList profileNames = new SmartList();
                for (VirtualFile file : configFiles) {
                    String nameWithoutExtension = file.getNameWithoutExtension();
                    if (!StringUtil.containsChar((String)nameWithoutExtension, (char)'-')) continue;
                    profileNames.add(StringUtil.substringAfter((String)nameWithoutExtension, (String)"-"));
                }
                tailText.append(StringUtil.join((Collection)profileNames, (String)", "));
                tailText.append("] ");
            }
            return tailText.toString();
        }

        @Nullable
        protected Icon getIcon(@NotNull SpringConfigNameProposal item) {
            if (item == null) {
                SpringConfigNameAutoCompletionListProvider.$$$reportNull$$$0(4);
            }
            return item.myFileType.getIcon();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/boot/facet/SpringBootCustomizationDialog$SpringConfigNameAutoCompletionListProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/boot/facet/SpringBootCustomizationDialog$SpringConfigNameAutoCompletionListProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getLookupString";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getTypeText";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getTailText";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getIcon";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class SpringConfigNameProposal {
        private final FileType myFileType;
        private final String myName;
        private final List<VirtualFile> myConfigFilesByName;

        private SpringConfigNameProposal(FileType fileType, String name, List<VirtualFile> configFilesByName) {
            this.myFileType = fileType;
            this.myName = name;
            this.myConfigFilesByName = configFilesByName;
        }
    }
}

