/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.json.additional;

import com.intellij.codeInsight.navigation.impl.PsiTargetPresentationRenderer;
import com.intellij.json.JsonUtil;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.boot.SpringBootApiBundle;
import com.intellij.spring.boot.SpringBootApiIcons;
import com.intellij.spring.boot.application.metadata.additional.SpringBootAdditionalConfigUtils;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootAdditionalConfigAnnotator
implements Annotator {
    private static final boolean DEBUG_MODE = ApplicationManager.getApplication().isUnitTestMode();

    private static PsiTargetPresentationRenderer<PsiElement> getGotoHintGutterCellRenderer() {
        return new PsiTargetPresentationRenderer<PsiElement>(){

            @NotNull
            public String getElementText(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                JsonValue value = ((JsonProperty)element).getValue();
                assert (value != null);
                String string = StringUtil.notNullize((String)((JsonStringLiteral)value).getValue());
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Nullable
            public String getContainerText(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(2);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/boot/json/additional/SpringBootAdditionalConfigAnnotator$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/boot/json/additional/SpringBootAdditionalConfigAnnotator$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElementText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getElementText";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getContainerText";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        String name;
        if (element == null) {
            SpringBootAdditionalConfigAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            SpringBootAdditionalConfigAnnotator.$$$reportNull$$$0(1);
        }
        if (!(element instanceof JsonProperty)) {
            return;
        }
        JsonProperty jsonProperty = (JsonProperty)element;
        PsiFile file = holder.getCurrentAnnotationSession().getFile();
        if (!SpringBootAdditionalConfigUtils.isAdditionalMetadataFile(file)) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (SpringBootLibraryUtil.isBelowVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_1_2_0)) {
            return;
        }
        switch (name = jsonProperty.getName()) {
            case "type": 
            case "sourceType": 
            case "target": {
                SpringBootAdditionalConfigAnnotator.highlight(holder, jsonProperty, DefaultLanguageHighlighterColors.CLASS_REFERENCE);
                break;
            }
            case "description": 
            case "reason": {
                SpringBootAdditionalConfigAnnotator.highlight(holder, jsonProperty, DefaultLanguageHighlighterColors.DOC_COMMENT);
                break;
            }
            case "defaultValue": {
                SpringBootAdditionalConfigAnnotator.highlight(holder, jsonProperty, DefaultLanguageHighlighterColors.METADATA);
                break;
            }
            case "value": {
                SpringBootAdditionalConfigAnnotator.highlight(holder, jsonProperty, DefaultLanguageHighlighterColors.PARAMETER);
                break;
            }
            case "name": {
                if (!SpringBootLibraryUtil.isAtLeastVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0)) break;
                SpringBootAdditionalConfigAnnotator.installHintsGutterIcon(holder, (JsonFile)file, jsonProperty);
            }
        }
    }

    private static void highlight(AnnotationHolder holder, @NotNull JsonProperty jsonProperty, TextAttributesKey key) {
        JsonValue value;
        if (jsonProperty == null) {
            SpringBootAdditionalConfigAnnotator.$$$reportNull$$$0(2);
        }
        if ((value = jsonProperty.getValue()) != null) {
            String message = DEBUG_MODE ? key.getExternalName() : null;
            (message == null ? holder.newSilentAnnotation(HighlightSeverity.INFORMATION) : holder.newAnnotation(HighlightSeverity.INFORMATION, message)).range((PsiElement)value).textAttributes(key).create();
        }
    }

    private static void installHintsGutterIcon(AnnotationHolder holder, JsonFile file, JsonProperty nameProperty) {
        List<JsonProperty> hintProperties = SpringBootAdditionalConfigAnnotator.findHints(file, nameProperty);
        if (hintProperties.isEmpty()) {
            return;
        }
        SpringGutterIconBuilder.createBuilder((Icon)SpringBootApiIcons.Gutter.SpringBoot).setTooltipText(SpringBootApiBundle.message("goto.hint.tooltip", hintProperties.size())).setTargetRenderer(SpringBootAdditionalConfigAnnotator::getGotoHintGutterCellRenderer).setTargets(hintProperties).createGutterIcon(holder, (PsiElement)nameProperty);
    }

    @NotNull
    private static List<JsonProperty> findHints(JsonFile file, JsonProperty nameProperty) {
        JsonProperty parentProperty = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)nameProperty, JsonProperty.class);
        if (parentProperty == null) {
            List<JsonProperty> list = Collections.emptyList();
            if (list == null) {
                SpringBootAdditionalConfigAnnotator.$$$reportNull$$$0(3);
            }
            return list;
        }
        if (!parentProperty.getName().equals("properties")) {
            List<JsonProperty> list = Collections.emptyList();
            if (list == null) {
                SpringBootAdditionalConfigAnnotator.$$$reportNull$$$0(4);
            }
            return list;
        }
        JsonStringLiteral namePropertyValue = (JsonStringLiteral)ObjectUtils.tryCast((Object)nameProperty.getValue(), JsonStringLiteral.class);
        if (namePropertyValue == null) {
            List<JsonProperty> list = Collections.emptyList();
            if (list == null) {
                SpringBootAdditionalConfigAnnotator.$$$reportNull$$$0(5);
            }
            return list;
        }
        String propertyName = namePropertyValue.getValue();
        JsonObject topValue = (JsonObject)ObjectUtils.tryCast((Object)file.getTopLevelValue(), JsonObject.class);
        if (topValue == null) {
            List<JsonProperty> list = Collections.emptyList();
            if (list == null) {
                SpringBootAdditionalConfigAnnotator.$$$reportNull$$$0(6);
            }
            return list;
        }
        JsonArray hintsArray = (JsonArray)JsonUtil.getPropertyValueOfType((JsonObject)topValue, (String)"hints", JsonArray.class);
        if (hintsArray == null) {
            List<JsonProperty> list = Collections.emptyList();
            if (list == null) {
                SpringBootAdditionalConfigAnnotator.$$$reportNull$$$0(7);
            }
            return list;
        }
        SmartList hintProperties = new SmartList();
        for (JsonValue hint : hintsArray.getValueList()) {
            String name;
            JsonStringLiteral nameValue;
            JsonProperty hintNameProperty;
            JsonObject hintObject = (JsonObject)ObjectUtils.tryCast((Object)hint, JsonObject.class);
            if (hintObject == null || (hintNameProperty = hintObject.findProperty("name")) == null || (nameValue = (JsonStringLiteral)ObjectUtils.tryCast((Object)hintNameProperty.getValue(), JsonStringLiteral.class)) == null || !StringUtil.startsWith((CharSequence)(name = nameValue.getValue()), (CharSequence)propertyName) || !name.equals(propertyName) && !name.equals(propertyName + ".keys") && !name.equals(propertyName + ".values")) continue;
            hintProperties.add(hintNameProperty);
        }
        SmartList smartList = hintProperties;
        if (smartList == null) {
            SpringBootAdditionalConfigAnnotator.$$$reportNull$$$0(8);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonProperty";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/json/additional/SpringBootAdditionalConfigAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/json/additional/SpringBootAdditionalConfigAnnotator";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findHints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "highlight";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

