/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model;

import com.intellij.model.search.SearchContext;
import com.intellij.model.search.SearchService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.spring.SpringAutodetectedModelsSearcher;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.boot.application.SpringBootApplicationService;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootApplicationLocalModel;
import com.intellij.spring.boot.model.SpringBootAutodetectedFilesetsSearcher;
import com.intellij.spring.boot.model.autoconfigure.AutoConfigClassCollector;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContextBase;
import com.intellij.spring.boot.model.autoconfigure.jam.EnableAutoConfiguration;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.SpringLocalModelUtils;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringFunctionalSearchersUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.profiles.SpringProfilesService;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;

public class SpringBootAutodetectedModelsSearcher
implements SpringAutodetectedModelsSearcher {
    @NotNull
    public Set<SpringModel> getAutodetectedModels(@NotNull Module module, @NotNull Module contextModule) {
        if (module == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(0);
        }
        if (contextModule == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(1);
        }
        if (!SpringBootLibraryUtil.hasSpringBootLibrary(module)) {
            Set<SpringModel> set = Collections.emptySet();
            if (set == null) {
                SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(2);
            }
            return set;
        }
        List<PsiClass> springApplications = SpringBootApplicationService.getInstance().getSpringApplications(module);
        if (springApplications.isEmpty() && !SpringBootAutodetectedModelsSearcher.hasSpringBootApplicationInDependentModules(module)) {
            Set<SpringModel> models2 = SpringBootAutodetectedModelsSearcher.getStarterModels(module);
            Set<SpringModel> set = models2.isEmpty() ? SpringBootAutodetectedModelsSearcher.getNonBootLauncherModels(module) : models2;
            if (set == null) {
                SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(3);
            }
            return set;
        }
        return SpringBootAutodetectedModelsSearcher.getSpringBootApplicationModels(contextModule, springApplications);
    }

    @NotNull
    private static Set<SpringModel> getNonBootLauncherModels(@NotNull Module module) {
        if (module == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(4);
        }
        Set<SpringModel> set = SpringBootAutodetectedModelsSearcher.getSpringApplicationLauncherConfigurations(module).stream().map(launcherConfig -> launcherConfig.getLocalModels(module)).map(models2 -> SpringModelUtils.getInstance().getCombinedSpringModel(models2, module)).collect(Collectors.toSet());
        if (set == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(5);
        }
        return set;
    }

    private static boolean hasSpringBootApplicationInDependentModules(@NotNull Module module) {
        if (module == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(6);
        }
        LinkedHashSet dependentModules = new LinkedHashSet();
        ModuleUtilCore.collectModulesDependsOn((Module)module, dependentModules);
        for (Module dependentModule : dependentModules) {
            if (SpringBootApplicationService.getInstance().getSpringApplications(dependentModule).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static Set<SpringModel> getSpringBootApplicationModels(@NotNull Module module, @NotNull List<PsiClass> springApplications) {
        Set<LauncherConfigurations> launcherConfigurations;
        if (module == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(7);
        }
        if (springApplications == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(8);
        }
        if ((launcherConfigurations = SpringBootAutodetectedModelsSearcher.getSpringApplicationLauncherConfigurations(module)).isEmpty()) {
            Set localModels2 = ContainerUtil.map2Set(springApplications, aClass -> SpringBootAutodetectedModelsSearcher.createSpringBootApplicationModel(module, aClass));
            Set<SpringModel> set = localModels2.isEmpty() ? Collections.emptySet() : Collections.singleton(SpringModelUtils.getInstance().getCombinedSpringModel(localModels2, module));
            if (set == null) {
                SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(9);
            }
            return set;
        }
        HashSet<SpringModel> models2 = new HashSet<SpringModel>();
        for (PsiClass springApplication : springApplications) {
            models2.addAll(SpringBootAutodetectedModelsSearcher.createCombinedSpringBootLauncherModels(module, springApplication, launcherConfigurations));
        }
        models2.addAll(launcherConfigurations.stream().filter(launcherConfiguration -> !SpringBootAutodetectedModelsSearcher.containsAny(launcherConfiguration, springApplications)).map(launcherConfig -> launcherConfig.getLocalModels(module)).map(localModels -> SpringModelUtils.getInstance().getCombinedSpringModel(localModels, module)).collect(Collectors.toSet()));
        HashSet<SpringModel> hashSet = models2;
        if (hashSet == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    private static boolean containsAny(@NotNull LauncherConfigurations launcherConfiguration, @NotNull List<PsiClass> springApplications) {
        if (launcherConfiguration == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(11);
        }
        if (springApplications == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(12);
        }
        for (PsiClass springApplication : springApplications) {
            if (!launcherConfiguration.configurations.contains(springApplication)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static Set<SpringModel> createCombinedSpringBootLauncherModels(@NotNull Module module, @NotNull PsiClass springApplication, @NotNull Set<LauncherConfigurations> configurations) {
        if (module == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(13);
        }
        if (springApplication == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(14);
        }
        if (configurations == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(15);
        }
        SpringBootApplicationLocalModel springBootApplicationModel = SpringBootAutodetectedModelsSearcher.createSpringBootApplicationModel(module, springApplication);
        HashSet<SpringModel> launcherModels = new HashSet<SpringModel>();
        for (LauncherConfigurations launcherConfigurations : configurations) {
            Set<PsiClass> additionalConfigurations;
            if (!launcherConfigurations.configurations.contains(springApplication) || (additionalConfigurations = SpringBootAutodetectedModelsSearcher.getAdditionalConfigurations(springApplication, launcherConfigurations)).isEmpty()) continue;
            launcherModels.add(SpringBootAutodetectedModelsSearcher.getCombinedModel(module, springBootApplicationModel, additionalConfigurations));
        }
        Set<SpringModel> set = launcherModels.isEmpty() ? Collections.singleton(SpringModelUtils.getInstance().getCombinedSpringModel(Collections.singleton(springBootApplicationModel), module)) : launcherModels;
        if (set == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(16);
        }
        return set;
    }

    @NotNull
    private static SpringModel getCombinedModel(@NotNull Module module, @NotNull SpringBootApplicationLocalModel model, @NotNull Set<PsiClass> additionalConfigurations) {
        if (module == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(17);
        }
        if (model == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(18);
        }
        if (additionalConfigurations == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(19);
        }
        HashSet<SpringBootApplicationLocalModel> models2 = new HashSet<SpringBootApplicationLocalModel>();
        models2.add(model);
        models2.addAll(additionalConfigurations.stream().map(psiClass -> SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(psiClass, module, Collections.emptySet())).filter(Objects::nonNull).collect(Collectors.toSet()));
        SpringModel springModel = SpringModelUtils.getInstance().getCombinedSpringModel(models2, module);
        if (springModel == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(20);
        }
        return springModel;
    }

    @NotNull
    private static Set<PsiClass> getAdditionalConfigurations(@NotNull PsiClass application, @NotNull LauncherConfigurations launcherConfigurations) {
        if (application == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(21);
        }
        if (launcherConfigurations == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(22);
        }
        Set<PsiClass> set = launcherConfigurations.configurations.stream().filter(psiClass -> !psiClass.equals(application)).collect(Collectors.toSet());
        if (set == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(23);
        }
        return set;
    }

    @NotNull
    private static SpringBootApplicationLocalModel createSpringBootApplicationModel(@NotNull Module module, PsiClass aClass) {
        if (module == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(24);
        }
        return new SpringBootApplicationLocalModel(aClass, module, SpringProfilesService.getInstance((Project)module.getProject()).getActiveProfiles(module));
    }

    private static Set<SpringModel> getStarterModels(@NotNull Module module) {
        if (module == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(25);
        }
        if (!Registry.is((String)"spring.boot.starter.autodetected.fileset")) {
            return Collections.emptySet();
        }
        PsiClass contextClass = SpringBootAutodetectedFilesetsSearcher.findAutoConfiguration(module);
        if (contextClass == null) {
            return Collections.emptySet();
        }
        Set models2 = SpringLocalModelUtils.getLocalAnnotationModels((Module)module, new HashSet<PsiClass>(AutoConfigClassCollector.collectConfigurationClasses((EnableAutoConfiguration)null, (ConditionalOnEvaluationContext)SpringBootAutodetectedModelsSearcher.createContext(module, contextClass))), (Set)SpringProfilesService.getInstance((Project)module.getProject()).getActiveProfiles(module));
        return models2.isEmpty() ? Collections.emptySet() : Collections.singleton(SpringModelUtils.getInstance().getCombinedSpringModel(models2, module));
    }

    @NotNull
    private static ConditionalOnEvaluationContextBase createContext(@NotNull Module module, PsiClass contextClass) {
        if (module == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(26);
        }
        return new ConditionalOnEvaluationContextBase(contextClass, module, null, (NotNullLazyValue<? extends List<VirtualFile>>)NotNullLazyValue.lazy(() -> Collections.emptyList()), null);
    }

    @NotNull
    private static Set<LauncherConfigurations> getSpringApplicationLauncherConfigurations(@NotNull Module module) {
        if (module == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(27);
        }
        HashSet configurations = new HashSet();
        RecursionManager.runInNewContext(() -> {
            Set<? extends LocalSearchScope> launcherScopes = SpringBootAutodetectedModelsSearcher.getSpringApplicationLauncherScopes(module);
            if (launcherScopes.isEmpty()) {
                return;
            }
            PsiClass springApplicationClass = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.boot.SpringApplication");
            if (springApplicationClass == null) {
                return;
            }
            PsiMethod[] constructors = SpringFunctionalSearchersUtils.findMethods((String)"SpringApplication", (PsiClass)springApplicationClass);
            PsiMethod[] runs = SpringFunctionalSearchersUtils.findMethods((String)"run", (PsiClass)springApplicationClass);
            configurations.addAll(SpringBootAutodetectedModelsSearcher.getLauncherConfigurations(module, runs, launcherScopes));
            configurations.addAll(SpringBootAutodetectedModelsSearcher.getLauncherConfigurations(module, constructors, launcherScopes));
        });
        Set<LauncherConfigurations> set = configurations.isEmpty() ? Collections.emptySet() : configurations;
        if (set == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(28);
        }
        return set;
    }

    @NotNull
    private static Set<LauncherConfigurations> getLauncherConfigurations(@NotNull Module module, PsiMethod[] methods, @NotNull Set<? extends LocalSearchScope> launcherScopes) {
        if (module == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(29);
        }
        if (launcherScopes == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(30);
        }
        HashSet<LauncherConfigurations> configurations = new HashSet<LauncherConfigurations>();
        for (PsiMethod runMethod : methods) {
            for (LocalSearchScope localSearchScope : launcherScopes) {
                for (UCallExpression uCallExpression : SpringFunctionalSearchersUtils.findMethodCallsWithSearchService((PsiMethod)runMethod, (SearchScope)localSearchScope)) {
                    Set<PsiClass> classes = SpringBootAutodetectedModelsSearcher.getConfigurationClasses(module, uCallExpression);
                    if (classes.isEmpty()) continue;
                    configurations.add(new LauncherConfigurations(uCallExpression, classes));
                }
            }
        }
        HashSet<LauncherConfigurations> hashSet = configurations;
        if (hashSet == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(31);
        }
        return hashSet;
    }

    private static Set<PsiClass> getConfigurationClasses(@NotNull Module module, @NotNull UCallExpression uCallExpression) {
        if (module == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(32);
        }
        if (uCallExpression == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(33);
        }
        HashSet<PsiClass> configurations = new HashSet<PsiClass>();
        for (UExpression argument : uCallExpression.getValueArguments()) {
            if (argument instanceof UClassLiteralExpression) {
                ContainerUtil.addIfNotNull(configurations, (Object)SpringBootAutodetectedModelsSearcher.getClassConfiguration((UClassLiteralExpression)argument));
                continue;
            }
            if (!(argument instanceof UCallExpression)) continue;
            for (UExpression valueArgument : ((UCallExpression)argument).getValueArguments()) {
                if (!(valueArgument instanceof UClassLiteralExpression)) continue;
                ContainerUtil.addIfNotNull(configurations, (Object)SpringBootAutodetectedModelsSearcher.getClassConfiguration((UClassLiteralExpression)valueArgument));
            }
        }
        return configurations;
    }

    @Nullable
    private static PsiClass getClassConfiguration(UClassLiteralExpression argument) {
        PsiType type = argument.getType();
        return type instanceof PsiClassType ? ((PsiClassType)type).resolve() : null;
    }

    @NotNull
    private static Set<? extends LocalSearchScope> getSpringApplicationLauncherScopes(@NotNull Module module) {
        if (module == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(34);
        }
        Set set = SearchService.getInstance().searchWord(module.getProject(), "SpringApplication").inContexts(SearchContext.IN_CODE, new SearchContext[0]).inScope((SearchScope)module.getModuleRuntimeScope(false)).buildQuery(occurrence -> {
            if (occurrence.getOffsetInStart() != 0) {
                return Collections.emptySet();
            }
            UClass aClass = (UClass)UastContextKt.getUastParentOfType((PsiElement)occurrence.getStart(), UClass.class);
            return aClass != null ? Collections.singleton(aClass) : Collections.emptySet();
        }).findAll().stream().map(aClass -> new LocalSearchScope((PsiElement)aClass.getJavaPsi())).collect(Collectors.toSet());
        if (set == null) {
            SpringBootAutodetectedModelsSearcher.$$$reportNull$$$0(35);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 9, 10, 16, 20, 23, 28, 31, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextModule";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 16: 
            case 20: 
            case 23: 
            case 28: 
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/model/SpringBootAutodetectedModelsSearcher";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springApplications";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcherConfiguration";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springApplication";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalConfigurations";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "application";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcherConfigurations";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcherScopes";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uCallExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/model/SpringBootAutodetectedModelsSearcher";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutodetectedModels";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonBootLauncherModels";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringBootApplicationModels";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createCombinedSpringBootLauncherModels";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCombinedModel";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalConfigurations";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringApplicationLauncherConfigurations";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getLauncherConfigurations";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringApplicationLauncherScopes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAutodetectedModels";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 16: 
            case 20: 
            case 23: 
            case 28: 
            case 31: 
            case 35: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNonBootLauncherModels";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasSpringBootApplicationInDependentModules";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSpringBootApplicationModels";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "containsAny";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createCombinedSpringBootLauncherModels";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCombinedModel";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalConfigurations";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createSpringBootApplicationModel";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getStarterModels";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createContext";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getSpringApplicationLauncherConfigurations";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getLauncherConfigurations";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationClasses";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getSpringApplicationLauncherScopes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 9, 10, 16, 20, 23, 28, 31, 35 -> new IllegalStateException(string);
        };
    }

    private record LauncherConfigurations(@NotNull UCallExpression expression, @NotNull Set<PsiClass> configurations) {
        @NotNull
        private final UCallExpression expression;
        @NotNull
        private final Set<PsiClass> configurations;

        private LauncherConfigurations(@NotNull UCallExpression expression, @NotNull Set<PsiClass> configurations) {
            if (expression == null) {
                LauncherConfigurations.$$$reportNull$$$0(0);
            }
            if (configurations == null) {
                LauncherConfigurations.$$$reportNull$$$0(1);
            }
        }

        public Set<LocalAnnotationModel> getLocalModels(@NotNull Module module) {
            if (module == null) {
                LauncherConfigurations.$$$reportNull$$$0(2);
            }
            return this.configurations.stream().map(psiClass -> SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(psiClass, module, Collections.emptySet())).filter(Objects::nonNull).collect(Collectors.toSet());
        }

        @NotNull
        public UCallExpression expression() {
            UCallExpression uCallExpression = this.expression;
            if (uCallExpression == null) {
                LauncherConfigurations.$$$reportNull$$$0(3);
            }
            return uCallExpression;
        }

        @NotNull
        public Set<PsiClass> configurations() {
            Set<PsiClass> set = this.configurations;
            if (set == null) {
                LauncherConfigurations.$$$reportNull$$$0(4);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurations";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/boot/model/SpringBootAutodetectedModelsSearcher$LauncherConfigurations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/boot/model/SpringBootAutodetectedModelsSearcher$LauncherConfigurations";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "expression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "configurations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getLocalModels";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

