/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\tB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/spring/boot/model/SpringBootConfigFileModificationTracker;", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "dispose", "", "MyVirtualFileListener", "intellij.spring.boot.core"})
public final class SpringBootConfigFileModificationTracker
extends SimpleModificationTracker
implements Disposable {
    public SpringBootConfigFileModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        connection.subscribe(topic, (Object)new BulkVirtualFileListenerAdapter((VirtualFileListener)new MyVirtualFileListener(project)));
    }

    public void dispose() {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/spring/boot/model/SpringBootConfigFileModificationTracker$MyVirtualFileListener;", "Lcom/intellij/openapi/vfs/VirtualFileListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/spring/boot/model/SpringBootConfigFileModificationTracker;Lcom/intellij/openapi/project/Project;)V", "fileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "Lorg/jetbrains/annotations/NotNull;", "fileTypes", "", "Lcom/intellij/openapi/fileTypes/FileType;", "kotlin.jvm.PlatformType", "fileCreated", "", "event", "Lcom/intellij/openapi/vfs/VirtualFileEvent;", "beforeFileDeletion", "fileMoved", "Lcom/intellij/openapi/vfs/VirtualFileMoveEvent;", "propertyChanged", "Lcom/intellij/openapi/vfs/VirtualFilePropertyEvent;", "incModificationCountIfMine", "intellij.spring.boot.core"})
    @SourceDebugExtension(value={"SMAP\nSpringBootConfigFileModificationTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBootConfigFileModificationTracker.kt\ncom/intellij/spring/boot/model/SpringBootConfigFileModificationTracker$MyVirtualFileListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n1557#2:51\n1628#2,3:52\n*S KotlinDebug\n*F\n+ 1 SpringBootConfigFileModificationTracker.kt\ncom/intellij/spring/boot/model/SpringBootConfigFileModificationTracker$MyVirtualFileListener\n*L\n23#1:51\n23#1:52,3\n*E\n"})
    private final class MyVirtualFileListener
    implements VirtualFileListener {
        @NotNull
        private final ProjectFileIndex fileIndex;
        @NotNull
        private final List<FileType> fileTypes;

        /*
         * WARNING - void declaration
         */
        public MyVirtualFileListener(Project project) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
            this.fileIndex = projectFileIndex;
            Iterable iterable = SpringBootModelConfigFileContributor.EP_NAME.getExtensionList();
            MyVirtualFileListener myVirtualFileListener = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SpringBootModelConfigFileContributor springBootModelConfigFileContributor = (SpringBootModelConfigFileContributor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getFileType());
            }
            myVirtualFileListener.fileTypes = (List)destination$iv$iv;
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.incModificationCountIfMine(event);
        }

        public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.incModificationCountIfMine(event);
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.incModificationCountIfMine((VirtualFileEvent)event);
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (Intrinsics.areEqual((Object)event.getPropertyName(), (Object)"name")) {
                this.incModificationCountIfMine((VirtualFileEvent)event);
            }
        }

        private final void incModificationCountIfMine(VirtualFileEvent event) {
            VirtualFile virtualFile = event.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            VirtualFile file = virtualFile;
            if (this.fileIndex.isInContent(file) && (file.isDirectory() || this.fileTypes.contains(file.getFileType()))) {
                SpringBootConfigFileModificationTracker.this.incModificationCount();
            }
        }
    }
}

