/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiClass;
import com.intellij.spring.boot.application.SpringBootApplicationService;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.beans.CustomSetting;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringBootModelConfigFileNameContributor {
    public static final ExtensionPointName<SpringBootModelConfigFileNameContributor> EP_NAME = ExtensionPointName.create((String)"com.intellij.spring.boot.modelConfigFileNameContributor");
    private final CustomSettingDescriptor myCustomNameSettingDescriptor;
    private final CustomSettingDescriptor myCustomFilesSettingDescriptor;
    private final CustomizationPresentation myCustomizationPresentation;

    protected SpringBootModelConfigFileNameContributor(@NotNull CustomSettingDescriptor customNameSettingDescriptor, @NotNull CustomSettingDescriptor customFilesSettingDescriptor, @NotNull CustomizationPresentation presentation) {
        if (customNameSettingDescriptor == null) {
            SpringBootModelConfigFileNameContributor.$$$reportNull$$$0(0);
        }
        if (customFilesSettingDescriptor == null) {
            SpringBootModelConfigFileNameContributor.$$$reportNull$$$0(1);
        }
        if (presentation == null) {
            SpringBootModelConfigFileNameContributor.$$$reportNull$$$0(2);
        }
        this.myCustomNameSettingDescriptor = customNameSettingDescriptor;
        this.myCustomFilesSettingDescriptor = customFilesSettingDescriptor;
        this.myCustomizationPresentation = presentation;
    }

    @NotNull
    public final CustomSettingDescriptor getCustomNameSettingDescriptor() {
        CustomSettingDescriptor customSettingDescriptor = this.myCustomNameSettingDescriptor;
        if (customSettingDescriptor == null) {
            SpringBootModelConfigFileNameContributor.$$$reportNull$$$0(3);
        }
        return customSettingDescriptor;
    }

    @NotNull
    public final CustomSettingDescriptor getCustomFilesSettingDescriptor() {
        CustomSettingDescriptor customSettingDescriptor = this.myCustomFilesSettingDescriptor;
        if (customSettingDescriptor == null) {
            SpringBootModelConfigFileNameContributor.$$$reportNull$$$0(4);
        }
        return customSettingDescriptor;
    }

    @NotNull
    public CustomizationPresentation getCustomizationPresentation() {
        CustomizationPresentation customizationPresentation = this.myCustomizationPresentation;
        if (customizationPresentation == null) {
            SpringBootModelConfigFileNameContributor.$$$reportNull$$$0(5);
        }
        return customizationPresentation;
    }

    @NotNull
    public abstract Icon getFileIcon();

    public abstract boolean accept(SpringFileSet var1);

    public abstract boolean accept(Module var1);

    @NotNull
    public String getSpringConfigName(@NotNull Module module) {
        SpringFacet springFacet;
        if (module == null) {
            SpringBootModelConfigFileNameContributor.$$$reportNull$$$0(6);
        }
        if ((springFacet = SpringBootModelConfigFileNameContributor.getRelevantFacet(module)) == null) {
            String string = this.getCustomNameSettingDescriptor().defaultValue;
            if (string == null) {
                SpringBootModelConfigFileNameContributor.$$$reportNull$$$0(7);
            }
            return string;
        }
        CustomSetting.STRING setting = (CustomSetting.STRING)springFacet.findSetting(this.getCustomNameSettingDescriptor().key);
        assert (setting != null);
        String string = StringUtil.notNullize((String)setting.getStringValue(), (String)setting.getDefaultValue());
        if (string == null) {
            SpringBootModelConfigFileNameContributor.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public List<String> getCustomConfigFileUrls(@NotNull Module module) {
        SpringFacet springFacet;
        if (module == null) {
            SpringBootModelConfigFileNameContributor.$$$reportNull$$$0(9);
        }
        if ((springFacet = SpringBootModelConfigFileNameContributor.getRelevantFacet(module)) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                SpringBootModelConfigFileNameContributor.$$$reportNull$$$0(10);
            }
            return list;
        }
        CustomSetting.STRING setting = (CustomSetting.STRING)springFacet.findSetting(this.getCustomFilesSettingDescriptor().key);
        assert (setting != null);
        String value = setting.getStringValue();
        if (value == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                SpringBootModelConfigFileNameContributor.$$$reportNull$$$0(11);
            }
            return list;
        }
        List list = StringUtil.split((String)value, (String)";");
        if (list == null) {
            SpringBootModelConfigFileNameContributor.$$$reportNull$$$0(12);
        }
        return list;
    }

    public List<VirtualFile> findCustomConfigFiles(@NotNull Module module) {
        List<String> urls;
        if (module == null) {
            SpringBootModelConfigFileNameContributor.$$$reportNull$$$0(13);
        }
        if ((urls = this.getCustomConfigFileUrls(module)).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(urls.size());
        for (String url : urls) {
            VirtualFile configFile = VirtualFileManager.getInstance().findFileByUrl(url);
            ContainerUtil.addIfNotNull(files, (Object)configFile);
        }
        return files;
    }

    @Nullable
    private static SpringFacet getRelevantFacet(Module module) {
        SpringFacet facet = SpringBootModelConfigFileNameContributor.findSpringBootApplicationFacet(module);
        if (facet != null) {
            return facet;
        }
        if (module.isDisposed()) {
            return null;
        }
        for (Module dependentModule : ModuleRootManager.getInstance((Module)module).getDependencies()) {
            SpringFacet dependentFacet = SpringBootModelConfigFileNameContributor.findSpringBootApplicationFacet(dependentModule);
            if (dependentFacet == null) continue;
            return dependentFacet;
        }
        return null;
    }

    @Nullable
    private static SpringFacet findSpringBootApplicationFacet(Module module) {
        SpringFacet springFacet = SpringFacet.getInstance((Module)module);
        if (springFacet == null) {
            return null;
        }
        List<PsiClass> applications = SpringBootApplicationService.getInstance().getSpringApplications(module);
        return applications.isEmpty() ? null : springFacet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 7, 8, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customNameSettingDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customFilesSettingDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/model/SpringBootModelConfigFileNameContributor";
                break;
            }
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/model/SpringBootModelConfigFileNameContributor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomNameSettingDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomFilesSettingDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomizationPresentation";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringConfigName";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomConfigFileUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSpringConfigName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCustomConfigFileUrls";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findCustomConfigFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 7, 8, 10, 11, 12 -> new IllegalStateException(string);
        };
    }

    public static class CustomSettingDescriptor {
        public final Key<CustomSetting.STRING> key;
        @Nls
        public final String description;
        public final String defaultValue;

        public CustomSettingDescriptor(Key<CustomSetting.STRING> key, @Nls String description, String defaultValue) {
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
        }

        public CustomSetting.STRING createCustomSetting() {
            return new CustomSetting.STRING(this.key, this.description, this.defaultValue);
        }
    }

    public static class CustomizationPresentation {
        @NlsSafe
        public final String configFileKey;
        public final @NlsContexts.BorderTitle String customizationPanelTitle;

        public CustomizationPresentation(@NlsSafe String configFileKey, @NlsContexts.BorderTitle String customizationPanelTitle) {
            this.configFileKey = configFileKey;
            this.customizationPanelTitle = customizationPanelTitle;
        }
    }
}

