/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.model.ConfigurationValueResult;
import com.intellij.spring.boot.model.autoconfigure.AutoConfigClassSorter;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.model.autoconfigure.jam.EnableAutoConfiguration;
import com.intellij.spring.boot.model.autoconfigure.jam.ImportAutoConfiguration;
import com.intellij.spring.boot.spi.SpringBootImportsManager;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AutoConfigClassCollector {
    @NonNls
    private static final String SPRING_AUTOCONFIGURE_EXCLUDE = "spring.autoconfigure.exclude";

    public static List<PsiClass> collectConfigurationClasses(@Nullable EnableAutoConfiguration enableAutoConfiguration, @NotNull ConditionalOnEvaluationContext context) {
        Module module;
        if (context == null) {
            AutoConfigClassCollector.$$$reportNull$$$0(0);
        }
        if ((module = context.getModule()).isDisposed()) {
            return Collections.emptyList();
        }
        ArrayList<PsiClass> allAutoConfigurationClasses = new ArrayList<PsiClass>(SpringBootImportsManager.Companion.getInstance(module).getAutoConfigurationClasses(false));
        List<Object> excludedViaAnnotation = enableAutoConfiguration == null ? Collections.emptyList() : enableAutoConfiguration.getExcludes();
        allAutoConfigurationClasses.removeAll(excludedViaAnnotation);
        AutoConfigClassCollector.excludeByConfigProperty(context, allAutoConfigurationClasses);
        AutoConfigClassSorter sorter = new AutoConfigClassSorter(module, allAutoConfigurationClasses);
        return sorter.getSortedConfigs();
    }

    private static void excludeByConfigProperty(ConditionalOnEvaluationContext context, List<PsiClass> classes) {
        Processor autoConfigExcludedProcessor = results -> {
            if (results.isEmpty()) {
                return true;
            }
            ConfigurationValueResult noKeyItem = (ConfigurationValueResult)ContainerUtil.find((Iterable)results, result -> result.getKeyIndexText() == null);
            List items2 = noKeyItem != null ? new SmartList((Object)noKeyItem) : results;
            for (ConfigurationValueResult item : items2) {
                PsiElement valueElement = item.getValueElement();
                if (valueElement == null) continue;
                for (PsiReference reference : valueElement.getReferences()) {
                    PsiElement resolve2 = reference.resolve();
                    if (!(resolve2 instanceof PsiClass)) continue;
                    classes.remove((PsiClass)resolve2);
                }
            }
            return false;
        };
        context.processConfigurationValues((Processor<? super List<ConfigurationValueResult>>)autoConfigExcludedProcessor, true, SPRING_AUTOCONFIGURE_EXCLUDE);
    }

    public static List<PsiClass> collectConfigurationClasses(@NotNull ImportAutoConfiguration importAutoConfiguration, @NotNull ConditionalOnEvaluationContext context) {
        Module module;
        if (importAutoConfiguration == null) {
            AutoConfigClassCollector.$$$reportNull$$$0(1);
        }
        if (context == null) {
            AutoConfigClassCollector.$$$reportNull$$$0(2);
        }
        if ((module = context.getModule()).isDisposed()) {
            return Collections.emptyList();
        }
        ArrayList<PsiClass> classes = new ArrayList<PsiClass>(AutoConfigClassCollector.getImportAutoConfigurationClasses(importAutoConfiguration, module));
        List<PsiClass> excludedViaAnnotation = importAutoConfiguration.getExcludes();
        classes.removeAll(excludedViaAnnotation);
        AutoConfigClassCollector.excludeByConfigProperty(context, classes);
        AutoConfigClassSorter sorter = new AutoConfigClassSorter(module, classes);
        return sorter.getSortedConfigs();
    }

    private static List<PsiClass> getImportAutoConfigurationClasses(ImportAutoConfiguration importAutoConfiguration, Module module) {
        String fqn;
        List<PsiClass> classes = importAutoConfiguration.getClasses();
        if (classes.isEmpty() && (fqn = importAutoConfiguration.getSourceFqn()) != null) {
            return SpringBootImportsManager.Companion.getInstance(module).getClasses(false, fqn);
        }
        return classes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "importAutoConfiguration";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/boot/model/autoconfigure/AutoConfigClassCollector";
        objectArray[2] = "collectConfigurationClasses";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

