/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.autoconfigure.AutoConfigureMetadataIndex;
import com.intellij.spring.boot.model.autoconfigure.AutoConfigureMetadataIndexKt;
import com.intellij.spring.boot.model.autoconfigure.SpringBootAutoConfigClassFilterService;
import com.intellij.spring.boot.model.autoconfigure.SpringOrderClassSorter;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnClass;
import com.intellij.spring.boot.model.autoconfigure.jam.AutoConfigureAfter;
import com.intellij.spring.boot.model.autoconfigure.jam.AutoConfigureBefore;
import com.intellij.spring.boot.model.autoconfigure.jam.AutoConfigureOrder;
import com.intellij.spring.model.jam.SpringOrder;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AutoConfigClassSorter {
    private final Map<PsiClass, Integer> myAutoConfigureOrderCache = FactoryMap.create((Function)new NotNullFunction<PsiClass, Integer>(){

        @NotNull
        public Integer fun(PsiClass psiClass) {
            AutoConfigureMetadataIndex.AutoConfigureMetadata metadata = AutoConfigClassSorter.this.findMetadata(psiClass);
            if (metadata != null) {
                Integer n = (Integer)ObjectUtils.notNull((Object)metadata.getAutoConfigureOrder(), (Object)AutoConfigClassSorter.this.myAutoConfigureOrderDefault);
                if (n == null) {
                    1.$$$reportNull$$$0(0);
                }
                return n;
            }
            AutoConfigureOrder autoConfigureOrder = (AutoConfigureOrder)AutoConfigureOrder.CLASS_META.getJamElement((PsiModifierListOwner)psiClass);
            if (autoConfigureOrder == null) {
                Integer n = AutoConfigClassSorter.this.myAutoConfigureOrderDefault;
                if (n == null) {
                    1.$$$reportNull$$$0(1);
                }
                return n;
            }
            Integer n = (Integer)ObjectUtils.notNull((Object)autoConfigureOrder.getValue(), (Object)AutoConfigClassSorter.this.myAutoConfigureOrderDefault);
            if (n == null) {
                1.$$$reportNull$$$0(2);
            }
            return n;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/autoconfigure/AutoConfigClassSorter$1", "fun"));
        }
    });
    private final Comparator<PsiClass> AUTOCONFIGURE_ORDER_COMPARATOR = (o1, o2) -> {
        int order1 = this.myAutoConfigureOrderCache.get(o1);
        int order2 = this.myAutoConfigureOrderCache.get(o2);
        return Integer.compare(order1, order2);
    };
    private final List<PsiClass> myConfigurationClasses;
    private final Integer myAutoConfigureOrderDefault;
    private final Map<PsiClass, List<PsiClass>> autoConfigureBeforeClassesCache = new HashMap<PsiClass, List<PsiClass>>();
    private final GlobalSearchScope mySearchScope;
    private final JavaPsiFacade myJavaPsiFacade;
    private final Map<PsiClass, AutoConfigureMetadataIndex.AutoConfigureMetadata> metadataCache = FactoryMap.create(AutoConfigureMetadataIndexKt::findAutoConfigureMetadata);

    AutoConfigClassSorter(Module module, List<PsiClass> configClasses) {
        this.myAutoConfigureOrderDefault = AutoConfigClassSorter.getOrderDefaultValue(module);
        this.mySearchScope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)true);
        this.myJavaPsiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
        this.myConfigurationClasses = SpringBootAutoConfigClassFilterService.getInstance().filterByConditionalOnClass(module, configClasses);
        for (PsiClass config : this.myConfigurationClasses) {
            Object autoConfigureBefore;
            AutoConfigureMetadataIndex.AutoConfigureMetadata metadata = this.findMetadata(config);
            if (metadata != null) {
                autoConfigureBefore = metadata.getAutoConfigureBefore();
                if (autoConfigureBefore.isEmpty()) continue;
                ArrayList before = new ArrayList(autoConfigureBefore.size());
                for (String fqn : autoConfigureBefore) {
                    ContainerUtil.addIfNotNull(before, (Object)this.myJavaPsiFacade.findClass(fqn, this.mySearchScope));
                }
                this.autoConfigureBeforeClassesCache.put(config, before);
                continue;
            }
            autoConfigureBefore = (AutoConfigureBefore)AutoConfigureBefore.META.getJamElement((PsiModifierListOwner)config);
            if (autoConfigureBefore == null) continue;
            this.autoConfigureBeforeClassesCache.put(config, ((AutoConfigureBefore)((Object)autoConfigureBefore)).getClasses());
        }
    }

    List<PsiClass> getSortedConfigs() {
        ArrayList<PsiClass> configs = new ArrayList<PsiClass>(this.myConfigurationClasses);
        configs.sort(SpringOrderClassSorter.CLASS_NAME_COMPARATOR);
        configs.sort(this.AUTOCONFIGURE_ORDER_COMPARATOR);
        return this.sortByAutoConfigureAfterBefore(configs);
    }

    static boolean passesConditionalClassMatch(PsiClass config) {
        return AutoConfigClassSorter.passesConditionalClassMatch((ConditionalOnClass)ConditionalOnClass.CLASS_META.getJamElement((PsiModifierListOwner)config));
    }

    static boolean passesConditionalClassMatch(PsiMethod bean) {
        return AutoConfigClassSorter.passesConditionalClassMatch((ConditionalOnClass)ConditionalOnClass.METHOD_META.getJamElement((PsiModifierListOwner)bean));
    }

    private static boolean passesConditionalClassMatch(ConditionalOnClass conditionalOnClass) {
        if (conditionalOnClass == null) {
            return true;
        }
        for (PsiClass psiClass : conditionalOnClass.getValue()) {
            if (psiClass != null) continue;
            return false;
        }
        for (PsiClass psiClass : conditionalOnClass.getName()) {
            if (psiClass != null) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private AutoConfigureMetadataIndex.AutoConfigureMetadata findMetadata(PsiClass psiClass) {
        return this.metadataCache.get(psiClass);
    }

    @NotNull
    private static Integer getOrderDefaultValue(Module module) {
        PsiAnnotationMemberValue annotationMemberValue;
        Integer defaultValue;
        PsiClass autoConfigureOrder = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.boot.autoconfigure.AutoConfigureOrder");
        if (autoConfigureOrder == null) {
            return AutoConfigClassSorter.getOrderDefaultValueFallbackByVersion(module);
        }
        Object[] methods = autoConfigureOrder.findMethodsByName("value", false);
        PsiMethod valueMethod = (PsiMethod)ArrayUtil.getFirstElement((Object[])methods);
        if (valueMethod instanceof PsiAnnotationMethod && (defaultValue = (Integer)JamCommonUtil.getObjectValue((PsiElement)(annotationMemberValue = ((PsiAnnotationMethod)valueMethod).getDefaultValue()), Integer.class)) != null) {
            Integer n = defaultValue;
            if (n == null) {
                AutoConfigClassSorter.$$$reportNull$$$0(0);
            }
            return n;
        }
        return AutoConfigClassSorter.getOrderDefaultValueFallbackByVersion(module);
    }

    @NotNull
    private static Integer getOrderDefaultValueFallbackByVersion(Module module) {
        if (SpringBootLibraryUtil.isAtLeastVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_2_0_0)) {
            Integer n = 0;
            if (n == null) {
                AutoConfigClassSorter.$$$reportNull$$$0(1);
            }
            return n;
        }
        Integer n = SpringOrder.LOWEST_PRECEDENCE;
        if (n == null) {
            AutoConfigClassSorter.$$$reportNull$$$0(2);
        }
        return n;
    }

    private List<PsiClass> sortByAutoConfigureAfterBefore(List<PsiClass> configs) {
        LinkedHashSet<PsiClass> toSort = new LinkedHashSet<PsiClass>(configs);
        ArrayList<PsiClass> sorted = new ArrayList<PsiClass>();
        while (!toSort.isEmpty()) {
            PsiClass next = (PsiClass)ContainerUtil.getFirstItem(toSort);
            this.doSortByAfterAnnotation(toSort, sorted, next);
        }
        return sorted;
    }

    private void doSortByAfterAnnotation(Set<PsiClass> toSort, List<PsiClass> sorted, PsiClass current) {
        toSort.remove(current);
        for (PsiClass after : this.getClassesRequestedAfter(current)) {
            if (!toSort.contains(after)) continue;
            this.doSortByAfterAnnotation(toSort, sorted, after);
        }
        sorted.add(current);
    }

    private Set<PsiClass> getClassesRequestedAfter(PsiClass config) {
        Set<PsiClass> rtn = this.getAutoConfigureAfterValues(config);
        for (Map.Entry<PsiClass, List<PsiClass>> entry : this.autoConfigureBeforeClassesCache.entrySet()) {
            if (!entry.getValue().contains(config)) continue;
            rtn.add(entry.getKey());
        }
        return rtn;
    }

    @NotNull
    private Set<PsiClass> getAutoConfigureAfterValues(PsiClass config) {
        LinkedHashSet<PsiClass> rtn = new LinkedHashSet<PsiClass>();
        AutoConfigureMetadataIndex.AutoConfigureMetadata metadata = this.findMetadata(config);
        if (metadata != null) {
            for (String qn : metadata.getAutoConfigureAfter()) {
                ContainerUtil.addIfNotNull(rtn, (Object)this.myJavaPsiFacade.findClass(qn, this.mySearchScope));
            }
            LinkedHashSet<PsiClass> linkedHashSet = rtn;
            if (linkedHashSet == null) {
                AutoConfigClassSorter.$$$reportNull$$$0(3);
            }
            return linkedHashSet;
        }
        AutoConfigureAfter autoConfigureAfter = (AutoConfigureAfter)AutoConfigureAfter.META.getJamElement((PsiModifierListOwner)config);
        if (autoConfigureAfter != null) {
            rtn.addAll(autoConfigureAfter.getClasses());
        }
        LinkedHashSet<PsiClass> linkedHashSet = rtn;
        if (linkedHashSet == null) {
            AutoConfigClassSorter.$$$reportNull$$$0(4);
        }
        return linkedHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/boot/model/autoconfigure/AutoConfigClassSorter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderDefaultValue";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderDefaultValueFallbackByVersion";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoConfigureAfterValues";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

