/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure.conditions;

import com.intellij.openapi.module.Module;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionMessage;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionOutcome;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalContributor;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.model.utils.SpringCommonUtils;

class HibernateEntityManagerCondition
extends ConditionalContributor {
    private static final String[] CLASS_NAMES = new String[]{"org.hibernate.ejb.HibernateEntityManager", "org.hibernate.jpa.HibernateEntityManager"};

    HibernateEntityManagerCondition() {
    }

    @Override
    public ConditionOutcome matches(ConditionalOnEvaluationContext context) {
        for (String className : CLASS_NAMES) {
            if (SpringCommonUtils.findLibraryClass((Module)context.getModule(), (String)className) == null) continue;
            return ConditionOutcome.match(ConditionMessage.foundClass(className));
        }
        return ConditionOutcome.noMatch(ConditionMessage.didNotFindClass(CLASS_NAMES));
    }
}

