/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure.conditions.jam;

import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiType;
import com.intellij.semantic.SemKey;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionMessage;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionOutcome;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnBeanBase;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnBeanUtils;
import com.intellij.spring.boot.model.autoconfigure.conditions.jam.ConditionalOnJamElement;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class ConditionalOnBean
extends ConditionalOnBeanBase
implements ConditionalOnJamElement.NonStrict {
    private static final JamAnnotationMeta ANNOTATION_META = new JamAnnotationMeta("org.springframework.boot.autoconfigure.condition.ConditionalOnBean", ARCHETYPE);
    private static final SemKey<ConditionalOnBean> SEM_KEY = CONDITIONAL_JAM_ELEMENT_KEY.subKey("ConditionalOnBean", new SemKey[0]);
    public static final JamClassMeta<ConditionalOnBean> CLASS_META = new JamClassMeta(null, ConditionalOnBean::new, SEM_KEY).addAnnotation(ANNOTATION_META);
    public static final JamMethodMeta<ConditionalOnBean> METHOD_META = new JamMethodMeta(null, ConditionalOnBean::new, SEM_KEY).addAnnotation(ANNOTATION_META);

    private ConditionalOnBean(PsiElementRef<?> ref) {
        super(ref);
    }

    @Override
    protected JamAnnotationMeta getAnnotationMeta() {
        return ANNOTATION_META;
    }

    @Override
    public ConditionOutcome matches(ConditionalOnEvaluationContext context) {
        CommonSpringModel springModel = (CommonSpringModel)context.getUserData(ConditionalOnEvaluationContext.MODEL_KEY);
        if (springModel == null) {
            return ConditionalOnBeanUtils.getMissingModelOutcome();
        }
        Collection<PsiClass> containers = this.getValidParametrizedContainers();
        CommonSpringBean selfBean = ConditionalOnBeanUtils.getSpringBean(this.getPsiElement());
        SmartList ignoredBeans = selfBean != null ? new SmartList((Object)selfBean) : Collections.emptyList();
        MatchAllProcessor processor = new MatchAllProcessor();
        Collection<PsiType> types = this.getTypesToMatch();
        if (types.isEmpty() && this.getName().isEmpty() && this.getAnnotation().isEmpty()) {
            return ConditionOutcome.noMatch("Bean is not specified using type, name or annotation");
        }
        this.matchBeansByType(springModel, types, containers, (List<CommonSpringBean>)ignoredBeans, processor);
        if (!processor.isMatched()) {
            return ConditionOutcome.noMatch(ConditionMessage.didNotFind("bean", new String[0]));
        }
        processor = new MatchAllProcessor();
        this.matchBeansByAnnotation(springModel, (List<CommonSpringBean>)ignoredBeans, processor);
        if (!processor.isMatched()) {
            return ConditionOutcome.noMatch(ConditionMessage.didNotFind("bean", new String[0]));
        }
        processor = new MatchAllProcessor();
        this.matchBeansByName(springModel, (List<CommonSpringBean>)ignoredBeans, processor);
        if (!processor.isMatched()) {
            return ConditionOutcome.noMatch(ConditionMessage.didNotFind("bean", new String[0]));
        }
        return ConditionOutcome.match(ConditionMessage.found("bean", new String[0]));
    }

    private static class MatchAllProcessor
    implements Processor<Boolean> {
        private boolean myMatched = true;

        private MatchAllProcessor() {
        }

        public boolean process(Boolean matched) {
            this.myMatched = matched;
            return this.myMatched;
        }

        boolean isMatched() {
            return this.myMatched;
        }
    }
}

