/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.logical;

import com.intellij.icons.AllIcons;
import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.boot.SpringBootApiBundle;
import com.intellij.spring.boot.model.logical.ApplicationConfigLogicalGroup;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/spring/boot/model/logical/ApplicationConfigLogicalGroupPresentationProvider;", "Lcom/intellij/ide/presentation/PresentationProvider;", "Lcom/intellij/spring/boot/model/logical/ApplicationConfigLogicalGroup;", "<init>", "()V", "springPrefixes", "", "", "getName", "t", "getIcon", "Ljavax/swing/Icon;", "getTypeName", "intellij.spring.boot"})
@SourceDebugExtension(value={"SMAP\nApplicationPropertiesLogicalGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplicationPropertiesLogicalGroup.kt\ncom/intellij/spring/boot/model/logical/ApplicationConfigLogicalGroupPresentationProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,68:1\n295#2,2:69\n1#3:71\n*S KotlinDebug\n*F\n+ 1 ApplicationPropertiesLogicalGroup.kt\ncom/intellij/spring/boot/model/logical/ApplicationConfigLogicalGroupPresentationProvider\n*L\n42#1:69,2\n*E\n"})
public final class ApplicationConfigLogicalGroupPresentationProvider
extends PresentationProvider<ApplicationConfigLogicalGroup> {
    @NotNull
    private final List<String> springPrefixes;

    public ApplicationConfigLogicalGroupPresentationProvider() {
        Object[] objectArray = new String[]{"spring.cache.", "spring.data.", "spring.integration.", "spring.session.", "spring."};
        this.springPrefixes = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public String getName(@NotNull ApplicationConfigLogicalGroup t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        String string = t.getPrefix();
        if (string == null) {
            String string2 = SpringBootApiBundle.message("logical.spring.properties.group.others", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Icon getIcon(@NotNull ApplicationConfigLogicalGroup t) {
        Icon icon;
        String wordAfterSpringPrefix;
        String string;
        Object v6;
        String prefix;
        block42: {
            String string2;
            block44: {
                block43: {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    string2 = t.getPrefix();
                    if (string2 == null) break block43;
                    String string3 = string2.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                    string2 = string3;
                    if (string3 != null) break block44;
                }
                Icon icon2 = AllIcons.FileTypes.Custom;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Custom");
                return icon2;
            }
            prefix = string2;
            String string4 = prefix;
            if (Intrinsics.areEqual((Object)string4, (Object)"server")) {
                Icon icon3 = AllIcons.Javaee.WebService;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"WebService");
                return icon3;
            }
            if (Intrinsics.areEqual((Object)string4, (Object)"logging")) {
                Icon icon4 = AllIcons.Debugger.Console;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Console");
                return icon4;
            }
            if (!StringsKt.startsWith$default((String)prefix, (String)"spring.", (boolean)false, (int)2, null)) {
                Icon icon5 = AllIcons.FileTypes.Custom;
                Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"Custom");
                return icon5;
            }
            Iterable $this$firstOrNull$iv = this.springPrefixes;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)prefix, (String)it, (boolean)false, (int)2, null)) continue;
                v6 = element$iv;
                break block42;
            }
            v6 = null;
        }
        String string5 = v6;
        if (string5 != null) {
            String it = string5;
            boolean bl = false;
            string = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)prefix, (String)it, null, (int)2, null), (String)".", null, (int)2, null);
        } else {
            string = null;
        }
        String string6 = wordAfterSpringPrefix = string;
        if (string6 != null) {
            int n = -1;
            switch (string6.hashCode()) {
                case -1655971030: {
                    if (!string6.equals("activemq")) break;
                    n = 1;
                    break;
                }
                case -868129468: {
                    if (!string6.equals("tomcat")) break;
                    n = 2;
                    break;
                }
                case 1984156229: {
                    if (!string6.equals("servlet")) break;
                    n = 3;
                    break;
                }
                case 3274: {
                    if (!string6.equals("h2")) break;
                    n = 4;
                    break;
                }
                case -95168706: {
                    if (!string6.equals("rabbitmq")) break;
                    n = 5;
                    break;
                }
                case 108389755: {
                    if (!string6.equals("redis")) break;
                    n = 6;
                    break;
                }
                case 1333202681: {
                    if (!string6.equals("liquibase")) break;
                    n = 7;
                    break;
                }
                case -1985354563: {
                    if (!string6.equals("elasticsearch")) break;
                    n = 8;
                    break;
                }
                case 1073564104: {
                    if (!string6.equals("cassandra")) break;
                    n = 9;
                    break;
                }
                case -2106363835: {
                    if (!string6.equals("datasource")) break;
                    n = 10;
                    break;
                }
                case 1026150271: {
                    if (!string6.equals("couchbase")) break;
                    n = 11;
                    break;
                }
                case 101807910: {
                    if (!string6.equals("kafka")) break;
                    n = 12;
                    break;
                }
                case 105435: {
                    if (!string6.equals("jpa")) break;
                    n = 13;
                    break;
                }
                case 1236254834: {
                    if (!string6.equals("mongodb")) break;
                    n = 14;
                    break;
                }
            }
            switch (n) {
                case 10: {
                    Icon icon6 = SpringApiIcons.SpringSessionFactory;
                    icon = icon6;
                    Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"SpringSessionFactory");
                    return icon;
                }
                case 13: {
                    Icon icon7 = SpringApiIcons.SpringData;
                    icon = icon7;
                    Intrinsics.checkNotNullExpressionValue((Object)icon7, (String)"SpringData");
                    return icon;
                }
                case 3: {
                    Icon icon8 = AllIcons.Nodes.Servlet;
                    icon = icon8;
                    Intrinsics.checkNotNullExpressionValue((Object)icon8, (String)"Servlet");
                    return icon;
                }
                case 2: {
                    Icon icon9 = AllIcons.RunConfigurations.Tomcat;
                    icon = icon9;
                    Intrinsics.checkNotNullExpressionValue((Object)icon9, (String)"Tomcat");
                    return icon;
                }
                case 1: {
                    Icon icon10 = AllIcons.Providers.ActiveMQ;
                    icon = icon10;
                    Intrinsics.checkNotNullExpressionValue((Object)icon10, (String)"ActiveMQ");
                    return icon;
                }
                case 9: {
                    Icon icon11 = AllIcons.Providers.Cassandra;
                    icon = icon11;
                    Intrinsics.checkNotNullExpressionValue((Object)icon11, (String)"Cassandra");
                    return icon;
                }
                case 11: {
                    Icon icon12 = AllIcons.Providers.Couchbase;
                    icon = icon12;
                    Intrinsics.checkNotNullExpressionValue((Object)icon12, (String)"Couchbase");
                    return icon;
                }
                case 6: {
                    Icon icon13 = AllIcons.Providers.Redis;
                    icon = icon13;
                    Intrinsics.checkNotNullExpressionValue((Object)icon13, (String)"Redis");
                    return icon;
                }
                case 14: {
                    Icon icon14 = AllIcons.Providers.MongoDB;
                    icon = icon14;
                    Intrinsics.checkNotNullExpressionValue((Object)icon14, (String)"MongoDB");
                    return icon;
                }
                case 8: {
                    Icon icon15 = AllIcons.Providers.Elasticsearch;
                    icon = icon15;
                    Intrinsics.checkNotNullExpressionValue((Object)icon15, (String)"Elasticsearch");
                    return icon;
                }
                case 4: {
                    Icon icon16 = AllIcons.Providers.H2;
                    icon = icon16;
                    Intrinsics.checkNotNullExpressionValue((Object)icon16, (String)"H2");
                    return icon;
                }
                case 12: {
                    Icon icon17 = AllIcons.Providers.Kafka;
                    icon = icon17;
                    Intrinsics.checkNotNullExpressionValue((Object)icon17, (String)"Kafka");
                    return icon;
                }
                case 7: {
                    Icon icon18 = AllIcons.Providers.Liquibase;
                    icon = icon18;
                    Intrinsics.checkNotNullExpressionValue((Object)icon18, (String)"Liquibase");
                    return icon;
                }
                case 5: {
                    Icon icon19 = AllIcons.Providers.RabbitMQ;
                    icon = icon19;
                    Intrinsics.checkNotNullExpressionValue((Object)icon19, (String)"RabbitMQ");
                    return icon;
                }
            }
        }
        Icon icon20 = SpringApiIcons.Spring;
        icon = icon20;
        Intrinsics.checkNotNullExpressionValue((Object)icon20, (String)"Spring");
        return icon;
    }

    @NotNull
    public String getTypeName(@NotNull ApplicationConfigLogicalGroup t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return "";
    }
}

