/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.testing.jam.custom.providers;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.spi.SpringBootImportsFileIndexKt;
import com.intellij.spring.boot.spi.SpringBootImportsFileType;
import com.intellij.spring.boot.spi.SpringBootImportsManager;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.model.jam.testContexts.ContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringTestingImplicitContextsProvider;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import com.intellij.spring.spi.SpringSpiManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringAutoConfiguredImplicitContextsProvider
extends SpringTestingImplicitContextsProvider {
    @NotNull
    public Collection<CommonSpringModel> getModels(@Nullable Module module, @NotNull ContextConfiguration configuration, @NotNull Set<String> activeProfiles) {
        LocalAnnotationModel localAnnotationModel;
        if (configuration == null) {
            SpringAutoConfiguredImplicitContextsProvider.$$$reportNull$$$0(0);
        }
        if (activeProfiles == null) {
            SpringAutoConfiguredImplicitContextsProvider.$$$reportNull$$$0(1);
        }
        if (module == null) {
            List<CommonSpringModel> list = Collections.emptyList();
            if (list == null) {
                SpringAutoConfiguredImplicitContextsProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        SmartList models2 = new SmartList();
        for (String anno : SpringAutoConfiguredImplicitContextsProvider.getAutoConfiguredTestAnnotations(module)) {
            if (!SpringAutoConfiguredImplicitContextsProvider.isAnnotated((ContextConfiguration)configuration, (Module)module, (String)anno)) continue;
            for (PsiClass registeredClass : SpringSpiManager.getInstance((Module)module).getClassesListValue(true, anno)) {
                localAnnotationModel = SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(registeredClass, module, activeProfiles, true);
                ContainerUtil.addIfNotNull((Collection)models2, (Object)localAnnotationModel);
            }
        }
        if (SpringBootLibraryUtil.isAtLeastVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_2_7_0)) {
            for (String anno : SpringAutoConfiguredImplicitContextsProvider.getImportAutoConfiguredTestAnnotations(module)) {
                if (!SpringAutoConfiguredImplicitContextsProvider.isAnnotated((ContextConfiguration)configuration, (Module)module, (String)anno)) continue;
                for (PsiClass registeredClass : SpringBootImportsManager.Companion.getInstance(module).getClasses(true, anno)) {
                    localAnnotationModel = SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(registeredClass, module, activeProfiles, true);
                    ContainerUtil.addIfNotNull((Collection)models2, (Object)localAnnotationModel);
                }
            }
        }
        SmartList smartList = models2;
        if (smartList == null) {
            SpringAutoConfiguredImplicitContextsProvider.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    private static Collection<String> getAutoConfiguredTestAnnotations(@NotNull Module module) {
        if (module == null) {
            SpringAutoConfiguredImplicitContextsProvider.$$$reportNull$$$0(4);
        }
        return (Collection)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            HashSet<String> annotations = new HashSet<String>();
            List files = SpringSpiManager.getInstance((Module)module).getSpringFactoriesFiles(true);
            for (PropertiesFileImpl file : files) {
                for (IProperty property : file.getProperties()) {
                    PsiClass keyClass;
                    String key = property.getKey();
                    if (key == null || (keyClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(key, SpringGlobalSearchScopes.runtime((Module)module, (boolean)true))) == null || !keyClass.isAnnotationType()) continue;
                    annotations.add(key);
                }
            }
            return CachedValueProvider.Result.create(annotations, (Object[])SpringModificationTrackersManager.getInstance((Project)module.getProject()).getOuterModelsDependencies());
        });
    }

    private static Collection<String> getImportAutoConfiguredTestAnnotations(@NotNull Module module) {
        if (module == null) {
            SpringAutoConfiguredImplicitContextsProvider.$$$reportNull$$$0(5);
        }
        return (Collection)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            HashSet<String> annotations = new HashSet<String>();
            GlobalSearchScope adjustedScope = SpringBootImportsFileIndexKt.adjustSpringBootImportsScope(module.getProject(), GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)true));
            if (adjustedScope != null) {
                Collection files = FileTypeIndex.getFiles((FileType)SpringBootImportsFileType.INSTANCE, (GlobalSearchScope)adjustedScope);
                for (VirtualFile file : files) {
                    String key = file.getNameWithoutExtension();
                    PsiClass keyClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(key, SpringGlobalSearchScopes.runtime((Module)module, (boolean)true));
                    if (keyClass == null || !keyClass.isAnnotationType()) continue;
                    annotations.add(key);
                }
            }
            return CachedValueProvider.Result.create(annotations, (Object[])SpringModificationTrackersManager.getInstance((Project)module.getProject()).getOuterModelsDependencies());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/model/testing/jam/custom/providers/SpringAutoConfiguredImplicitContextsProvider";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/model/testing/jam/custom/providers/SpringAutoConfiguredImplicitContextsProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModels";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAutoConfiguredTestAnnotations";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getImportAutoConfiguredTestAnnotations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

