/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.config;

import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.CommonServletMapping;
import com.intellij.javaee.web.WebModelContributor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.boot.application.SpringBootApplicationService;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.mvc.config.anno.PsiBasedServlet;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringBootDispatcherServletWebModelContributor
extends WebModelContributor {
    @NonNls
    private static final String DISPATCHER_SERVLET_NAME = "dispatcherServlet";

    public List<CommonServlet> getServlets(Module module) {
        return new ArrayList<PsiBasedServlet>(SpringBootDispatcherServletWebModelContributor.getSpringBootDispatcherServlets(module));
    }

    public List<CommonServletMapping<CommonServlet>> getServletMappings(@NotNull Module module) {
        if (module == null) {
            SpringBootDispatcherServletWebModelContributor.$$$reportNull$$$0(0);
        }
        return new ArrayList<PsiBasedServlet>(SpringBootDispatcherServletWebModelContributor.getSpringBootDispatcherServlets(module));
    }

    @NotNull
    private static List<PsiBasedServlet> getSpringBootDispatcherServlets(@NotNull Module module) {
        if (module == null) {
            SpringBootDispatcherServletWebModelContributor.$$$reportNull$$$0(1);
        }
        List list = (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.create(SpringBootDispatcherServletWebModelContributor.getCommonServlets(module), (Object[])SpringModificationTrackersManager.getInstance((Project)module.getProject()).getOuterModelsDependencies()));
        if (list == null) {
            SpringBootDispatcherServletWebModelContributor.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    private static List<PsiBasedServlet> getCommonServlets(@NotNull Module module) {
        if (module == null) {
            SpringBootDispatcherServletWebModelContributor.$$$reportNull$$$0(3);
        }
        if (!SpringMvcLibraryUtil.hasSpringMvcLibrary((Module)module)) {
            List<PsiBasedServlet> list = Collections.emptyList();
            if (list == null) {
                SpringBootDispatcherServletWebModelContributor.$$$reportNull$$$0(4);
            }
            return list;
        }
        PsiClass springBootApplication = (PsiClass)ContainerUtil.getOnlyItem(SpringBootApplicationService.getInstance().getSpringApplications(module));
        if (springBootApplication == null) {
            List<PsiBasedServlet> list = Collections.emptyList();
            if (list == null) {
                SpringBootDispatcherServletWebModelContributor.$$$reportNull$$$0(5);
            }
            return list;
        }
        LocalAnnotationModel localSpringBootModel = SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(springBootApplication, module, Collections.emptySet());
        if (localSpringBootModel == null) {
            List<PsiBasedServlet> list = Collections.emptyList();
            if (list == null) {
                SpringBootDispatcherServletWebModelContributor.$$$reportNull$$$0(6);
            }
            return list;
        }
        SpringBeanPointer dispatcherServletRegistrationConfiguration = SpringModelSearchers.findBean((CommonSpringModel)localSpringBootModel, (String)SpringBootDispatcherServletWebModelContributor.getDispatcherServletRegistrationConfigurationBeanName(module));
        if (dispatcherServletRegistrationConfiguration == null) {
            List<PsiBasedServlet> list = Collections.emptyList();
            if (list == null) {
                SpringBootDispatcherServletWebModelContributor.$$$reportNull$$$0(7);
            }
            return list;
        }
        SpringBeanPointer dispatcherServlet = SpringModelSearchers.findBean((CommonSpringModel)localSpringBootModel, (String)DISPATCHER_SERVLET_NAME);
        if (dispatcherServlet == null) {
            List<PsiBasedServlet> list = Collections.emptyList();
            if (list == null) {
                SpringBootDispatcherServletWebModelContributor.$$$reportNull$$$0(8);
            }
            return list;
        }
        CommonSpringBean dispatcherServletBean = dispatcherServlet.getSpringBean();
        if (!(dispatcherServletBean instanceof JamPsiMemberSpringBean)) {
            List<PsiBasedServlet> list = Collections.emptyList();
            if (list == null) {
                SpringBootDispatcherServletWebModelContributor.$$$reportNull$$$0(9);
            }
            return list;
        }
        PsiElement dispatcherServletMethod = ((JamPsiMemberSpringBean)dispatcherServletBean).getPsiElement();
        List<PsiBasedServlet> list = Collections.singletonList(new PsiBasedServlet(DISPATCHER_SERVLET_NAME, dispatcherServlet.getBeanClass(), dispatcherServletMethod, dispatcherServletMethod, new String[]{"/"}));
        if (list == null) {
            SpringBootDispatcherServletWebModelContributor.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    private static String getDispatcherServletRegistrationConfigurationBeanName(Module module) {
        if (SpringBootLibraryUtil.isAtLeastVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_1_4_0)) {
            return "dispatcherServletAutoConfiguration.DispatcherServletRegistrationConfiguration";
        }
        return "dispatcherServletAutoConfiguration.DispatcherServletConfiguration";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 6, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/mvc/config/SpringBootDispatcherServletWebModelContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/mvc/config/SpringBootDispatcherServletWebModelContributor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringBootDispatcherServlets";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonServlets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getServletMappings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSpringBootDispatcherServlets";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCommonServlets";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 6, 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

