/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.config;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.HttpUrlResolver;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlResolver;
import com.intellij.microservices.url.UrlResolverFactory;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.psi.PsiElement;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.mvc.config.SpringBootStaticResolver;
import com.intellij.spring.boot.mvc.config.SpringBootStaticWebFileReferenceHelperKt;
import com.intellij.spring.mvc.views.SpringMvcViewTargetResolver;
import com.intellij.spring.mvc.views.UrlBasedViewResolver;
import com.intellij.spring.mvc.views.ViewResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u000f\u0010B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/spring/boot/mvc/config/SpringBootStaticResolver;", "Lcom/intellij/microservices/url/HttpUrlResolver;", "Lcom/intellij/spring/mvc/views/SpringMvcViewTargetResolver;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "resolve", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "module", "Lcom/intellij/openapi/module/Module;", "request", "Lcom/intellij/microservices/url/UrlResolveRequest;", "getVariants", "FileLookupUrlTargetInfo", "Factory", "intellij.spring.boot.mvc"})
@SourceDebugExtension(value={"SMAP\nSpringBootStaticWebFileReferenceHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBootStaticWebFileReferenceHelper.kt\ncom/intellij/spring/boot/mvc/config/SpringBootStaticResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,155:1\n1611#2,9:156\n1863#2:165\n1864#2:167\n1620#2:168\n1611#2,9:169\n1863#2:178\n1864#2:180\n1620#2:181\n1#3:166\n1#3:179\n19#4:182\n19#4:183\n19#4:184\n*S KotlinDebug\n*F\n+ 1 SpringBootStaticWebFileReferenceHelper.kt\ncom/intellij/spring/boot/mvc/config/SpringBootStaticResolver\n*L\n102#1:156,9\n102#1:165\n102#1:167\n102#1:168\n114#1:169,9\n114#1:178\n114#1:180\n114#1:181\n102#1:166\n114#1:179\n106#1:182\n119#1:183\n140#1:184\n*E\n"})
final class SpringBootStaticResolver
extends HttpUrlResolver
implements SpringMvcViewTargetResolver {
    @NotNull
    private final Project project;

    public SpringBootStaticResolver(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterable<UrlTargetInfo> resolve(@NotNull Module module, @NotNull UrlResolveRequest request) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String presentation = request.getPath().getPresentation();
        if (!StringsKt.startsWith$default((String)presentation, (String)"/", (boolean)false, (int)2, null)) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$mapNotNull$iv = request.getPath().getSegments();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            UrlPath.PathSegment it = (UrlPath.PathSegment)element$iv$iv;
            boolean bl2 = false;
            if (it.getValueIfExact() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List pathSegments = (List)destination$iv$iv;
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)SpringBootStaticWebFileReferenceHelperKt.getStaticResolvers(module)), arg_0 -> SpringBootStaticResolver.resolve$lambda$1(pathSegments, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterable<UrlTargetInfo> resolve(@NotNull UrlResolveRequest request) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String presentation = request.getPath().getPresentation();
        if (!StringsKt.startsWith$default((String)presentation, (String)"/", (boolean)false, (int)2, null)) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$mapNotNull$iv = request.getPath().getSegments();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            UrlPath.PathSegment it = (UrlPath.PathSegment)element$iv$iv;
            boolean bl2 = false;
            if (it.getValueIfExact() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List pathSegments = (List)destination$iv$iv;
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])ProjectUtil.getModules((Project)this.project)), SpringBootStaticResolver::resolve$lambda$3), arg_0 -> SpringBootStaticResolver.resolve$lambda$4(pathSegments, arg_0)));
    }

    @NotNull
    public Iterable<UrlTargetInfo> getVariants() {
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])ProjectUtil.getModules((Project)this.project)), SpringBootStaticResolver::getVariants$lambda$5), SpringBootStaticResolver::getVariants$lambda$6));
    }

    private static final Sequence resolve$lambda$1(List $pathSegments, ViewResolver vr) {
        Intrinsics.checkNotNullParameter((Object)vr, (String)"vr");
        ViewResolver $this$asSafely$iv = vr;
        boolean $i$f$asSafely = false;
        ViewResolver viewResolver = $this$asSafely$iv;
        if (!(viewResolver instanceof UrlBasedViewResolver)) {
            viewResolver = null;
        }
        UrlBasedViewResolver urlBasedViewResolver = (UrlBasedViewResolver)viewResolver;
        if (urlBasedViewResolver == null) {
            return SequencesKt.emptySequence();
        }
        UrlBasedViewResolver urlBasedViewResolver2 = urlBasedViewResolver;
        List list = urlBasedViewResolver2.getAllResolverViews($pathSegments);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllResolverViews(...)");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)resolve.1.1.INSTANCE);
    }

    private static final Sequence resolve$lambda$3(Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return CollectionsKt.asSequence((Iterable)SpringBootStaticWebFileReferenceHelperKt.getStaticResolvers(module));
    }

    private static final Sequence resolve$lambda$4(List $pathSegments, ViewResolver vr) {
        Intrinsics.checkNotNullParameter((Object)vr, (String)"vr");
        ViewResolver $this$asSafely$iv = vr;
        boolean $i$f$asSafely = false;
        ViewResolver viewResolver = $this$asSafely$iv;
        if (!(viewResolver instanceof UrlBasedViewResolver)) {
            viewResolver = null;
        }
        UrlBasedViewResolver urlBasedViewResolver = (UrlBasedViewResolver)viewResolver;
        if (urlBasedViewResolver == null) {
            return SequencesKt.emptySequence();
        }
        UrlBasedViewResolver urlBasedViewResolver2 = urlBasedViewResolver;
        List list = urlBasedViewResolver2.getAllResolverViews($pathSegments);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllResolverViews(...)");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)resolve.3.1.INSTANCE);
    }

    private static final Sequence getVariants$lambda$5(Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return CollectionsKt.asSequence((Iterable)SpringBootStaticWebFileReferenceHelperKt.getStaticResolvers(module));
    }

    private static final Sequence getVariants$lambda$6(ViewResolver vr) {
        Intrinsics.checkNotNullParameter((Object)vr, (String)"vr");
        ViewResolver $this$asSafely$iv = vr;
        boolean $i$f$asSafely = false;
        ViewResolver viewResolver = $this$asSafely$iv;
        if (!(viewResolver instanceof UrlBasedViewResolver)) {
            viewResolver = null;
        }
        UrlBasedViewResolver urlBasedViewResolver = (UrlBasedViewResolver)viewResolver;
        if (urlBasedViewResolver == null) {
            return SequencesKt.emptySequence();
        }
        UrlBasedViewResolver urlBasedViewResolver2 = urlBasedViewResolver;
        List list = urlBasedViewResolver2.getAllResolverViews();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllResolverViews(...)");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)getVariants.2.1.INSTANCE);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/spring/boot/mvc/config/SpringBootStaticResolver$Factory;", "Lcom/intellij/microservices/url/UrlResolverFactory;", "<init>", "()V", "forProject", "Lcom/intellij/microservices/url/UrlResolver;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.spring.boot.mvc"})
    public static final class Factory
    implements UrlResolverFactory {
        @Nullable
        public UrlResolver forProject(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return SpringBootLibraryUtil.hasSpringBootLibrary(project) ? (UrlResolver)new SpringBootStaticResolver(project) : null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\nR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lcom/intellij/spring/boot/mvc/config/SpringBootStaticResolver$FileLookupUrlTargetInfo;", "Lcom/intellij/microservices/url/UrlTargetInfo;", "elt", "Lcom/intellij/codeInsight/lookup/LookupElement;", "<init>", "(Lcom/intellij/codeInsight/lookup/LookupElement;)V", "schemes", "", "", "getSchemes", "()Ljava/util/List;", "authorities", "Lcom/intellij/microservices/url/Authority;", "getAuthorities", "path", "Lcom/intellij/microservices/url/UrlPath;", "getPath", "()Lcom/intellij/microservices/url/UrlPath;", "resolveToPsiElement", "Lcom/intellij/psi/PsiElement;", "intellij.spring.boot.mvc"})
    public static final class FileLookupUrlTargetInfo
    implements UrlTargetInfo {
        @NotNull
        private final LookupElement elt;

        public FileLookupUrlTargetInfo(@NotNull LookupElement elt) {
            Intrinsics.checkNotNullParameter((Object)elt, (String)"elt");
            this.elt = elt;
        }

        @NotNull
        public List<String> getSchemes() {
            return UrlConstants.HTTP_SCHEMES;
        }

        @NotNull
        public List<Authority> getAuthorities() {
            return CollectionsKt.emptyList();
        }

        @NotNull
        public UrlPath getPath() {
            String string = this.elt.getLookupString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
            return UrlPath.Companion.fromExactString(string);
        }

        @Nullable
        public PsiElement resolveToPsiElement() {
            return this.elt.getPsiElement();
        }
    }
}

