/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.config.viewresolver;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.mvc.config.viewresolver.SpringBootAutoConfigurationViewResolverFactoryBase;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.mvc.views.ViewResolver;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroovyTemplateAutoConfigurationViewResolverFactory
extends SpringBootAutoConfigurationViewResolverFactoryBase {
    private static final Set<String> VIEW_RESOLVER_CLASSES = Set.of("org.springframework.web.servlet.view.groovy.GroovyMarkupViewResolver");
    private static final Set<String> AUTOCONFIG_CLASSES = Set.of("org.springframework.boot.autoconfigure.groovy.template.GroovyTemplateAutoConfiguration.GroovyWebConfiguration");
    @NonNls
    static final String SPRING_GROOVY_TEMPLATE_PREFIX = "spring.groovy.template.prefix";
    @NonNls
    static final String SPRING_GROOVY_TEMPLATE_PREFIX_DEFAULT_VALUE = "classpath:/templates/";
    @NonNls
    static final String SPRING_GROOVY_TEMPLATE_SUFFIX = "spring.groovy.template.suffix";
    @NonNls
    static final String SPRING_GROOVY_TEMPLATE_SUFFIX_DEFAULT_VALUE = ".tpl";
    @NonNls
    static final String SPRING_GROOVY_TEMPLATE_RESOURCE_LOADER_PATH = "spring.groovy.template.resource-loader-path";

    @Override
    @NotNull
    protected String getViewResolverBeanName() {
        return "groovyMarkupViewResolver";
    }

    @Override
    @NotNull
    protected Set<String> getViewResolverClassNames() {
        Set<String> set = VIEW_RESOLVER_CLASSES;
        if (set == null) {
            GroovyTemplateAutoConfigurationViewResolverFactory.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    @NotNull
    protected Set<String> getAutoConfigurationClassNames() {
        Set<String> set = AUTOCONFIG_CLASSES;
        if (set == null) {
            GroovyTemplateAutoConfigurationViewResolverFactory.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    @NotNull
    protected Set<ViewResolver> createViewResolvers(@Nullable CommonSpringBean bean, CommonSpringModel model) {
        boolean isAtLeastSB13 = SpringBootLibraryUtil.isAtLeastVersion(model.getModule(), SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0);
        String prefix = StringUtil.notNullize((String)GroovyTemplateAutoConfigurationViewResolverFactory.getConfigurationOrDefaultValue(model, SPRING_GROOVY_TEMPLATE_PREFIX), (String)(isAtLeastSB13 ? "" : SPRING_GROOVY_TEMPLATE_PREFIX_DEFAULT_VALUE));
        String suffix = StringUtil.notNullize((String)GroovyTemplateAutoConfigurationViewResolverFactory.getConfigurationOrDefaultValue(model, SPRING_GROOVY_TEMPLATE_SUFFIX), (String)SPRING_GROOVY_TEMPLATE_SUFFIX_DEFAULT_VALUE);
        String resourceLoaderPath = isAtLeastSB13 ? GroovyTemplateAutoConfigurationViewResolverFactory.getConfigurationOrDefaultValue(model, SPRING_GROOVY_TEMPLATE_RESOURCE_LOADER_PATH) : "";
        Set<ViewResolver> resolvers = super.createViewResolvers(bean, model);
        resolvers.add(this.createURLBasedViewResolver(model.getModule(), resourceLoaderPath, prefix, suffix));
        Set<ViewResolver> set = resolvers;
        if (set == null) {
            GroovyTemplateAutoConfigurationViewResolverFactory.$$$reportNull$$$0(2);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/boot/mvc/config/viewresolver/GroovyTemplateAutoConfigurationViewResolverFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewResolverClassNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoConfigurationClassNames";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createViewResolvers";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

