/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.config.viewresolver;

import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootConfigValueSearcher;
import com.intellij.spring.boot.mvc.config.SpringBootStaticWebFileReferenceHelperKt;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.mvc.views.UrlBasedViewResolver;
import com.intellij.spring.mvc.views.ViewResolver;
import com.intellij.spring.mvc.views.ViewResolverFactory;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class SpringBootAutoConfigurationViewResolverFactoryBase
extends ViewResolverFactory {
    SpringBootAutoConfigurationViewResolverFactoryBase() {
    }

    @Nullable
    public final String getBeanClass() {
        return null;
    }

    @NotNull
    protected abstract String getViewResolverBeanName();

    @NotNull
    protected abstract Set<String> getViewResolverClassNames();

    @NotNull
    protected abstract Set<String> getAutoConfigurationClassNames();

    protected boolean isMine(@Nullable CommonSpringBean bean, @NotNull PsiClass beanClass) {
        if (beanClass == null) {
            SpringBootAutoConfigurationViewResolverFactoryBase.$$$reportNull$$$0(0);
        }
        return bean != null && this.matchesAutoConfigurationBean(bean, beanClass);
    }

    @NotNull
    protected Set<ViewResolver> createViewResolvers(@Nullable CommonSpringBean bean, CommonSpringModel model) {
        Module module = model.getModule();
        if (module == null) {
            return new HashSet<ViewResolver>();
        }
        Set<ViewResolver> set = SpringBootStaticWebFileReferenceHelperKt.getStaticResolvers(module);
        if (set == null) {
            SpringBootAutoConfigurationViewResolverFactoryBase.$$$reportNull$$$0(1);
        }
        return set;
    }

    protected boolean matchesAutoConfigurationBean(@NotNull CommonSpringBean bean, @NotNull PsiClass beanClass) {
        if (bean == null) {
            SpringBootAutoConfigurationViewResolverFactoryBase.$$$reportNull$$$0(2);
        }
        if (beanClass == null) {
            SpringBootAutoConfigurationViewResolverFactoryBase.$$$reportNull$$$0(3);
        }
        if (!SpringBootLibraryUtil.hasSpringBootLibrary(beanClass.getProject()) && !SpringMvcLibraryUtil.hasWebfluxLibrary((Project)beanClass.getProject())) {
            return false;
        }
        if (!this.getViewResolverBeanName().equals(bean.getBeanName())) {
            return false;
        }
        String qualifiedName = beanClass.getQualifiedName();
        if (qualifiedName == null || !this.getViewResolverClassNames().contains(qualifiedName)) {
            return false;
        }
        PsiElement beanPsiElement = bean.getIdentifyingPsiElement();
        if (!(beanPsiElement instanceof PsiMethod)) {
            return false;
        }
        PsiMethod psiMethod = (PsiMethod)beanPsiElement;
        PsiClass psiClass = psiMethod.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        String fqn = psiClass.getQualifiedName();
        return fqn != null && this.getAutoConfigurationClassNames().contains(fqn);
    }

    protected ViewResolver createURLBasedViewResolver(Module module, String path, String viewPrefix, String viewSuffix) {
        return this.createURLBasedViewResolver(module, path, viewPrefix, viewSuffix, "SpringBoot: " + ((Object)((Object)this)).getClass().getSimpleName());
    }

    @NotNull
    protected UrlBasedViewResolver createURLBasedViewResolver(Module module, String path, String viewPrefix, String viewSuffix, String id) {
        return new UrlBasedViewResolver(module, id, path, viewPrefix, viewSuffix);
    }

    @Nullable
    protected static String getConfigurationValue(CommonSpringModel model, String key) {
        assert (model.getModule() != null);
        return SpringBootConfigValueSearcher.productionForProfiles(model.getModule(), key, model.getActiveProfiles()).findValueText();
    }

    @Nullable
    protected static String getConfigurationOrDefaultValue(CommonSpringModel model, String key) {
        String value = SpringBootAutoConfigurationViewResolverFactoryBase.getConfigurationValue(model, key);
        if (value != null) {
            return value;
        }
        return SpringBootAutoConfigurationViewResolverFactoryBase.getDefaultValue(model, key);
    }

    @Nullable
    protected static String getDefaultValue(CommonSpringModel model, String key) {
        MetaConfigKey metaConfigKey = SpringBootApplicationMetaConfigKeyManager.getInstance().findCanonicalApplicationMetaConfigKey(model.getModule(), key);
        return metaConfigKey == null ? null : metaConfigKey.getDefaultValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/mvc/config/viewresolver/SpringBootAutoConfigurationViewResolverFactoryBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/mvc/config/viewresolver/SpringBootAutoConfigurationViewResolverFactoryBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createViewResolvers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isMine";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "matchesAutoConfigurationBean";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

