/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.lifecycle.mappings;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoBase;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.microservices.http.request.NavigatorHttpRequest;
import com.intellij.microservices.http.request.RequestNavigator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.mvc.lifecycle.mappings.gutter.LiveRequestMappingsNavigationHandler;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.LiveRequestMapping;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.LiveRequestMappingsModel;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.impl.LiveRequestMappingsParser;
import com.intellij.spring.boot.mvc.lifecycle.mappings.tab.RequestMappingsTab;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import com.intellij.spring.boot.run.lifecycle.CodeAnalyzerLivePropertyListener;
import com.intellij.spring.boot.run.lifecycle.Endpoint;
import com.intellij.spring.boot.run.lifecycle.LiveProperty;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationServerConfiguration;
import com.intellij.spring.boot.run.lifecycle.tabs.EndpointTab;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RequestMappingsEndpoint
extends Endpoint<LiveRequestMappingsModel> {
    private static final String ENDPOINT_ID = "mappings";
    private static final String ENDPOINT_NAME = "requestMappingEndpoint";

    public RequestMappingsEndpoint() {
        super(ENDPOINT_ID, ENDPOINT_NAME);
    }

    @Override
    public LiveRequestMappingsModel parseData(@Nullable Object data) {
        return new LiveRequestMappingsParser().parse((Map)data);
    }

    @Override
    @NotNull
    public EndpointTab<LiveRequestMappingsModel> createEndpointTab(@NotNull SpringBootApplicationRunConfigurationBase runConfiguration, @NotNull ProcessHandler processHandler) {
        if (runConfiguration == null) {
            RequestMappingsEndpoint.$$$reportNull$$$0(0);
        }
        if (processHandler == null) {
            RequestMappingsEndpoint.$$$reportNull$$$0(1);
        }
        return new RequestMappingsTab(this, runConfiguration, processHandler);
    }

    @Override
    public void infoCreated(@NotNull Project project, @NotNull ProcessHandler processHandler, @NotNull SpringBootApplicationInfo info) {
        if (project == null) {
            RequestMappingsEndpoint.$$$reportNull$$$0(2);
        }
        if (processHandler == null) {
            RequestMappingsEndpoint.$$$reportNull$$$0(3);
        }
        if (info == null) {
            RequestMappingsEndpoint.$$$reportNull$$$0(4);
        }
        LiveProperty<LiveRequestMappingsModel> endpointData = info.getEndpointData(this);
        CodeAnalyzerLivePropertyListener analyzerRestarter = new CodeAnalyzerLivePropertyListener(project);
        endpointData.addPropertyListener(analyzerRestarter);
        info.getApplicationUrl().addPropertyListener(analyzerRestarter);
        RequestMappingLinkListener linkListener = new RequestMappingLinkListener(project, processHandler, info);
        endpointData.addPropertyListener(linkListener);
        Disposer.register((Disposable)info, () -> AppUIUtil.invokeOnEdt(() -> linkListener.clearLinks()));
    }

    @Override
    public boolean isAvailable(@Nullable Module module) {
        return SpringBootLibraryUtil.hasRequestMappings(module);
    }

    public static Endpoint<LiveRequestMappingsModel> getInstance() {
        return (Endpoint)Endpoint.EP_NAME.findExtension(RequestMappingsEndpoint.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/mvc/lifecycle/mappings/RequestMappingsEndpoint";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createEndpointTab";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "infoCreated";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class RequestMappingLinkListener
    implements LiveProperty.LivePropertyListener {
        private final Project myProject;
        private final ProcessHandler myProcessHandler;
        private final SpringBootApplicationInfo myInfo;
        private Disposable myLinksDisposer;

        RequestMappingLinkListener(Project project, ProcessHandler processHandler, SpringBootApplicationInfo info) {
            this.myProject = project;
            this.myProcessHandler = processHandler;
            this.myInfo = info;
        }

        @Override
        public void propertyChanged() {
            String applicationUrl = this.myInfo.getApplicationUrl().getValue();
            if (applicationUrl == null) {
                return;
            }
            ExecutionConsole console = this.findConsole();
            if (!(console instanceof ConsoleViewImpl)) {
                return;
            }
            ConsoleViewImpl consoleView = (ConsoleViewImpl)console;
            Condition disposed = o -> {
                if (Disposer.isDisposed((Disposable)this.myInfo)) {
                    return true;
                }
                Editor editor = consoleView.getEditor();
                return editor == null || editor.isDisposed();
            };
            SpringBootApplicationServerConfiguration applicationServerConfiguration = this.myInfo.getServerConfiguration().getValue();
            String servletPath = applicationServerConfiguration == null ? null : applicationServerConfiguration.getServletPath();
            AppUIExecutor.onUiThread().submit(() -> {
                if (disposed.value(null)) {
                    return;
                }
                LiveRequestMappingsModel model = this.myInfo.getEndpointData(RequestMappingsEndpoint.this).getValue();
                if (model == null) {
                    return;
                }
                consoleView.performWhenNoDeferredOutput(() -> {
                    if (disposed.value(null)) {
                        return;
                    }
                    this.clearLinks();
                    String text = consoleView.getText();
                    EditorHyperlinkSupport hyperlinkSupport = consoleView.getHyperlinks();
                    SmartList highlighters = new SmartList();
                    List<LiveRequestMapping> mappings = model.getRequestMappings();
                    for (LiveRequestMapping mapping : mappings) {
                        NavigatorHttpRequest request;
                        List navigators;
                        int index;
                        if (mapping.getMethod() == null || !mapping.getPath().startsWith("/") || (index = text.indexOf(mapping.getMapping())) < 0 || (navigators = RequestNavigator.getRequestNavigators((NavigatorHttpRequest)(request = LiveRequestMappingsNavigationHandler.createRequest(applicationUrl, servletPath, mapping)))).isEmpty()) continue;
                        LiveRequestMappingsNavigationHandler.MethodNavigationItem navigationItem = new LiveRequestMappingsNavigationHandler.MethodNavigationItem(this.myProject, this.myInfo, applicationUrl, servletPath, (List<LiveRequestMapping>)new SmartList((Object)mapping), "EditorPopup");
                        final LiveRequestMappingsNavigationHandler navigationHandler = new LiveRequestMappingsNavigationHandler((List<LiveRequestMappingsNavigationHandler.MethodNavigationItem>)new SmartList((Object)navigationItem));
                        int offset = text.indexOf(mapping.getPath(), index);
                        if (offset < 0) continue;
                        RangeHighlighter highlighter = hyperlinkSupport.createHyperlink(offset, offset + mapping.getPath().length(), SimpleTextAttributes.LINK_ATTRIBUTES.toTextAttributes(), (HyperlinkInfo)new HyperlinkInfoBase(){

                            public void navigate(@NotNull Project project, @Nullable RelativePoint hyperlinkLocationPoint) {
                                if (project == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                navigationHandler.navigate(hyperlinkLocationPoint);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/mvc/lifecycle/mappings/RequestMappingsEndpoint$RequestMappingLinkListener$1", "navigate"));
                            }
                        });
                        highlighters.add(highlighter);
                    }
                    this.myLinksDisposer = () -> this.lambda$propertyChanged$1((List)highlighters, hyperlinkSupport);
                    Disposer.register((Disposable)consoleView, (Disposable)this.myLinksDisposer);
                });
            });
        }

        private ExecutionConsole findConsole() {
            for (RunContentDescriptor descriptor : RunContentManager.getInstance((Project)this.myProject).getAllDescriptors()) {
                if (descriptor.getProcessHandler() != this.myProcessHandler) continue;
                return descriptor.getExecutionConsole();
            }
            return null;
        }

        void clearLinks() {
            Disposable linksDisposer = this.myLinksDisposer;
            if (linksDisposer != null) {
                this.myLinksDisposer = null;
                Disposer.dispose((Disposable)linksDisposer);
            }
        }

        private /* synthetic */ void lambda$propertyChanged$1(List highlighters, EditorHyperlinkSupport hyperlinkSupport) {
            if (this.myLinksDisposer != null) {
                this.myLinksDisposer = null;
            } else {
                for (RangeHighlighter highlighter : highlighters) {
                    hyperlinkSupport.removeHyperlink(highlighter);
                }
            }
        }
    }
}

