/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.lifecycle.mappings.gutter;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.microservices.http.request.NavigatorHttpRequest;
import com.intellij.microservices.http.request.RequestNavigator;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.boot.SpringBootApiIcons;
import com.intellij.spring.boot.mvc.SpringBootMvcBundle;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.LiveRequestMapping;
import com.intellij.spring.boot.mvc.statistics.SpringBootMvcUsageCollector;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationUrlUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.SmartList;
import com.intellij.util.ui.JBUI;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiveRequestMappingsNavigationHandler
implements GutterIconNavigationHandler<PsiElement> {
    private final List<MethodNavigationItem> myItems;

    public LiveRequestMappingsNavigationHandler(List<MethodNavigationItem> items2) {
        this.myItems = items2;
    }

    @NlsContexts.Tooltip
    String getLiveMarkerInfoTooltipText() {
        if (this.myItems.size() == 1) {
            MethodNavigationItem item = this.myItems.get(0);
            if (item.mappings.size() == 1) {
                return LiveRequestMappingsNavigationHandler.getMappingUrl(item.applicationUrl, item.servletPath, item.mappings.get(0)) + " [" + item.info.getRunProfile().getName() + "]";
            }
            return item.info.getRunProfile().getName();
        }
        return SpringBootMvcBundle.message("spring.boot.live.request.mapping.gutter.name", new Object[0]);
    }

    public void navigate(MouseEvent e, PsiElement element) {
        this.navigate(new RelativePoint(e));
    }

    public void navigate(RelativePoint relativePoint) {
        if (this.myItems.isEmpty()) {
            return;
        }
        if (this.myItems.size() == 1) {
            MethodNavigationItem item = this.myItems.get(0);
            if (item.mappings.size() == 1) {
                RequestNavigatorPopupStep navigatorsStep = LiveRequestMappingsNavigationHandler.navigateToMapping(item, item.mappings.get(0));
                if (navigatorsStep != null) {
                    JBPopupFactory.getInstance().createListPopup((ListPopupStep)navigatorsStep).show(relativePoint);
                }
            } else {
                LiveRequestMappingsNavigationHandler.showPopup(relativePoint, (ListPopup)LiveRequestMappingsNavigationHandler.createMappingsPopup(item.project, null, item), item.project);
            }
        } else {
            Project project = this.myItems.get((int)0).project;
            LiveRequestMappingsNavigationHandler.showPopup(relativePoint, LiveRequestMappingsNavigationHandler.createApplicationsPopup(project, this.myItems), project);
        }
    }

    private static void showPopup(RelativePoint relativePoint, ListPopup popup, Project project) {
        NavigationUtil.hidePopupIfDumbModeStarts((JBPopup)popup, (Project)project);
        popup.show(relativePoint);
    }

    @NotNull
    private static ListPopup createApplicationsPopup(Project project, List<MethodNavigationItem> items2) {
        return new ListPopupImpl(project, (ListPopupStep)new ApplicationsPopupStep(items2)){

            protected WizardPopup createPopup(WizardPopup parent, PopupStep step, Object parentValue) {
                if (!(step instanceof ListPopupStep)) {
                    throw new IllegalArgumentException("Step: " + step.getClass().toString());
                }
                if (!(parentValue instanceof MethodNavigationItem)) {
                    throw new IllegalArgumentException("Parent value: " + step.getClass().toString());
                }
                return LiveRequestMappingsNavigationHandler.createMappingsPopup(this.getProject(), parent, (MethodNavigationItem)parentValue);
            }
        };
    }

    @NotNull
    private static ListPopupImpl createMappingsPopup(Project project, WizardPopup parent, final MethodNavigationItem item) {
        final MappingsPopupStep step = new MappingsPopupStep(item);
        return new ListPopupImpl(project, parent, (ListPopupStep)step, item){

            protected ListCellRenderer<?> getListElementRenderer() {
                return new LiveRequestMappingPopupRenderer(this, step, item.applicationUrl, item.servletPath);
            }
        };
    }

    private static RequestNavigatorPopupStep navigateToMapping(MethodNavigationItem item, LiveRequestMapping mapping) {
        NavigatorHttpRequest request = LiveRequestMappingsNavigationHandler.createRequest(item.applicationUrl, item.servletPath, mapping);
        List navigators = RequestNavigator.getRequestNavigators((NavigatorHttpRequest)request);
        if (navigators.isEmpty()) {
            return null;
        }
        if (navigators.size() == 1) {
            ((RequestNavigator)navigators.get(0)).navigate(item.project, request, item.info.getRunProfile().getName());
            SpringBootMvcUsageCollector.logNavigation(item.project, ((RequestNavigator)navigators.get(0)).getClass(), item.place);
            return null;
        }
        return new RequestNavigatorPopupStep(item, request, navigators);
    }

    public static NavigatorHttpRequest createRequest(String applicationUrl, String servletPath, LiveRequestMapping mapping) {
        String url = LiveRequestMappingsNavigationHandler.getMappingUrl(applicationUrl, servletPath, mapping);
        List<String> requestMethods = mapping.getRequestMethods();
        String requestMethod = requestMethods.isEmpty() || requestMethods.contains("GET") ? "GET" : requestMethods.get(0);
        List headers = (List)mapping.getHeaders().stream().filter(header -> !((String)header.first).startsWith("!")).collect(Collectors.toCollection(SmartList::new));
        mapping.getProduces().stream().filter(value -> !value.startsWith("!")).findFirst().ifPresent(value -> headers.add(Pair.create((Object)"Accept", (Object)value)));
        mapping.getConsumes().stream().filter(value -> !value.startsWith("!")).findFirst().ifPresent(value -> headers.add(Pair.create((Object)"Content-Type", (Object)value)));
        List params = (List)mapping.getParams().stream().filter(param -> !((String)param.first).startsWith("!")).collect(Collectors.toCollection(SmartList::new));
        return new NavigatorHttpRequest(url, requestMethod, headers, params);
    }

    @NlsSafe
    public static String getMappingUrl(String applicationUrl, String servletPath, LiveRequestMapping mapping) {
        String servletMappingPath = mapping.getDispatcherServlet().getServletMappingPath();
        if (servletMappingPath != null) {
            servletPath = servletMappingPath;
        }
        return SpringBootApplicationUrlUtil.getInstance().getMappingUrl(applicationUrl, servletPath, mapping.getPath());
    }

    @NotNull
    public List<GotoRelatedItem> getRelatedItems(@NotNull PsiElement element) {
        if (element == null) {
            LiveRequestMappingsNavigationHandler.$$$reportNull$$$0(0);
        }
        List<GotoRelatedItem> list = this.myItems.stream().flatMap(item -> item.mappings.stream().map(mapping -> Pair.create((Object)item, (Object)LiveRequestMappingsNavigationHandler.createRequest(item.applicationUrl, item.servletPath, mapping)))).flatMap(itemAndRequest -> RequestNavigator.getRequestNavigators().stream().filter(navigator -> navigator.accept((NavigatorHttpRequest)itemAndRequest.getSecond()) && navigator.hasTarget()).map(navigator -> Trinity.create((Object)((MethodNavigationItem)itemAndRequest.first), (Object)((NavigatorHttpRequest)itemAndRequest.second), (Object)navigator))).map(itemAndRequestAndNavigator -> LiveRequestMappingsNavigationHandler.createGotoRelatedItem(element, (MethodNavigationItem)itemAndRequestAndNavigator.getFirst(), (NavigatorHttpRequest)itemAndRequestAndNavigator.getSecond(), (RequestNavigator)itemAndRequestAndNavigator.getThird())).collect(Collectors.toList());
        if (list == null) {
            LiveRequestMappingsNavigationHandler.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static GotoRelatedItem createGotoRelatedItem(final @NotNull PsiElement element, final @NotNull MethodNavigationItem item, final @NotNull NavigatorHttpRequest request, final @NotNull RequestNavigator navigator) {
        if (element == null) {
            LiveRequestMappingsNavigationHandler.$$$reportNull$$$0(2);
        }
        if (item == null) {
            LiveRequestMappingsNavigationHandler.$$$reportNull$$$0(3);
        }
        if (request == null) {
            LiveRequestMappingsNavigationHandler.$$$reportNull$$$0(4);
        }
        if (navigator == null) {
            LiveRequestMappingsNavigationHandler.$$$reportNull$$$0(5);
        }
        return new GotoRelatedItem(element, navigator.getNavigationGroupName()){

            @NotNull
            @NlsContexts.ListItem
            public String getCustomName() {
                String string = navigator.getNavigationMessage(request);
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Nullable
            public Icon getCustomIcon() {
                return navigator.getIcon();
            }

            @Nullable
            public PsiElement getElement() {
                return null;
            }

            public void navigate() {
                navigator.navigate(element.getProject(), request, item.info.getRunProfile().getName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/mvc/lifecycle/mappings/gutter/LiveRequestMappingsNavigationHandler$3", "getCustomName"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/mvc/lifecycle/mappings/gutter/LiveRequestMappingsNavigationHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/mvc/lifecycle/mappings/gutter/LiveRequestMappingsNavigationHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedItems";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createGotoRelatedItem";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static class MethodNavigationItem {
        final Project project;
        final SpringBootApplicationInfo info;
        final String applicationUrl;
        final String servletPath;
        final List<LiveRequestMapping> mappings;
        final String place;

        public MethodNavigationItem(Project project, SpringBootApplicationInfo info, String applicationUrl, String servletPath, List<LiveRequestMapping> mappings, String place) {
            this.project = project;
            this.info = info;
            this.applicationUrl = applicationUrl;
            this.servletPath = servletPath;
            this.mappings = mappings;
            this.place = place;
        }
    }

    private static class RequestNavigatorPopupStep
    extends BaseListPopupStep<RequestNavigator> {
        private final MethodNavigationItem myItem;
        private final NavigatorHttpRequest myRequest;

        RequestNavigatorPopupStep(MethodNavigationItem item, NavigatorHttpRequest request, List<RequestNavigator> navigators) {
            super(null, navigators);
            this.myItem = item;
            this.myRequest = request;
        }

        public Icon getIconFor(RequestNavigator navigator) {
            return navigator.getIcon();
        }

        @NotNull
        public String getTextFor(RequestNavigator navigator) {
            String string = navigator.getDisplayText();
            if (string == null) {
                RequestNavigatorPopupStep.$$$reportNull$$$0(0);
            }
            return string;
        }

        public PopupStep<?> onChosen(RequestNavigator navigator, boolean finalChoice) {
            return this.doFinalStep(() -> {
                navigator.navigate(this.myItem.project, this.myRequest, this.myItem.info.getRunProfile().getName());
                SpringBootMvcUsageCollector.logNavigation(this.myItem.project, navigator.getClass(), this.myItem.place);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/mvc/lifecycle/mappings/gutter/LiveRequestMappingsNavigationHandler$RequestNavigatorPopupStep", "getTextFor"));
        }
    }

    private static class ApplicationsPopupStep
    extends BaseListPopupStep<MethodNavigationItem> {
        ApplicationsPopupStep(List<MethodNavigationItem> items2) {
            super(SpringBootMvcBundle.message("spring.boot.live.request.mapping.gutter.popup.title", new Object[0]), items2);
        }

        @NotNull
        public String getTextFor(MethodNavigationItem item) {
            String string = item.info.getRunProfile().getName();
            if (string == null) {
                ApplicationsPopupStep.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public boolean hasSubstep(MethodNavigationItem item) {
            return true;
        }

        public Icon getIconFor(MethodNavigationItem item) {
            return SpringBootApiIcons.SpringBoot;
        }

        public PopupStep<?> onChosen(MethodNavigationItem item, boolean finalChoice) {
            return new MappingsPopupStep(item);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/mvc/lifecycle/mappings/gutter/LiveRequestMappingsNavigationHandler$ApplicationsPopupStep", "getTextFor"));
        }
    }

    private static class MappingsPopupStep
    extends BaseListPopupStep<LiveRequestMapping> {
        private final MethodNavigationItem myItem;

        MappingsPopupStep(MethodNavigationItem item) {
            super(item.info.getRunProfile().getName(), item.mappings);
            this.myItem = item;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public boolean hasSubstep(LiveRequestMapping mapping) {
            NavigatorHttpRequest request = LiveRequestMappingsNavigationHandler.createRequest(this.myItem.applicationUrl, this.myItem.servletPath, mapping);
            return RequestNavigator.getRequestNavigators((NavigatorHttpRequest)request).size() > 1;
        }

        public boolean isSelectable(LiveRequestMapping mapping) {
            NavigatorHttpRequest request = LiveRequestMappingsNavigationHandler.createRequest(this.myItem.applicationUrl, this.myItem.servletPath, mapping);
            return !RequestNavigator.getRequestNavigators((NavigatorHttpRequest)request).isEmpty();
        }

        public PopupStep<?> onChosen(LiveRequestMapping mapping, boolean finalChoice) {
            return LiveRequestMappingsNavigationHandler.navigateToMapping(this.myItem, mapping);
        }
    }

    private static class LiveRequestMappingPopupRenderer
    extends PopupListElementRenderer<LiveRequestMapping> {
        private final MappingsPopupStep myPopupStep;
        private final String myApplicationUrl;
        private final String myServletPath;
        private SimpleColoredComponent myLabel;

        LiveRequestMappingPopupRenderer(ListPopupImpl popup, MappingsPopupStep popupStep, String applicationUrl, String servletPath) {
            super(popup);
            this.myPopupStep = popupStep;
            this.myApplicationUrl = applicationUrl;
            this.myServletPath = servletPath;
        }

        protected JComponent createItemComponent() {
            this.createLabel();
            this.myLabel = new SimpleColoredComponent();
            this.myLabel.setBorder((Border)JBUI.Borders.emptyBottom((int)1));
            return this.layoutComponent((JComponent)this.myLabel);
        }

        protected void customizeComponent(JList<? extends LiveRequestMapping> list, LiveRequestMapping value, boolean isSelected) {
            super.customizeComponent(list, (Object)value, isSelected);
            this.myLabel.clear();
            boolean isSelectable = this.myPopupStep.isSelectable(value);
            this.myLabel.setEnabled(isSelectable);
            this.myLabel.setIcon(SpringApiIcons.RequestMapping);
            @NlsSafe String mappingUrl = LiveRequestMappingsNavigationHandler.getMappingUrl(this.myApplicationUrl, this.myServletPath, value);
            this.myLabel.append(mappingUrl, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            List<String> requestMethods = value.getRequestMethods();
            if (!requestMethods.isEmpty()) {
                this.myLabel.append(" [" + StringUtil.join(requestMethods, (String)"|") + "]", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        }
    }
}

