/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.lifecycle.mappings.model.impl;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.jam.JamService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.boot.mvc.lifecycle.mappings.model.LiveHandlerMethod;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveHandlerMethodImpl
implements LiveHandlerMethod {
    static final String LAMBDA = "$$Lambda";
    private static final Set<String> MODIFIERS = Set.of(PsiModifier.MODIFIERS);
    @NotNull
    private final String myRawMethod;
    private String myClassName;
    private int myNameIndex;
    private String myMethodName;
    private final List<String> myParameters;

    LiveHandlerMethodImpl(@NotNull String rawMethod) {
        if (rawMethod == null) {
            LiveHandlerMethodImpl.$$$reportNull$$$0(0);
        }
        this.myClassName = "";
        this.myNameIndex = -1;
        this.myMethodName = "";
        this.myParameters = new SmartList();
        this.myRawMethod = rawMethod;
        this.parseRawMethod(rawMethod);
    }

    private void parseRawMethod(@NotNull String rawMethod) {
        int methodEnd;
        int modifiersEnd;
        int lambda;
        if (rawMethod == null) {
            LiveHandlerMethodImpl.$$$reportNull$$$0(1);
        }
        if ((lambda = rawMethod.indexOf(LAMBDA)) > 0) {
            this.parseClassName(rawMethod.substring(0, lambda));
            this.myMethodName = LAMBDA;
            return;
        }
        rawMethod = rawMethod.replaceAll(",\\s", ",");
        String[] parts = rawMethod.split("\\s");
        for (modifiersEnd = 0; modifiersEnd < parts.length && LiveHandlerMethodImpl.isModifier(parts[modifiersEnd]); ++modifiersEnd) {
        }
        rawMethod = parts[parts.length == modifiersEnd + 1 ? modifiersEnd : modifiersEnd + 1];
        int nameEnd = rawMethod.indexOf(40);
        if (nameEnd < 0) {
            return;
        }
        int nameStart = rawMethod.lastIndexOf(46, nameEnd);
        if (nameStart >= 0) {
            this.parseClassName(rawMethod.substring(0, nameStart));
            this.myMethodName = rawMethod.substring(nameStart + 1, nameEnd);
        }
        if ((methodEnd = rawMethod.lastIndexOf(41)) <= nameEnd) {
            return;
        }
        String parametersString = rawMethod.substring(nameEnd + 1, methodEnd);
        if (parametersString.isEmpty()) {
            return;
        }
        List parameters = StringUtil.split((String)parametersString, (String)",");
        String previous = "";
        for (String parameter : parameters) {
            String parameterCandidate;
            String string = parameterCandidate = previous.isEmpty() ? parameter : previous + "," + parameter;
            if (StringUtil.countChars((CharSequence)parameterCandidate, (char)'<') == StringUtil.countChars((CharSequence)parameterCandidate, (char)'>')) {
                this.myParameters.add(StringUtil.replace((String)parameterCandidate, (String)"$", (String)"."));
                previous = "";
                continue;
            }
            previous = parameterCandidate;
        }
    }

    private void parseClassName(String qualifiedName) {
        int nameIndex = qualifiedName.lastIndexOf(46);
        if (nameIndex >= 0 && nameIndex < qualifiedName.length() - 1) {
            this.myNameIndex = nameIndex + 1;
        }
        this.myClassName = StringUtil.replace((String)qualifiedName, (String)"$", (String)".");
    }

    @Override
    @NotNull
    public String getRawMethod() {
        String string = this.myRawMethod;
        if (string == null) {
            LiveHandlerMethodImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getClassName() {
        String string = this.myClassName;
        if (string == null) {
            LiveHandlerMethodImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getMethodName() {
        String string = this.myMethodName;
        if (string == null) {
            LiveHandlerMethodImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public List<String> getParameters() {
        List<String> list = Collections.unmodifiableList(this.myParameters);
        if (list == null) {
            LiveHandlerMethodImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        if (this.myClassName.isEmpty() || this.myMethodName.isEmpty()) {
            String string = this.myRawMethod;
            if (string == null) {
                LiveHandlerMethodImpl.$$$reportNull$$$0(6);
            }
            return string;
        }
        String className = this.myNameIndex >= 0 ? this.myClassName.substring(this.myNameIndex) : this.myClassName;
        String string = className + (this.myMethodName.equals(LAMBDA) ? "" : "#") + this.myMethodName;
        if (string == null) {
            LiveHandlerMethodImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @Nullable
    public PsiClass findContainingClass(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            LiveHandlerMethodImpl.$$$reportNull$$$0(8);
        }
        if (searchScope == null) {
            LiveHandlerMethodImpl.$$$reportNull$$$0(9);
        }
        if (this.myClassName.isEmpty()) {
            return null;
        }
        return JavaExecutionUtil.findMainClass((Project)project, (String)this.myClassName, (GlobalSearchScope)searchScope);
    }

    @Override
    @Nullable
    public PsiMethod findMethod(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        PsiMethod[] methods;
        if (project == null) {
            LiveHandlerMethodImpl.$$$reportNull$$$0(10);
        }
        if (searchScope == null) {
            LiveHandlerMethodImpl.$$$reportNull$$$0(11);
        }
        if (this.myMethodName.isEmpty()) {
            return null;
        }
        PsiClass psiClass = this.findContainingClass(project, searchScope);
        if (psiClass == null) {
            return null;
        }
        if (this.myMethodName.equals(LAMBDA)) {
            for (PsiMethod psiMethod : psiClass.getMethods()) {
                if (!LiveHandlerMethodImpl.isRouterFunctionBean(psiMethod)) continue;
                return psiMethod;
            }
        }
        for (PsiMethod method : methods = psiClass.findMethodsByName(this.myMethodName, false)) {
            if (!this.matchParameters(method)) continue;
            return method;
        }
        return null;
    }

    @Override
    public boolean matches(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            LiveHandlerMethodImpl.$$$reportNull$$$0(12);
        }
        if (!psiMethod.isValid()) {
            return false;
        }
        PsiClass psiClass = psiMethod.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        if (!this.myClassName.equals(psiClass.getQualifiedName())) {
            return false;
        }
        if (this.myMethodName.equals(LAMBDA)) {
            return LiveHandlerMethodImpl.isRouterFunctionBean(psiMethod);
        }
        return this.myMethodName.equals(psiMethod.getName()) && this.matchParameters(psiMethod);
    }

    private boolean matchParameters(@NotNull PsiMethod psiMethod) {
        PsiParameter[] parameters;
        if (psiMethod == null) {
            LiveHandlerMethodImpl.$$$reportNull$$$0(13);
        }
        if ((parameters = psiMethod.getParameterList().getParameters()).length != this.myParameters.size()) {
            return false;
        }
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            String liveParameter = this.myParameters.get(i);
            if (LiveHandlerMethodImpl.isEquivalent(liveParameter, parameter.getType())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LiveHandlerMethodImpl) {
            return this.myRawMethod.equals(((LiveHandlerMethodImpl)obj).myRawMethod);
        }
        return false;
    }

    public int hashCode() {
        return this.myRawMethod.hashCode();
    }

    public String toString() {
        return this.myRawMethod;
    }

    private static boolean isModifier(@NotNull String string) {
        if (string == null) {
            LiveHandlerMethodImpl.$$$reportNull$$$0(14);
        }
        return MODIFIERS.contains(string);
    }

    private static boolean isEquivalent(String type, PsiType psiType) {
        String canonicalText = psiType.getCanonicalText();
        if (type.equals(canonicalText)) {
            return true;
        }
        int genericStart = canonicalText.indexOf(60);
        return genericStart >= 0 && type.equals(canonicalText = canonicalText.substring(0, genericStart));
    }

    static boolean isRouterFunctionBean(PsiMethod psiMethod) {
        PsiType psiType = psiMethod.getReturnType();
        if (psiType == null) {
            return false;
        }
        if (LiveHandlerMethodImpl.isEquivalent("org.springframework.web.reactive.function.server.RouterFunction", psiType) || LiveHandlerMethodImpl.isEquivalent("org.springframework.web.servlet.function.RouterFunction", psiType)) {
            return JamService.getJamService((Project)psiMethod.getProject()).getJamElement(ContextJavaBean.BEAN_JAM_KEY, (PsiElement)psiMethod) != null;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawMethod";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/mvc/lifecycle/mappings/model/impl/LiveHandlerMethodImpl";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/mvc/lifecycle/mappings/model/impl/LiveHandlerMethodImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawMethod";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseRawMethod";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findContainingClass";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findMethod";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "matchParameters";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isModifier";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

