/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.properties.datasource.config.provider;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.persistence.database.ConfigDataSourcePropertyInfo;
import com.intellij.persistence.database.ConfigurationFileInfo;
import com.intellij.persistence.database.RecognizedDatabaseConfig;
import com.intellij.persistence.database.config.impl.urlParser.CassandraUrl;
import com.intellij.persistence.database.config.impl.urlParser.DatabaseType;
import com.intellij.persistence.database.config.impl.urlParser.DatabaseUrlParserKt;
import com.intellij.persistence.database.config.impl.urlParser.DatabasesKt;
import com.intellij.spring.boot.properties.datasource.SpringBootConfigPropertyValueSearcher;
import com.intellij.spring.boot.properties.datasource.config.provider.SpringBootDataSourceConfigProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/spring/boot/properties/datasource/config/provider/SpringBootCassandraDataSourceConfigProvider;", "Lcom/intellij/spring/boot/properties/datasource/config/provider/SpringBootDataSourceConfigProvider;", "<init>", "()V", "getConfigs", "", "Lcom/intellij/persistence/database/RecognizedDatabaseConfig;", "fileInfo", "Lcom/intellij/persistence/database/ConfigurationFileInfo;", "propertyInfo", "Lcom/intellij/persistence/database/ConfigDataSourcePropertyInfo;", "retrieveUrls", "Lcom/intellij/persistence/database/config/impl/urlParser/CassandraUrl;", "propertySearcher", "Lcom/intellij/spring/boot/properties/datasource/SpringBootConfigPropertyValueSearcher;", "intellij.spring.boot.properties.datasource"})
@SourceDebugExtension(value={"SMAP\nSpringBootCassandraDataSourceConfigProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBootCassandraDataSourceConfigProvider.kt\ncom/intellij/spring/boot/properties/datasource/config/provider/SpringBootCassandraDataSourceConfigProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1557#2:52\n1628#2,3:53\n1611#2,9:56\n1863#2:65\n1864#2:67\n1620#2:68\n1#3:66\n*S KotlinDebug\n*F\n+ 1 SpringBootCassandraDataSourceConfigProvider.kt\ncom/intellij/spring/boot/properties/datasource/config/provider/SpringBootCassandraDataSourceConfigProvider\n*L\n26#1:52\n26#1:53,3\n42#1:56,9\n42#1:65\n42#1:67\n42#1:68\n42#1:66\n*E\n"})
public final class SpringBootCassandraDataSourceConfigProvider
extends SpringBootDataSourceConfigProvider {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<RecognizedDatabaseConfig> getConfigs(@NotNull ConfigurationFileInfo fileInfo, @NotNull ConfigDataSourcePropertyInfo propertyInfo) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)fileInfo, (String)"fileInfo");
        Intrinsics.checkNotNullParameter((Object)propertyInfo, (String)"propertyInfo");
        DatabaseDriver databaseDriver = DatabasesKt.findDatabaseDriver((DatabaseType)DatabaseType.CASSANDRA);
        if (databaseDriver == null) {
            return CollectionsKt.emptyList();
        }
        DatabaseDriver driver = databaseDriver;
        SpringBootConfigPropertyValueSearcher propertySearcher = new SpringBootConfigPropertyValueSearcher(fileInfo, propertyInfo.getDocumentId());
        List<CassandraUrl> urls = this.retrieveUrls(propertySearcher);
        Iterable $this$map$iv = urls;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void url;
            CassandraUrl cassandraUrl = (CassandraUrl)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = url.toDbDialogUrl();
            String string2 = driver.getDriverClass();
            if (string2 == null) {
                string2 = "";
            }
            collection.add(new RecognizedDatabaseConfig(string, string2, propertySearcher.find("spring.cassandra.username"), propertySearcher.find("spring.cassandra.password"), url.dataSourceItemName()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<CassandraUrl> retrieveUrls(SpringBootConfigPropertyValueSearcher propertySearcher) {
        void $this$mapNotNullTo$iv$iv;
        String[] stringArray;
        Object object = propertySearcher.find("spring.cassandra.contact-points");
        if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{","}), (boolean)false, (int)0, (int)6, null)) == null) {
            object = CollectionsKt.listOf((Object)"127.0.0.1");
        }
        Object contactPoints = object;
        String keySpace = propertySearcher.find("spring.cassandra.keyspace-name");
        Object object2 = propertySearcher.find("spring.cassandra.port");
        int port = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : 9042;
        Iterable $this$mapNotNull$iv = (Iterable)contactPoints;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            CassandraUrl cassandraUrl;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String point = (String)element$iv$iv;
            boolean bl2 = false;
            if (DatabaseUrlParserKt.retrieveHostAndPort((String)point, (String)"127.0.0.1", (Integer)port) == null) {
                cassandraUrl = null;
            } else {
                Integer specifiedPort;
                Pair pair;
                String host = (String)pair.component1();
                Integer n = specifiedPort = (Integer)pair.component2();
                cassandraUrl = new CassandraUrl(host, n != null ? n : port, keySpace);
            }
            if (cassandraUrl == null) continue;
            CassandraUrl it$iv$iv = cassandraUrl;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

