/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.target.ResolvedPortBinding;
import com.intellij.execution.target.ResolvedPortBindingKt;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.util.net.NetUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u0000 \u00122\u00020\u0001:\u0003\u0010\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH&J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH&\u00a8\u0006\u0013"}, d2={"Lcom/intellij/spring/boot/run/SpringBootJmxSetup;", "", "<init>", "()V", "setupJmxParameters", "", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "targetRequest", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "handleCreatedEnvironment", "environment", "Lcom/intellij/execution/target/TargetEnvironment;", "setupProcessHandler", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "LocalSetup", "RemoteSetup", "Companion", "intellij.spring.boot.run"})
public abstract class SpringBootJmxSetup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String JMX_REGISTRY_PORT = "com.sun.management.jmxremote.port";
    @NotNull
    private static final String JMX_RMI_SERVER_PORT = "com.sun.management.jmxremote.rmi.port";
    @NotNull
    private static final String JMX_REMOTE_AUTH = "com.sun.management.jmxremote.authenticate";
    @NotNull
    private static final String JMX_REMOTE_SSL = "com.sun.management.jmxremote.ssl";
    @NotNull
    private static final String JMX_RMI_SERVER_HOST = "java.rmi.server.hostname";
    @NotNull
    private static final String JMX_REGISTRY_HOST = "com.sun.management.jmxremote.host";
    @NotNull
    private static final String ANY_HOST = "0.0.0.0";
    private static final int DEFAULT_JMX_REGISTRY_PORT = 5000;

    public abstract void setupJmxParameters(@NotNull JavaParameters var1, @NotNull TargetEnvironmentRequest var2) throws ExecutionException;

    public abstract void handleCreatedEnvironment(@NotNull TargetEnvironment var1);

    public abstract void setupProcessHandler(@NotNull ProcessHandler var1);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/spring/boot/run/SpringBootJmxSetup$Companion;", "", "<init>", "()V", "JMX_REGISTRY_PORT", "", "JMX_RMI_SERVER_PORT", "JMX_REMOTE_AUTH", "JMX_REMOTE_SSL", "JMX_RMI_SERVER_HOST", "JMX_REGISTRY_HOST", "ANY_HOST", "DEFAULT_JMX_REGISTRY_PORT", "", "intellij.spring.boot.run"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/spring/boot/run/SpringBootJmxSetup$LocalSetup;", "Lcom/intellij/spring/boot/run/SpringBootJmxSetup;", "<init>", "()V", "myJmxPort", "", "setupJmxParameters", "", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "targetRequest", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "handleCreatedEnvironment", "environment", "Lcom/intellij/execution/target/TargetEnvironment;", "setupProcessHandler", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "intellij.spring.boot.run"})
    public static final class LocalSetup
    extends SpringBootJmxSetup {
        private int myJmxPort = -1;

        @Override
        public void setupJmxParameters(@NotNull JavaParameters params, @NotNull TargetEnvironmentRequest targetRequest) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)targetRequest, (String)"targetRequest");
            boolean bl = targetRequest instanceof LocalTargetEnvironmentRequest;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            ParametersList vmParametersList = params.getVMParametersList();
            String auth = vmParametersList.getPropertyValue(SpringBootJmxSetup.JMX_REMOTE_AUTH);
            if (!StringsKt.equals((String)"false", (String)auth, (boolean)true)) {
                return;
            }
            String ssl = vmParametersList.getPropertyValue(SpringBootJmxSetup.JMX_REMOTE_SSL);
            if (!StringsKt.equals((String)"false", (String)ssl, (boolean)true)) {
                return;
            }
            String jmxPort = vmParametersList.getPropertyValue(SpringBootJmxSetup.JMX_REGISTRY_PORT);
            if (jmxPort != null) {
                try {
                    this.myJmxPort = Integer.parseInt(jmxPort);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void handleCreatedEnvironment(@NotNull TargetEnvironment environment) {
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        }

        @Override
        public void setupProcessHandler(@NotNull ProcessHandler processHandler) {
            Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
            if (this.myJmxPort > 0) {
                processHandler.putUserData(SpringBootApplicationLifecycleManager.JMX_PORT, (Object)this.myJmxPort);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/spring/boot/run/SpringBootJmxSetup$RemoteSetup;", "Lcom/intellij/spring/boot/run/SpringBootJmxSetup;", "<init>", "()V", "myResolvedEnvironment", "Lcom/intellij/execution/target/TargetEnvironment;", "myJmxPortBinding", "Lcom/intellij/execution/target/TargetEnvironment$TargetPortBinding;", "setupJmxParameters", "", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "targetRequest", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "setupJmxPorts", "vmParametersList", "Lcom/intellij/execution/configurations/ParametersList;", "setupJmxSecurity", "setupJmxHosts", "handleCreatedEnvironment", "environment", "setupProcessHandler", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "Companion", "intellij.spring.boot.run"})
    @SourceDebugExtension(value={"SMAP\nSpringBootJmxSetup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBootJmxSetup.kt\ncom/intellij/spring/boot/run/SpringBootJmxSetup$RemoteSetup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n1#2:154\n*E\n"})
    public static final class RemoteSetup
    extends SpringBootJmxSetup {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private TargetEnvironment myResolvedEnvironment;
        @Nullable
        private TargetEnvironment.TargetPortBinding myJmxPortBinding;

        @Override
        public void setupJmxParameters(@NotNull JavaParameters params, @NotNull TargetEnvironmentRequest targetRequest) throws ExecutionException {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter((Object)targetRequest, (String)"targetRequest");
            boolean bl2 = bl = !(targetRequest instanceof LocalTargetEnvironmentRequest);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            ParametersList vmParametersList = params.getVMParametersList();
            Intrinsics.checkNotNull((Object)vmParametersList);
            this.setupJmxPorts(vmParametersList, targetRequest);
            this.setupJmxHosts(vmParametersList);
            this.setupJmxSecurity(vmParametersList, targetRequest);
        }

        /*
         * WARNING - void declaration
         */
        private final void setupJmxPorts(ParametersList vmParametersList, TargetEnvironmentRequest targetRequest) throws ExecutionException {
            String samePortForAll;
            String jmxRegistryPort = vmParametersList.getPropertyValue(SpringBootJmxSetup.JMX_REGISTRY_PORT);
            String rmiServerPort = vmParametersList.getPropertyValue(SpringBootJmxSetup.JMX_RMI_SERVER_PORT);
            if (jmxRegistryPort != null && rmiServerPort != null && !Intrinsics.areEqual((Object)jmxRegistryPort, (Object)rmiServerPort)) {
                Object[] objectArray = new Object[]{jmxRegistryPort, rmiServerPort};
                throw new ExecutionException(SpringBootRunBundle.message("spring.boot.jmx.setup.for.remote.case.two.ports.should.match", objectArray));
            }
            String string = jmxRegistryPort;
            if (string == null && (string = rmiServerPort) == null) {
                string = samePortForAll = String.valueOf(NetUtils.tryToFindAvailableSocketPort((int)5000));
            }
            if (jmxRegistryPort == null) {
                vmParametersList.addProperty(SpringBootJmxSetup.JMX_REGISTRY_PORT, samePortForAll);
            }
            if (rmiServerPort == null) {
                vmParametersList.addProperty(SpringBootJmxSetup.JMX_RMI_SERVER_PORT, samePortForAll);
            }
            try {
                void it;
                TargetEnvironment.TargetPortBinding targetPortBinding;
                int samePort = Integer.parseInt(samePortForAll);
                TargetEnvironment.TargetPortBinding targetPortBinding2 = targetPortBinding = new TargetEnvironment.TargetPortBinding(Integer.valueOf(samePort), samePort);
                RemoteSetup remoteSetup = this;
                boolean bl = false;
                targetRequest.getTargetPortBindings().add(it);
                remoteSetup.myJmxPortBinding = targetPortBinding;
            }
            catch (NumberFormatException e) {
                Object[] objectArray = new Object[]{jmxRegistryPort};
                throw new ExecutionException(SpringBootRunBundle.message("spring.boot.jmx.setup.cant.parse.jmx.port", objectArray));
            }
        }

        private final void setupJmxSecurity(ParametersList vmParametersList, TargetEnvironmentRequest targetRequest) {
            vmParametersList.addProperty(SpringBootJmxSetup.JMX_REMOTE_AUTH, "false");
            vmParametersList.addProperty(SpringBootJmxSetup.JMX_REMOTE_SSL, "false");
        }

        private final void setupJmxHosts(ParametersList vmParametersList) {
            RemoteSetup.Companion.addPropertyIfNotSetAlready(vmParametersList, SpringBootJmxSetup.JMX_REGISTRY_HOST, SpringBootJmxSetup.ANY_HOST);
            RemoteSetup.Companion.addPropertyIfNotSetAlready(vmParametersList, SpringBootJmxSetup.JMX_RMI_SERVER_HOST, SpringBootJmxSetup.ANY_HOST);
        }

        @Override
        public void handleCreatedEnvironment(@NotNull TargetEnvironment environment) {
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            this.myResolvedEnvironment = environment;
        }

        @Override
        public void setupProcessHandler(@NotNull ProcessHandler processHandler) {
            block2: {
                TargetEnvironment.TargetPortBinding targetPortBinding;
                Object resolvedPortBindings;
                Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
                Object object = this.myResolvedEnvironment;
                if (object == null || (object = object.getTargetPortBindings()) == null) {
                    object = resolvedPortBindings = MapsKt.emptyMap();
                }
                if ((targetPortBinding = this.myJmxPortBinding) == null) break block2;
                TargetEnvironment.TargetPortBinding it = targetPortBinding;
                boolean bl = false;
                ResolvedPortBinding resolvedPortBinding = (ResolvedPortBinding)resolvedPortBindings.get(it);
                if (resolvedPortBinding != null) {
                    ResolvedPortBinding resolvedPortBinding2 = resolvedPortBinding;
                    boolean bl2 = false;
                    processHandler.putUserData(SpringBootApplicationLifecycleManager.JMX_PORT, (Object)ResolvedPortBindingKt.getLocalPort((ResolvedPortBinding)resolvedPortBinding2));
                }
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/spring/boot/run/SpringBootJmxSetup$RemoteSetup$Companion;", "", "<init>", "()V", "addPropertyIfNotSetAlready", "", "Lcom/intellij/execution/configurations/ParametersList;", "propertyName", "", "propertyValue", "intellij.spring.boot.run"})
        public static final class Companion {
            private Companion() {
            }

            private final void addPropertyIfNotSetAlready(ParametersList $this$addPropertyIfNotSetAlready, String propertyName, String propertyValue) {
                String string = $this$addPropertyIfNotSetAlready.getPropertyValue(propertyName);
                if (string == null) {
                    $this$addPropertyIfNotSetAlready.addProperty(propertyName, propertyValue);
                    string = Unit.INSTANCE;
                }
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

