/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.diagram;

import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import com.intellij.spring.boot.run.SpringBootRuntimeResourceContext;
import com.intellij.spring.boot.run.diagram.LiveBeanDiagramCategoryManager;
import com.intellij.spring.boot.run.diagram.LiveBeanWrapper;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveBean;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveResource;
import com.intellij.spring.diagrams.perspectives.SpringDependencyType;
import com.intellij.spring.diagrams.perspectives.SpringDiagramEdge;
import com.intellij.spring.diagrams.perspectives.SpringDiagramNode;
import com.intellij.spring.diagrams.perspectives.beans.SpringElementWrapper;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@VisibleForTesting
public abstract class BaseLiveBeanDiagramDataModel
extends DiagramDataModel<SpringElementWrapper<?>> {
    private final Map<LiveBean, DiagramNode<SpringElementWrapper<?>>> myNodes = new LinkedHashMap();
    private final Set<DiagramEdge<SpringElementWrapper<?>>> myEdges = new LinkedHashSet();

    protected BaseLiveBeanDiagramDataModel(Project project, DiagramProvider<SpringElementWrapper<?>> diagramProvider) {
        super(project, diagramProvider);
    }

    @NotNull
    public Collection<DiagramNode<SpringElementWrapper<?>>> getNodes() {
        Collection<DiagramNode<SpringElementWrapper<?>>> collection = this.myNodes.values();
        if (collection == null) {
            BaseLiveBeanDiagramDataModel.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @NotNull
    public Collection<DiagramEdge<SpringElementWrapper<?>>> getEdges() {
        Set<DiagramEdge<SpringElementWrapper<?>>> set = this.myEdges;
        if (set == null) {
            BaseLiveBeanDiagramDataModel.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public String getNodeName(@NotNull DiagramNode<SpringElementWrapper<?>> n) {
        if (n == null) {
            BaseLiveBeanDiagramDataModel.$$$reportNull$$$0(2);
        }
        String string = ((SpringElementWrapper)n.getIdentifyingElement()).getName();
        if (string == null) {
            BaseLiveBeanDiagramDataModel.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public DiagramNode<SpringElementWrapper<?>> addElement(@Nullable SpringElementWrapper wrapper) {
        Object object;
        if (wrapper == null || !((object = wrapper.getWrapped()) instanceof LiveBean)) {
            return null;
        }
        LiveBean liveBean = (LiveBean)object;
        SpringDiagramNode node = this.myNodes.get(liveBean);
        if (node == null) {
            node = new SpringDiagramNode(wrapper, this.getProvider());
            this.myNodes.put(liveBean, (DiagramNode<SpringElementWrapper<?>>)node);
        }
        return node;
    }

    @NotNull
    public CompletableFuture<Void> refreshDataModelAsync(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            BaseLiveBeanDiagramDataModel.$$$reportNull$$$0(4);
        }
        if (DumbService.isDumb((Project)this.getProject())) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                BaseLiveBeanDiagramDataModel.$$$reportNull$$$0(5);
            }
            return completableFuture;
        }
        this.clearAll();
        boolean showLibraryBeans = this.showLibraryBeans();
        CancellablePromise promise = ReadAction.nonBlocking(() -> {
            LiveBeanDiagramUpdater updater = new LiveBeanDiagramUpdater(this.getRunConfiguration(), this.getProvider(), this.getBeans(), showLibraryBeans);
            updater.updateDataModel();
            return updater;
        }).expireWith((Disposable)this).inSmartMode(this.getProject()).wrapProgress(indicator).coalesceBy(new Object[]{this}).finishOnUiThread(ModalityState.any(), updater -> {
            this.myNodes.putAll(updater.getNodes());
            this.myEdges.addAll(updater.getEdges());
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
        CompletableFuture completableFuture = Promises.asCompletableFuture((Promise)promise.then(updater -> null));
        if (completableFuture == null) {
            BaseLiveBeanDiagramDataModel.$$$reportNull$$$0(6);
        }
        return completableFuture;
    }

    private boolean showLibraryBeans() {
        return Objects.requireNonNull(this.getNodeContentManager()).isCategoryEnabled(LiveBeanDiagramCategoryManager.SHOW_LIBRARY_BEANS);
    }

    public long getModificationCount() {
        return super.getModificationCount() + PsiManager.getInstance((Project)this.getProject()).getModificationTracker().getModificationCount();
    }

    private void clearAll() {
        this.myEdges.clear();
        this.myNodes.clear();
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        BaseLiveBeanDiagramDataModel baseLiveBeanDiagramDataModel = this;
        if (baseLiveBeanDiagramDataModel == null) {
            BaseLiveBeanDiagramDataModel.$$$reportNull$$$0(7);
        }
        return baseLiveBeanDiagramDataModel;
    }

    public void dispose() {
    }

    protected abstract List<LiveBean> getBeans();

    protected abstract SpringBootApplicationRunConfigurationBase getRunConfiguration();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/diagram/BaseLiveBeanDiagramDataModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/diagram/BaseLiveBeanDiagramDataModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshDataModelAsync";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "refreshDataModelAsync";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4 -> new IllegalArgumentException(string);
        };
    }

    private static final class LiveBeanDiagramUpdater {
        private final SpringBootApplicationRunConfigurationBase myRunConfiguration;
        private final DiagramProvider<SpringElementWrapper<?>> myProvider;
        private final List<LiveBean> myBeans;
        private final boolean myShowLibraryBeans;
        private final Map<LiveBean, DiagramNode<SpringElementWrapper<?>>> myNodes = new LinkedHashMap();
        private final Set<DiagramEdge<SpringElementWrapper<?>>> myEdges = new LinkedHashSet();

        LiveBeanDiagramUpdater(SpringBootApplicationRunConfigurationBase runConfiguration, DiagramProvider<SpringElementWrapper<?>> provider, List<LiveBean> beans, boolean showLibraryBeans) {
            this.myRunConfiguration = runConfiguration;
            this.myProvider = provider;
            this.myBeans = beans;
            this.myShowLibraryBeans = showLibraryBeans;
        }

        Map<LiveBean, DiagramNode<SpringElementWrapper<?>>> getNodes() {
            return this.myNodes;
        }

        Set<DiagramEdge<SpringElementWrapper<?>>> getEdges() {
            return this.myEdges;
        }

        void updateDataModel() {
            SpringBootRuntimeResourceContext resourceContext = this.myRunConfiguration.getResourceContext();
            HashMap<LiveResource, Boolean> resources = new HashMap<LiveResource, Boolean>();
            HashMap<PsiClass, Boolean> autoConfigurations = new HashMap<PsiClass, Boolean>();
            for (LiveBean liveBean : this.myBeans) {
                if (!this.myShowLibraryBeans && this.isInLibrary(liveBean, resources, autoConfigurations, resourceContext)) continue;
                DiagramNode<SpringElementWrapper<?>> node = this.getOrCreateElement(liveBean);
                for (LiveBean dependency : liveBean.getDependencies()) {
                    if (!this.myShowLibraryBeans && this.isInLibrary(dependency, resources, autoConfigurations, resourceContext)) continue;
                    DiagramNode<SpringElementWrapper<?>> targetNode = this.getOrCreateElement(dependency);
                    this.addEdge(node, targetNode);
                }
                for (LiveBean injectedInto : liveBean.getInjectedInto()) {
                    if (!this.myShowLibraryBeans && this.isInLibrary(injectedInto, resources, autoConfigurations, resourceContext)) continue;
                    DiagramNode<SpringElementWrapper<?>> sourceNode = this.getOrCreateElement(injectedInto);
                    this.addEdge(sourceNode, node);
                }
            }
        }

        @NotNull
        private DiagramNode<SpringElementWrapper<?>> getOrCreateElement(LiveBean liveBean) {
            SpringDiagramNode node = this.myNodes.get(liveBean);
            if (node == null) {
                node = new SpringDiagramNode((SpringElementWrapper)new LiveBeanWrapper(liveBean, this.myRunConfiguration), this.myProvider);
                this.myNodes.put(liveBean, (DiagramNode<SpringElementWrapper<?>>)node);
            }
            SpringDiagramNode springDiagramNode = node;
            if (springDiagramNode == null) {
                LiveBeanDiagramUpdater.$$$reportNull$$$0(0);
            }
            return springDiagramNode;
        }

        private void addEdge(@NotNull DiagramNode<SpringElementWrapper<?>> source, @NotNull DiagramNode<SpringElementWrapper<?>> target) {
            if (source == null) {
                LiveBeanDiagramUpdater.$$$reportNull$$$0(1);
            }
            if (target == null) {
                LiveBeanDiagramUpdater.$$$reportNull$$$0(2);
            }
            this.myEdges.add((DiagramEdge<SpringElementWrapper<?>>)new SpringDiagramEdge(source, target, SpringDependencyType.UNKNOWN));
        }

        private boolean isInLibrary(LiveBean liveBean, Map<LiveResource, Boolean> resources, Map<PsiClass, Boolean> autoConfigurations, SpringBootRuntimeResourceContext resourceContext) {
            LiveResource liveResource = liveBean.getResource();
            if (liveResource == null) {
                return false;
            }
            if (liveResource.hasDescription()) {
                Boolean isInLibrary = resources.get(liveResource);
                if (isInLibrary == null) {
                    isInLibrary = this.isInLibrary(liveResource.findResourceElement(resourceContext));
                    resources.put(liveResource, isInLibrary);
                }
                return isInLibrary;
            }
            PsiClass beanClass = liveBean.findBeanClass(this.myRunConfiguration.getProject(), resourceContext.getSearchScope());
            if (beanClass == null) {
                return false;
            }
            Boolean isInLibrary = autoConfigurations.get(beanClass);
            if (isInLibrary == null) {
                isInLibrary = this.isInLibrary((PsiElement)beanClass);
                autoConfigurations.put(beanClass, isInLibrary);
            }
            return isInLibrary;
        }

        private boolean isInLibrary(PsiElement psiElement) {
            ProjectFileIndex fileIndex;
            VirtualFile virtualFile;
            return psiElement != null && psiElement.isValid() && psiElement.getContainingFile() != null && (virtualFile = psiElement.getContainingFile().getVirtualFile()) != null && (fileIndex = ProjectRootManager.getInstance((Project)this.myRunConfiguration.getProject()).getFileIndex()).isInLibrary(virtualFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/boot/run/diagram/BaseLiveBeanDiagramDataModel$LiveBeanDiagramUpdater";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreateElement";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/boot/run/diagram/BaseLiveBeanDiagramDataModel$LiveBeanDiagramUpdater";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addEdge";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

