/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.diagram;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.actions.DiagramAddElementAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.navigation.NavigationRequest;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.spring.boot.run.diagram.LiveBeanWrapper;
import com.intellij.spring.boot.run.statistics.SpringBootRunUsageTriggerCollector;
import com.intellij.spring.diagrams.perspectives.SpringDiagramExtras;
import com.intellij.spring.diagrams.perspectives.beans.SpringElementWrapper;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.PsiElementPointer;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
public final class LiveBeanDiagramExtras
extends SpringDiagramExtras {
    @NonNls
    private static final String HELP_ID = "spring.runtime.beans";

    public void uiDataSnapshot(@NotNull DataSink sink, @NotNull List<DiagramNode<SpringElementWrapper<?>>> nodes, @NotNull DiagramBuilder builder) {
        if (sink == null) {
            LiveBeanDiagramExtras.$$$reportNull$$$0(0);
        }
        if (nodes == null) {
            LiveBeanDiagramExtras.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            LiveBeanDiagramExtras.$$$reportNull$$$0(2);
        }
        super.uiDataSnapshot(sink, nodes, builder);
        sink.set(PlatformCoreDataKeys.HELP_ID, (Object)HELP_ID);
        DiagramNode single = (DiagramNode)ContainerUtil.getOnlyItem(nodes);
        if (single == null) {
            return;
        }
        sink.lazy(CommonDataKeys.PSI_ELEMENT, () -> {
            Object patt1847$temp = single.getIdentifyingElement();
            if (!(patt1847$temp instanceof LiveBeanWrapper)) {
                return null;
            }
            LiveBeanWrapper wrapper = (LiveBeanWrapper)((Object)((Object)patt1847$temp));
            PsiElementPointer pointer = wrapper.getPointer();
            return pointer.getPsiElement();
        });
        sink.lazy(CommonDataKeys.NAVIGATABLE, () -> {
            Navigatable navigatable2;
            PsiElement psi;
            block5: {
                block4: {
                    Object patt2092$temp = single.getIdentifyingElement();
                    if (!(patt2092$temp instanceof LiveBeanWrapper)) {
                        return null;
                    }
                    LiveBeanWrapper wrapper = (LiveBeanWrapper)((Object)((Object)patt2092$temp));
                    psi = wrapper.getPointer().getPsiElement();
                    if (!(psi instanceof Navigatable)) break block4;
                    navigatable2 = (Navigatable)psi;
                    if (psi.isValid()) break block5;
                }
                return null;
            }
            return new Navigatable(){

                public void navigate(boolean requestFocus) {
                    LiveBeanDiagramExtras.triggerUsage(psi.getProject());
                    navigatable2.navigate(requestFocus);
                }

                public boolean canNavigate() {
                    return navigatable2.canNavigate();
                }

                public boolean canNavigateToSource() {
                    return navigatable2.canNavigateToSource();
                }
            };
        });
    }

    public DiagramAddElementAction getAddElementHandler() {
        return null;
    }

    public void doEdit(DiagramNode<SpringElementWrapper<?>> node, DiagramPresentationModel presentationModel) {
        SpringElementWrapper wrapper = (SpringElementWrapper)node.getIdentifyingElement();
        if (!(wrapper instanceof LiveBeanWrapper)) {
            return;
        }
        final LiveBeanWrapper liveBeanWrapper = (LiveBeanWrapper)wrapper;
        Navigatable navigatable2 = new Navigatable(){

            @Nullable
            public NavigationRequest navigationRequest() {
                Navigatable navigatable2;
                PsiElement psiElement;
                block5: {
                    block4: {
                        psiElement = liveBeanWrapper.getPointer().getPsiElement();
                        if (!(psiElement instanceof Navigatable)) break block4;
                        navigatable2 = (Navigatable)psiElement;
                        if (psiElement.isValid()) break block5;
                    }
                    return null;
                }
                if (navigatable2.canNavigate()) {
                    LiveBeanDiagramExtras.triggerUsage(psiElement.getProject());
                    return navigatable2.navigationRequest();
                }
                return null;
            }
        };
        DataContext dataContext = SimpleDataContext.builder().add(CommonDataKeys.NAVIGATABLE, (Object)navigatable2).add(CommonDataKeys.PROJECT, (Object)liveBeanWrapper.getProject()).build();
        OpenSourceUtil.openSourcesFrom((DataContext)dataContext, (boolean)true);
    }

    private static void triggerUsage(@NotNull Project project) {
        if (project == null) {
            LiveBeanDiagramExtras.$$$reportNull$$$0(3);
        }
        SpringBootRunUsageTriggerCollector.logEditRuntimeBean(project, "unknown");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/run/diagram/LiveBeanDiagramExtras";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "uiDataSnapshot";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerUsage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

