/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.gradle;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.ext.ExtModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.intellij.buildsystem.model.unified.UnifiedCoordinates;
import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.intellij.externalSystem.DependencyModifierService;
import com.intellij.microservices.jvm.config.RelaxedNames;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.gradle.dsl.SpringBootDependencyManagementModel;
import com.intellij.spring.boot.run.gradle.dsl.SpringBootImportsModel;
import com.intellij.spring.boot.run.starters.SpringBootStarterManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public class SpringBootGradleStarterManager
implements SpringBootStarterManager {
    public boolean supports(@NotNull Module module) {
        if (module == null) {
            SpringBootGradleStarterManager.$$$reportNull$$$0(0);
        }
        return GradleConstants.SYSTEM_ID.getId().equals(ExternalSystemModulePropertyManager.getInstance((Module)module).getExternalSystemId());
    }

    public void addDependency(@NotNull Module module, @NotNull UnifiedDependency dependency) {
        if (module == null) {
            SpringBootGradleStarterManager.$$$reportNull$$$0(1);
        }
        if (dependency == null) {
            SpringBootGradleStarterManager.$$$reportNull$$$0(2);
        }
        this.addDependencies(module, List.of(dependency));
    }

    public void addDependencies(@NotNull Module module, @NotNull Collection<UnifiedDependency> dependencies) {
        if (module == null) {
            SpringBootGradleStarterManager.$$$reportNull$$$0(3);
        }
        if (dependencies == null) {
            SpringBootGradleStarterManager.$$$reportNull$$$0(4);
        }
        DependencyModifierService modifierService = DependencyModifierService.getInstance((Project)module.getProject());
        for (UnifiedDependency dependency : dependencies) {
            modifierService.addDependency(module, SpringBootGradleStarterManager.adjustScope(dependency));
        }
    }

    @Override
    public void addManagedDependencies(@NotNull Module module, @NotNull Collection<SpringBootStarterManager.ManagedDependency> dependencies) {
        if (module == null) {
            SpringBootGradleStarterManager.$$$reportNull$$$0(5);
        }
        if (dependencies == null) {
            SpringBootGradleStarterManager.$$$reportNull$$$0(6);
        }
        if (dependencies.isEmpty()) {
            return;
        }
        GradleBuildModel model = ProjectBuildModel.get((Project)module.getProject()).getModuleBuildModel(module);
        if (model == null) {
            return;
        }
        for (SpringBootStarterManager.ManagedDependency dependency : dependencies) {
            SpringBootGradleStarterManager.addManagedDependency(dependency, model);
        }
        SpringBootGradleStarterManager.applyChanges(module, model, SpringBootRunBundle.message("spring.boot.generate.starters.add.managed.dependency.command", new Object[0]));
    }

    public boolean isBuildFile(@NotNull Module module, @NotNull PsiFile psiFile) {
        if (module == null) {
            SpringBootGradleStarterManager.$$$reportNull$$$0(7);
        }
        if (psiFile == null) {
            SpringBootGradleStarterManager.$$$reportNull$$$0(8);
        }
        ExternalSystemModulePropertyManager propertyManager = ExternalSystemModulePropertyManager.getInstance((Module)module);
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile parent = virtualFile.getParent();
        if (parent == null) {
            return false;
        }
        if (!parent.getPath().equals(propertyManager.getLinkedProjectPath())) {
            return false;
        }
        String fileName = virtualFile.getName();
        return "build.gradle".equals(fileName) || "build.gradle.kts".equals(fileName);
    }

    @NotNull
    public Module adjustModule(@NotNull Module module) {
        Module mainModule;
        if (module == null) {
            SpringBootGradleStarterManager.$$$reportNull$$$0(9);
        }
        Module module2 = (mainModule = SpringBootGradleStarterManager.findRelatedModule(module, "main")) != null ? mainModule : module;
        if (module2 == null) {
            SpringBootGradleStarterManager.$$$reportNull$$$0(10);
        }
        return module2;
    }

    @NotNull
    public List<Module> getRelatedModules(@NotNull Module module) {
        Module testModule;
        if (module == null) {
            SpringBootGradleStarterManager.$$$reportNull$$$0(11);
        }
        List<Object> list = (testModule = SpringBootGradleStarterManager.findRelatedModule(module, "test")) != null ? List.of(testModule) : Collections.emptyList();
        if (list == null) {
            SpringBootGradleStarterManager.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    private static Module findRelatedModule(@NotNull Module module, @NotNull String qualifier) {
        DataNode dataNode;
        if (module == null) {
            SpringBootGradleStarterManager.$$$reportNull$$$0(13);
        }
        if (qualifier == null) {
            SpringBootGradleStarterManager.$$$reportNull$$$0(14);
        }
        if ((dataNode = GradleUtil.findGradleModuleData((Module)module)) == null) {
            return null;
        }
        String mainSourceSetModuleId = ((ModuleData)dataNode.getData()).getId() + ":" + qualifier;
        return (Module)ContainerUtil.find((Object[])ModuleManager.getInstance((Project)module.getProject()).getModules(), candidate -> mainSourceSetModuleId.equals(ExternalSystemApiUtil.getExternalProjectId((Module)candidate)));
    }

    @Override
    @NotNull
    public Promise<?> refresh(@NotNull Module module) {
        if (module == null) {
            SpringBootGradleStarterManager.$$$reportNull$$$0(15);
        }
        ExternalSystemModulePropertyManager propertyManager = ExternalSystemModulePropertyManager.getInstance((Module)module);
        Promise<Void> promise = SpringBootGradleStarterManager.refreshProject(module.getProject(), propertyManager.getLinkedProjectPath());
        if (promise == null) {
            SpringBootGradleStarterManager.$$$reportNull$$$0(16);
        }
        return promise;
    }

    private static UnifiedDependency adjustScope(UnifiedDependency dependency) {
        UnifiedCoordinates coordinates = dependency.getCoordinates();
        String gradleScope = dependency.getScope();
        gradleScope = "spring-boot-devtools".equals(coordinates.getArtifactId()) && "org.springframework.boot".equals(coordinates.getGroupId()) ? "developmentOnly" : ("test".equals(gradleScope) ? "testImplementation" : ("runtime".equals(gradleScope) ? "runtimeOnly" : "implementation"));
        return new UnifiedDependency(coordinates, gradleScope);
    }

    private static Promise<Void> refreshProject(Project project, String path) {
        final AsyncPromise result = new AsyncPromise();
        final ImportSpecBuilder importSpecBuilder = new ImportSpecBuilder(project, GradleConstants.SYSTEM_ID);
        importSpecBuilder.callback(new ExternalProjectRefreshCallback(){
            private final ImportSpecBuilder.DefaultProjectRefreshCallback myDefaultCallback;
            {
                this.myDefaultCallback = new ImportSpecBuilder.DefaultProjectRefreshCallback(importSpecBuilder.build());
            }

            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                this.myDefaultCallback.onSuccess(externalProject);
                ApplicationManager.getApplication().invokeLater(() -> result.setResult(null));
            }

            public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.myDefaultCallback.onFailure(errorMessage, errorDetails);
                result.setError(errorMessage);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/spring/boot/run/gradle/SpringBootGradleStarterManager$1", "onFailure"));
            }
        });
        ExternalSystemUtil.refreshProject((String)path, (ImportSpecBuilder)importSpecBuilder);
        return result;
    }

    private static void applyChanges(Module module, GradleBuildModel model, @NlsContexts.Command String commandName) {
        WriteCommandAction.writeCommandAction((Project)module.getProject(), (PsiFile[])new PsiFile[]{model.getPsiFile()}).withName(commandName).run(() -> model.applyChanges());
    }

    private static String getVersionPropertyName(String propertyName) {
        String versionSuffix = ".version";
        if (StringUtil.endsWith((CharSequence)propertyName, (CharSequence)versionSuffix)) {
            propertyName = ((String)propertyName).substring(0, ((String)propertyName).length() - versionSuffix.length()) + "-version";
        }
        return RelaxedNames.dashedPropertyNameToCamelCase((String)propertyName);
    }

    private static void addManagedDependency(SpringBootStarterManager.ManagedDependency dependency, GradleBuildModel model) {
        UnifiedCoordinates coordinates = dependency.dependency.getCoordinates();
        SpringBootDependencyManagementModel managementModel = (SpringBootDependencyManagementModel)model.getModel(SpringBootDependencyManagementModel.class);
        SpringBootImportsModel imports = managementModel.imports();
        if (imports.findDependency(coordinates) != null) {
            return;
        }
        String propertyName = SpringBootGradleStarterManager.getVersionPropertyName(dependency.getPropertyName());
        GradlePropertyModel propertyModel = SpringBootGradleStarterManager.addVersionProperty(model, propertyName, coordinates.getVersion());
        imports.addDependency(coordinates, propertyModel);
    }

    private static GradlePropertyModel addVersionProperty(GradleBuildModel model, String propertyName, String version) {
        if (version == null) {
            return null;
        }
        ExtModel ext = model.ext();
        GradlePropertyModel property = ext.findProperty(propertyName);
        if (property.getValueType() == GradlePropertyModel.ValueType.NONE) {
            property.setValue((Object)("'" + version + "'"));
        }
        return property;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 12, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 10: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/gradle/SpringBootGradleStarterManager";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/gradle/SpringBootGradleStarterManager";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustModule";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedModules";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "refresh";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "supports";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addDependency";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addDependencies";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addManagedDependencies";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isBuildFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "adjustModule";
                break;
            }
            case 10: 
            case 12: 
            case 16: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedModules";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findRelatedModule";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 12, 16 -> new IllegalStateException(string);
        };
    }
}

