/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.beans.model.impl;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.reference.SoftReference;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.SpringBootRuntimeResourceContext;
import com.intellij.spring.boot.run.lifecycle.RuntimeResource;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveBean;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveContext;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveResource;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import icons.JavaUltimateIcons;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LiveResourceImpl
implements LiveResource {
    @NlsSafe
    static final String AUTO_CONFIGURATION_RESOURCE = "null";
    @NotNull
    private final String myDescription;
    @NotNull
    private final LiveContext myContext;
    @NotNull
    private final List<LiveBean> myBeans;
    private volatile String myDisplayName;
    private volatile WeakReference<Navigatable> myNavigatableRef;

    LiveResourceImpl(@NotNull String description, @NotNull LiveContext context) {
        if (description == null) {
            LiveResourceImpl.$$$reportNull$$$0(0);
        }
        if (context == null) {
            LiveResourceImpl.$$$reportNull$$$0(1);
        }
        this.myBeans = new SmartList();
        this.myDescription = description;
        this.myContext = context;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            LiveResourceImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public LiveContext getContext() {
        LiveContext liveContext = this.myContext;
        if (liveContext == null) {
            LiveResourceImpl.$$$reportNull$$$0(3);
        }
        return liveContext;
    }

    @Override
    @NotNull
    public List<LiveBean> getBeans() {
        SmartList beans = new SmartList();
        beans.addAll(this.myBeans);
        SmartList smartList = beans;
        if (smartList == null) {
            LiveResourceImpl.$$$reportNull$$$0(4);
        }
        return smartList;
    }

    @Override
    public boolean hasDescription() {
        return !this.myDescription.isEmpty() && !this.myDescription.equalsIgnoreCase(AUTO_CONFIGURATION_RESOURCE);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        int nameStart;
        String displayName = this.myDisplayName;
        if (displayName != null) {
            String string = displayName;
            if (string == null) {
                LiveResourceImpl.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (!this.hasDescription()) {
            String string = this.myDisplayName = SpringBootRunBundle.message("spring.boot.application.endpoints.bean.auto.configuration", new Object[0]);
            if (string == null) {
                LiveResourceImpl.$$$reportNull$$$0(6);
            }
            return string;
        }
        displayName = this.myDescription;
        int indexStart = displayName.lastIndexOf("/");
        int indexEnd = displayName.lastIndexOf("]");
        if (indexEnd > -1 && indexStart < 0 && (nameStart = displayName.lastIndexOf("[")) >= 0 && displayName.indexOf(".", nameStart) > -1) {
            indexStart = nameStart;
        }
        if (indexStart > -1 && indexEnd > -1 && indexStart < indexEnd) {
            displayName = displayName.substring(indexStart + 1, indexEnd);
        }
        if (RuntimeResource.isXmlResource(displayName = StringUtil.trimStart((String)displayName, (String)"file:"))) {
            String string = this.myDisplayName = displayName;
            if (string == null) {
                LiveResourceImpl.$$$reportNull$$$0(7);
            }
            return string;
        }
        int index = (displayName = StringUtil.trimEnd((String)displayName, (String)".class")).lastIndexOf(".");
        if (index > -1) {
            displayName = displayName.substring(index + 1);
        }
        String[] names = displayName.split("\\$");
        StringBuilder sb = new StringBuilder();
        sb.append(names[names.length - 1]);
        for (int i = names.length - 2; i >= 0; --i) {
            sb.append(" in ");
            sb.append(names[i]);
        }
        String string = this.myDisplayName = sb.toString();
        if (string == null) {
            LiveResourceImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @Nullable
    public Navigatable findResourceNavigatable(@NotNull SpringBootRuntimeResourceContext resourceContext) {
        if (resourceContext == null) {
            LiveResourceImpl.$$$reportNull$$$0(9);
        }
        if (!this.hasDescription()) {
            return null;
        }
        Navigatable navigatable2 = this.getCachedValue();
        if (navigatable2 != null) {
            return navigatable2;
        }
        if (LiveResourceImpl.isClassNameResource(this.myDescription)) {
            navigatable2 = RuntimeResource.findClass(this.myDescription, resourceContext.getProject(), resourceContext.getSearchScope());
        } else {
            String path = this.getResourcePath();
            navigatable2 = new RuntimeResource(this.myDescription, path).findNavigatable(resourceContext);
        }
        this.myNavigatableRef = new WeakReference<Navigatable>(navigatable2);
        return navigatable2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private Navigatable getCachedValue() {
        Navigatable navigatable2 = (Navigatable)SoftReference.dereference(this.myNavigatableRef);
        if (navigatable2 == null) return null;
        if (!(navigatable2 instanceof PsiElement)) return navigatable2;
        if (!((PsiElement)navigatable2).isValid()) return null;
        if (navigatable2 instanceof PsiClass) {
            if (!this.matchesClass((PsiClass)navigatable2, false)) return null;
            return navigatable2;
        }
        if (!(navigatable2 instanceof XmlFile)) return navigatable2;
        if (!this.matchesXmlConfig((XmlFile)navigatable2)) return null;
        return navigatable2;
    }

    @Override
    @Nullable
    public PsiElement findResourceElement(@NotNull SpringBootRuntimeResourceContext resourceContext) {
        Navigatable navigatable2;
        if (resourceContext == null) {
            LiveResourceImpl.$$$reportNull$$$0(10);
        }
        return (navigatable2 = this.findResourceNavigatable(resourceContext)) instanceof PsiElement ? (PsiElement)navigatable2 : null;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        if (!this.hasDescription()) {
            return SpringApiIcons.SpringJavaConfig;
        }
        if (LiveResourceImpl.isClassNameResource(this.myDescription)) {
            return AllIcons.Nodes.Class;
        }
        String path = this.getResourcePath();
        if (this.myDescription.startsWith("class path resource") || this.myDescription.startsWith("file")) {
            LiveResourceImpl.getFileIcon(path);
        } else if (this.myDescription.startsWith("URL")) {
            if (path.startsWith("file:")) {
                return LiveResourceImpl.getFileIcon(path.substring("file:".length()));
            }
            return JavaUltimateIcons.Javaee.Web_xml;
        }
        return null;
    }

    private static Icon getFileIcon(String path) {
        if (RuntimeResource.isClassResource(path)) {
            return AllIcons.Nodes.Class;
        }
        if (RuntimeResource.isXmlResource(path)) {
            return SpringApiIcons.SpringConfig;
        }
        return null;
    }

    @Override
    @NotNull
    public String getResourcePath() {
        String resource = this.myDescription;
        int start = resource.indexOf("[");
        int end = resource.indexOf("]");
        if (start > -1 && end > -1 && start < end) {
            resource = resource.substring(start + 1, end);
        }
        String string = resource;
        if (string == null) {
            LiveResourceImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    public boolean matchesClass(@NotNull PsiClass psiClass, boolean strict) {
        if (psiClass == null) {
            LiveResourceImpl.$$$reportNull$$$0(12);
        }
        if (!this.hasDescription()) {
            return false;
        }
        Object className = null;
        if (LiveResourceImpl.isClassNameResource(this.myDescription)) {
            className = this.myDescription;
        } else {
            Object path = this.getResourcePath();
            if (!RuntimeResource.isClassResource((String)path) || this.myDescription.startsWith("URL")) {
                return false;
            }
            if (this.myDescription.startsWith("class path resource")) {
                path = StringUtil.trimEnd((String)path, (String)".class", (boolean)true);
                className = path = ((String)path).replaceAll("[\\\\/$]", ".");
            } else if (this.myDescription.startsWith("file")) {
                VirtualFile resourceFile;
                String innerClassesSuffix = null;
                int index = ((String)path).indexOf(36);
                if (index >= 0) {
                    innerClassesSuffix = StringUtil.trimEnd((String)((String)path).substring(index + 1), (String)".class", (boolean)true);
                    path = ((String)path).substring(0, index) + ((String)path).substring(((String)path).length() - ".class".length());
                }
                if ((resourceFile = VfsUtil.findFileByIoFile((File)new File((String)path), (boolean)false)) == null || !resourceFile.isValid()) {
                    return false;
                }
                PsiFile psiFile = psiClass.getManager().findFile(resourceFile);
                if (psiFile instanceof PsiClassOwner) {
                    className = ((PsiClassOwner)psiFile).getPackageName() + "." + FileUtilRt.getNameWithoutExtension((String)psiFile.getName());
                }
                if (className != null && innerClassesSuffix != null) {
                    className = (String)className + "." + StringUtil.replace((String)innerClassesSuffix, (String)"$", (String)".");
                }
            }
        }
        if (className == null) {
            return false;
        }
        if (((String)className).equals(psiClass.getQualifiedName())) {
            return true;
        }
        if (strict) {
            return false;
        }
        PsiClass resourceClass = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass((String)className, psiClass.getResolveScope());
        return InheritanceUtil.isInheritorOrSelf((PsiClass)resourceClass, (PsiClass)psiClass, (boolean)true);
    }

    @Override
    public boolean matchesXmlConfig(@NotNull XmlFile xmlFile) {
        VirtualFile elementFile;
        if (xmlFile == null) {
            LiveResourceImpl.$$$reportNull$$$0(13);
        }
        if (!this.hasDescription()) {
            return false;
        }
        if (LiveResourceImpl.isClassNameResource(this.myDescription)) {
            return false;
        }
        String path = this.getResourcePath();
        if (RuntimeResource.isClassResource(path)) {
            return false;
        }
        boolean urlFileResource = false;
        if (this.myDescription.startsWith("URL")) {
            if (path.startsWith("file:")) {
                path = path.substring("file:".length());
                urlFileResource = true;
            } else {
                return false;
            }
        }
        if ((elementFile = xmlFile.getOriginalFile().getVirtualFile()) == null) {
            return false;
        }
        if (urlFileResource || this.myDescription.startsWith("file")) {
            VirtualFile resourceFile = VfsUtil.findFileByIoFile((File)new File(path), (boolean)false);
            if (resourceFile == null || !resourceFile.isValid()) {
                return false;
            }
            return resourceFile.equals(elementFile);
        }
        if (this.myDescription.startsWith("class path resource")) {
            String elementPath = elementFile.getPath();
            return PathUtil.toSystemIndependentName((String)elementPath).endsWith(PathUtil.toSystemIndependentName((String)path));
        }
        return false;
    }

    void addBean(@NotNull LiveBean bean) {
        if (bean == null) {
            LiveResourceImpl.$$$reportNull$$$0(14);
        }
        this.myBeans.add(bean);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LiveResourceImpl) {
            LiveResourceImpl liveResource = (LiveResourceImpl)obj;
            return this.myDescription.equals(liveResource.myDescription) && this.myContext.equals(liveResource.myContext);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.myDescription.hashCode();
        result = 31 * result + this.myContext.hashCode();
        return result;
    }

    public String toString() {
        return this.myDescription;
    }

    static boolean isClassNameResource(String resourceDescription) {
        return resourceDescription.indexOf(91) < 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/beans/model/impl/LiveResourceImpl";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceContext";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/beans/model/impl/LiveResourceImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeans";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourcePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findResourceNavigatable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findResourceElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "matchesClass";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "matchesXmlConfig";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addBean";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 11 -> new IllegalStateException(string);
        };
    }
}

