/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.health.tab;

import com.intellij.DynamicBundle;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.project.Project;
import com.intellij.spring.boot.run.lifecycle.health.tab.HealthEndpointTabSettings;
import com.intellij.spring.boot.run.lifecycle.tabs.SpringBootEndpointsTabSettings;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.jetbrains.annotations.NotNull;

class HealthEndpointTabConfigurableUi
implements ConfigurableUi<HealthEndpointTabSettings> {
    private static final long MIN_DELAY = 1L;
    private static final long MAX_DELAY = TimeUnit.MINUTES.toSeconds(30L);
    private final Project myProject;
    private JPanel myRootPanel;
    private JBCheckBox myHealthCheckEnabled;
    private JSpinner myHealthCheckDelay;

    HealthEndpointTabConfigurableUi(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myHealthCheckEnabled.addActionListener(e -> this.myHealthCheckDelay.setEnabled(this.myHealthCheckEnabled.isSelected()));
    }

    public void reset(@NotNull HealthEndpointTabSettings settings) {
        if (settings == null) {
            HealthEndpointTabConfigurableUi.$$$reportNull$$$0(0);
        }
        this.myHealthCheckEnabled.setSelected(settings.isCheckHealth());
        long seconds = TimeUnit.MILLISECONDS.toSeconds(settings.getHealthCheckDelay());
        if (seconds > MAX_DELAY) {
            seconds = MAX_DELAY;
        } else if (seconds < 1L) {
            seconds = 1L;
        }
        this.myHealthCheckDelay.setValue(seconds);
        this.myHealthCheckDelay.setEnabled(settings.isCheckHealth());
    }

    public boolean isModified(@NotNull HealthEndpointTabSettings settings) {
        if (settings == null) {
            HealthEndpointTabConfigurableUi.$$$reportNull$$$0(1);
        }
        return this.myHealthCheckEnabled.isSelected() != settings.isCheckHealth() || this.getHealthCheckDelay() != settings.getHealthCheckDelay();
    }

    public void apply(@NotNull HealthEndpointTabSettings settings) {
        if (settings == null) {
            HealthEndpointTabConfigurableUi.$$$reportNull$$$0(2);
        }
        boolean isModified = this.isModified(settings);
        settings.setCheckHealth(this.myHealthCheckEnabled.isSelected());
        settings.setHealthCheckDelay(this.getHealthCheckDelay());
        if (isModified) {
            SpringBootEndpointsTabSettings endpointsTabSettings = SpringBootEndpointsTabSettings.getInstance(this.myProject);
            endpointsTabSettings.fireSettingsChanged("HEALTH_CHECK");
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            HealthEndpointTabConfigurableUi.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.myHealthCheckDelay = new JSpinner(new SpinnerNumberModel((Number)1L, Long.valueOf(1L), Long.valueOf(MAX_DELAY), (Number)1L));
    }

    private long getHealthCheckDelay() {
        return TimeUnit.SECONDS.toMillis(((SpinnerNumberModel)this.myHealthCheckDelay.getModel()).getNumber().longValue());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 4, 0, 2, 1, 6, null, null, null));
        this.myHealthCheckEnabled = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/SpringBootRunBundle", HealthEndpointTabConfigurableUi.class).getString("spring.boot.application.endpoints.health.check"));
        jBCheckBox.setToolTipText(DynamicBundle.getBundle((String)"messages/SpringBootRunBundle", HealthEndpointTabConfigurableUi.class).getString("spring.boot.application.endpoints.health.check.tooltip"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JSpinner jSpinner = this.myHealthCheckDelay;
        jPanel.add((Component)jSpinner, new GridConstraints(0, 1, 1, 1, 8, 0, 6, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/SpringBootRunBundle", HealthEndpointTabConfigurableUi.class).getString("spring.boot.application.endpoints.health.check.unit"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/lifecycle/health/tab/HealthEndpointTabConfigurableUi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/health/tab/HealthEndpointTabConfigurableUi";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

