/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.maven;

import com.intellij.buildsystem.model.unified.UnifiedCoordinates;
import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.intellij.externalSystem.DependencyModifierService;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.boot.run.SpringBootRunBundle;
import com.intellij.spring.boot.run.starters.SpringBootStarterManager;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomProperties;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class SpringBootMavenStarterManager
implements SpringBootStarterManager {
    public boolean supports(@NotNull Module module) {
        if (module == null) {
            SpringBootMavenStarterManager.$$$reportNull$$$0(0);
        }
        return MavenProjectsManager.getInstance((Project)module.getProject()).isMavenizedModule(module);
    }

    public void addDependency(@NotNull Module module, @NotNull UnifiedDependency dependency) {
        if (module == null) {
            SpringBootMavenStarterManager.$$$reportNull$$$0(1);
        }
        if (dependency == null) {
            SpringBootMavenStarterManager.$$$reportNull$$$0(2);
        }
        this.addDependencies(module, List.of(dependency));
    }

    public void addDependencies(@NotNull Module module, @NotNull Collection<UnifiedDependency> dependencies) {
        if (module == null) {
            SpringBootMavenStarterManager.$$$reportNull$$$0(3);
        }
        if (dependencies == null) {
            SpringBootMavenStarterManager.$$$reportNull$$$0(4);
        }
        DependencyModifierService modifierService = DependencyModifierService.getInstance((Project)module.getProject());
        for (UnifiedDependency dependency : dependencies) {
            modifierService.addDependency(module, SpringBootMavenStarterManager.adjustScope(dependency));
        }
    }

    @Override
    public void addManagedDependencies(@NotNull Module module, @NotNull Collection<SpringBootStarterManager.ManagedDependency> dependencies) {
        if (module == null) {
            SpringBootMavenStarterManager.$$$reportNull$$$0(5);
        }
        if (dependencies == null) {
            SpringBootMavenStarterManager.$$$reportNull$$$0(6);
        }
        if (dependencies.isEmpty()) {
            return;
        }
        Pair modelFile = (Pair)ReadAction.compute(() -> {
            MavenDomProjectModel model = SpringBootMavenStarterManager.getProjectModel(module);
            if (model == null) {
                return null;
            }
            return Pair.create((Object)model, (Object)DomUtil.getFile((DomElement)model));
        });
        if (modelFile == null) {
            return;
        }
        MavenDomProjectModel model = (MavenDomProjectModel)modelFile.first;
        XmlFile file = (XmlFile)modelFile.second;
        WriteCommandAction.writeCommandAction((Project)module.getProject(), (PsiFile[])new PsiFile[]{file}).withName(SpringBootRunBundle.message("spring.boot.generate.starters.add.managed.dependency.command", new Object[0])).run(() -> {
            for (SpringBootStarterManager.ManagedDependency dependency : dependencies) {
                SpringBootMavenStarterManager.addManagedDependency(dependency, model);
            }
            SpringBootMavenStarterManager.saveFile((PsiFile)file);
        });
    }

    public boolean isBuildFile(@NotNull Module module, @NotNull PsiFile psiFile) {
        if (module == null) {
            SpringBootMavenStarterManager.$$$reportNull$$$0(7);
        }
        if (psiFile == null) {
            SpringBootMavenStarterManager.$$$reportNull$$$0(8);
        }
        return MavenUtil.isPomFile((Project)module.getProject(), (VirtualFile)psiFile.getVirtualFile());
    }

    @NotNull
    public Module adjustModule(@NotNull Module module) {
        if (module == null) {
            SpringBootMavenStarterManager.$$$reportNull$$$0(9);
        }
        Module module2 = module;
        if (module2 == null) {
            SpringBootMavenStarterManager.$$$reportNull$$$0(10);
        }
        return module2;
    }

    @NotNull
    public List<Module> getRelatedModules(@NotNull Module module) {
        if (module == null) {
            SpringBootMavenStarterManager.$$$reportNull$$$0(11);
        }
        List<Module> list = Collections.emptyList();
        if (list == null) {
            SpringBootMavenStarterManager.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Override
    @NotNull
    public Promise<?> refresh(@NotNull Module module) {
        MavenProjectsManager projectsManager;
        MavenProject mavenProject;
        if (module == null) {
            SpringBootMavenStarterManager.$$$reportNull$$$0(13);
        }
        Object object = (mavenProject = (projectsManager = MavenProjectsManager.getInstance((Project)module.getProject())).findProject(module)) == null ? Promises.rejectedPromise() : projectsManager.forceUpdateProjects(Collections.singleton(mavenProject));
        if (object == null) {
            SpringBootMavenStarterManager.$$$reportNull$$$0(14);
        }
        return object;
    }

    @NotNull
    private static UnifiedDependency adjustScope(@NotNull UnifiedDependency dependency) {
        if (dependency == null) {
            SpringBootMavenStarterManager.$$$reportNull$$$0(15);
        }
        UnifiedDependency unifiedDependency = "compile".equals(dependency.getScope()) ? new UnifiedDependency(dependency.getCoordinates(), null) : dependency;
        if (unifiedDependency == null) {
            SpringBootMavenStarterManager.$$$reportNull$$$0(16);
        }
        return unifiedDependency;
    }

    @Nullable
    private static MavenDomProjectModel getProjectModel(@NotNull Module module) {
        MavenProject mavenProject;
        if (module == null) {
            SpringBootMavenStarterManager.$$$reportNull$$$0(17);
        }
        return (mavenProject = MavenProjectsManager.getInstance((Project)module.getProject()).findProject(module)) == null ? null : MavenDomUtil.getMavenDomProjectModel((Project)module.getProject(), (VirtualFile)mavenProject.getFile());
    }

    private static void addManagedDependency(SpringBootStarterManager.ManagedDependency dependency, MavenDomProjectModel model) {
        UnifiedCoordinates coordinates = dependency.dependency.getCoordinates();
        if (SpringBootMavenStarterManager.findManagedDependency(coordinates, model) != null) {
            return;
        }
        String propertyName = dependency.getPropertyName();
        SpringBootMavenStarterManager.addVersionProperty(model, propertyName, coordinates.getVersion());
        MavenDomDependency domDependency = model.getDependencyManagement().getDependencies().addDependency();
        domDependency.getGroupId().setStringValue(coordinates.getGroupId());
        domDependency.getArtifactId().setStringValue(coordinates.getArtifactId());
        domDependency.getVersion().setStringValue("${" + propertyName + "}");
        domDependency.getType().setStringValue("pom");
        domDependency.getScope().setStringValue("import");
    }

    private static void addVersionProperty(MavenDomProjectModel model, String propertyName, String version) {
        if (version == null) {
            return;
        }
        MavenDomProperties properties = model.getProperties();
        XmlTag property = MavenDomProjectProcessorUtils.findProperty((MavenDomProperties)properties, (String)propertyName);
        if (property == null) {
            XmlTag xmlTag = properties.ensureTagExists();
            XmlTag propertyTag = xmlTag.createChildTag(propertyName, xmlTag.getNamespace(), version, false);
            xmlTag.add((PsiElement)propertyTag);
        }
    }

    private static MavenDomDependency findManagedDependency(UnifiedCoordinates coordinates, MavenDomProjectModel model) {
        String groupId = Objects.requireNonNull(coordinates.getGroupId());
        String artifactId = Objects.requireNonNull(coordinates.getArtifactId());
        for (MavenDomDependency domDependency : model.getDependencyManagement().getDependencies().getDependencies()) {
            if (!artifactId.equals(domDependency.getArtifactId().getStringValue()) || !groupId.equals(domDependency.getGroupId().getStringValue())) continue;
            return domDependency;
        }
        return null;
    }

    private static void saveFile(PsiFile psiFile) {
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)psiFile.getProject());
        Document document = documentManager.getDocument(psiFile);
        if (document != null) {
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            FileDocumentManager.getInstance().saveDocument(document);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 12, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/maven/SpringBootMavenStarterManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/maven/SpringBootMavenStarterManager";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustModule";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedModules";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "refresh";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "supports";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addDependency";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addDependencies";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addManagedDependencies";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isBuildFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "adjustModule";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedModules";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "adjustScope";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getProjectModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 12, 14, 16 -> new IllegalStateException(string);
        };
    }
}

