/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.starters.customizers;

import com.intellij.microservices.jvm.starters.WebStarterDependency;
import com.intellij.spring.boot.run.starters.SpringBootStarterModificationContext;
import com.intellij.spring.boot.run.starters.SpringBootStartersModuleBuilderKt;
import com.intellij.spring.boot.run.starters.customizers.SpringBootCloudStreamCustomizerKt;
import com.intellij.spring.boot.run.starters.customizers.SpringBootStarterCustomizer;
import com.intellij.spring.boot.run.starters.customizers.VersionRangesKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u000fH\u0002J\b\u0010\u0012\u001a\u00020\u000fH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/spring/boot/run/starters/customizers/SpringBootCloudStreamCustomizer;", "Lcom/intellij/spring/boot/run/starters/customizers/SpringBootStarterCustomizer;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "customize", "", "context", "Lcom/intellij/spring/boot/run/starters/SpringBootStarterModificationContext;", "customizeAdding", "customizeRemoving", "getBinderRabbit", "Lcom/intellij/microservices/jvm/starters/WebStarterDependency;", "getBinderKafka", "getBinderKafkaStream", "getTestDependency", "intellij.spring.boot.run"})
@SourceDebugExtension(value={"SMAP\nSpringBootCloudStreamCustomizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBootCloudStreamCustomizer.kt\ncom/intellij/spring/boot/run/starters/customizers/SpringBootCloudStreamCustomizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1755#2,3:88\n*S KotlinDebug\n*F\n+ 1 SpringBootCloudStreamCustomizer.kt\ncom/intellij/spring/boot/run/starters/customizers/SpringBootCloudStreamCustomizer\n*L\n30#1:88,3\n*E\n"})
public final class SpringBootCloudStreamCustomizer
implements SpringBootStarterCustomizer {
    @Override
    @NotNull
    public String getId() {
        return "cloud-stream";
    }

    @Override
    public void customize(@NotNull SpringBootStarterModificationContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        this.customizeAdding(context);
        this.customizeRemoving(context);
    }

    private final void customizeAdding(SpringBootStarterModificationContext context) {
        if (context.isFirstAdded(SpringBootCloudStreamCustomizerKt.access$getCLOUD_IDS$p())) {
            if (context.has("amqp")) {
                context.addDependency(this.getBinderRabbit());
            }
            if (context.has("kafka")) {
                context.addDependency(this.getBinderKafka());
            }
        } else {
            boolean bl;
            block15: {
                Iterable $this$any$iv = SpringBootCloudStreamCustomizerKt.access$getCLOUD_IDS$p();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!context.has(it)) continue;
                        bl = true;
                        break block15;
                    }
                    bl = false;
                }
            }
            if (bl) {
                if (context.isAdded("amqp")) {
                    context.addDependency(this.getBinderRabbit());
                }
                if (context.isAdded("kafka")) {
                    context.addDependency(this.getBinderKafka());
                }
            }
        }
        if (context.isAdded(this.getId())) {
            if (context.has("kafka-streams")) {
                context.addDependency(this.getBinderKafkaStream());
            }
            if (VersionRangesKt.getSPRING_BOOT_3_0_OR_LATER().match(context.getFrameworkVersion())) {
                context.addDependency(this.getTestDependency());
            }
        } else if (context.has(this.getId()) && context.isAdded("kafka-streams")) {
            context.addDependency(this.getBinderKafkaStream());
        }
    }

    private final void customizeRemoving(SpringBootStarterModificationContext context) {
        if (context.isLastRemoved(SpringBootCloudStreamCustomizerKt.access$getCLOUD_IDS$p())) {
            context.removeDependency(this.getBinderRabbit());
            context.removeDependency(this.getBinderKafka());
        } else {
            if (context.isRemoved("amqp")) {
                context.removeDependency(this.getBinderRabbit());
            }
            if (context.isRemoved("kafka")) {
                context.removeDependency(this.getBinderKafka());
            }
        }
        if (context.isRemoved(this.getId())) {
            context.removeDependency(this.getBinderKafkaStream());
            if (VersionRangesKt.getSPRING_BOOT_3_0_OR_LATER().match(context.getFrameworkVersion())) {
                context.removeDependency(this.getTestDependency());
            }
        } else if (context.isRemoved("kafka-streams")) {
            context.removeDependency(this.getBinderKafkaStream());
        }
    }

    private final WebStarterDependency getBinderRabbit() {
        return SpringBootStartersModuleBuilderKt.createStarterDependency$default("cloud-stream-binder-rabbit", "org.springframework.cloud", "spring-cloud-stream-binder-rabbit", null, null, null, 56, null);
    }

    private final WebStarterDependency getBinderKafka() {
        return SpringBootStartersModuleBuilderKt.createStarterDependency$default("cloud-stream-binder-kafka", "org.springframework.cloud", "spring-cloud-stream-binder-kafka", null, null, null, 56, null);
    }

    private final WebStarterDependency getBinderKafkaStream() {
        return SpringBootStartersModuleBuilderKt.createStarterDependency$default("cloud-stream-binder-kafka-streams", "org.springframework.cloud", "spring-cloud-stream-binder-kafka-streams", null, null, null, 56, null);
    }

    private final WebStarterDependency getTestDependency() {
        return SpringBootStartersModuleBuilderKt.createStarterDependency$default("cloud-stream-test", "org.springframework.cloud", "spring-cloud-stream-test-binder", null, "test", null, 40, null);
    }
}

