/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.starters.customizers;

import com.intellij.microservices.jvm.dependencies.Version;
import com.intellij.microservices.jvm.starters.WebStarterDependency;
import com.intellij.spring.boot.run.starters.SpringBootStartersModuleBuilderKt;
import com.intellij.spring.boot.run.starters.customizers.VersionRangesKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a,\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\".\u0010\u0005\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0001\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u00070\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"ID", "", "JDBC_IDS", "", "JDBC_REQUIRE_IDS", "ADDITIONAL_DEPENDENCIES", "Lkotlin/Pair;", "Lkotlin/Function1;", "Lcom/intellij/microservices/jvm/dependencies/Version;", "Lcom/intellij/microservices/jvm/starters/WebStarterDependency;", "getDependency", "id", "groupId", "artifactId", "version", "intellij.spring.boot.run"})
public final class SpringBootR2dbcCustomizerKt {
    @NotNull
    private static final String ID = "data-r2dbc";
    @NotNull
    private static final List<String> JDBC_IDS;
    @NotNull
    private static final List<String> JDBC_REQUIRE_IDS;
    @NotNull
    private static final List<Pair<String, Function1<Version, WebStarterDependency>>> ADDITIONAL_DEPENDENCIES;

    private static final WebStarterDependency getDependency(String id, String groupId, String artifactId, String version) {
        return SpringBootStartersModuleBuilderKt.createStarterDependency$default("data-r2dbc-" + id, groupId, artifactId, version, "runtime", null, 32, null);
    }

    static /* synthetic */ WebStarterDependency getDependency$default(String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 8) != 0) {
            string4 = null;
        }
        return SpringBootR2dbcCustomizerKt.getDependency(string, string2, string3, string4);
    }

    private static final WebStarterDependency ADDITIONAL_DEPENDENCIES$lambda$0(Version version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"<unused var>");
        return SpringBootR2dbcCustomizerKt.getDependency$default("h2", "io.r2dbc", "r2dbc-h2", null, 8, null);
    }

    private static final WebStarterDependency ADDITIONAL_DEPENDENCIES$lambda$1(Version version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        String dependencyVersion = VersionRangesKt.getSPRING_BOOT_3_0_OR_LATER().match(version) ? "1.1.3" : null;
        return SpringBootR2dbcCustomizerKt.getDependency("mariadb", "org.mariadb", "r2dbc-mariadb", dependencyVersion);
    }

    private static final WebStarterDependency ADDITIONAL_DEPENDENCIES$lambda$2(Version version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (!VersionRangesKt.getSPRING_BOOT_2_7_OR_LATER().match(version)) {
            SpringBootR2dbcCustomizerKt.getDependency$default("mysql", "dev.miku", "r2dbc-mysql", null, 8, null);
        } else if (VersionRangesKt.getSPRING_BOOT_3_1_OR_LATER().match(version)) {
            SpringBootR2dbcCustomizerKt.getDependency$default("mysql", "io.asyncer", "r2dbc-mysql", null, 8, null);
        }
        return null;
    }

    private static final WebStarterDependency ADDITIONAL_DEPENDENCIES$lambda$3(Version version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        String groupId = VersionRangesKt.getSPRING_BOOT_2_7_OR_LATER().match(version) ? "org.postgresql" : "io.r2dbc";
        return SpringBootR2dbcCustomizerKt.getDependency$default("postgresql", groupId, "r2dbc-postgresql", null, 8, null);
    }

    private static final WebStarterDependency ADDITIONAL_DEPENDENCIES$lambda$4(Version version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        String dependencyVersion = VersionRangesKt.getSPRING_BOOT_3_0_OR_LATER().match(version) ? "1.0.0.RELEASE" : null;
        return SpringBootR2dbcCustomizerKt.getDependency("sqlserver", "io.r2dbc", "r2dbc-mssql", dependencyVersion);
    }

    private static final WebStarterDependency ADDITIONAL_DEPENDENCIES$lambda$5(Version version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (VersionRangesKt.getSPRING_BOOT_2_7_OR_LATER().match(version)) {
            SpringBootR2dbcCustomizerKt.getDependency$default("oracle", "com.oracle.database.r2dbc", "oracle-r2dbc", null, 8, null);
        }
        return null;
    }

    public static final /* synthetic */ List access$getADDITIONAL_DEPENDENCIES$p() {
        return ADDITIONAL_DEPENDENCIES;
    }

    public static final /* synthetic */ List access$getJDBC_REQUIRE_IDS$p() {
        return JDBC_REQUIRE_IDS;
    }

    public static final /* synthetic */ List access$getJDBC_IDS$p() {
        return JDBC_IDS;
    }

    static {
        Object[] objectArray = new String[]{"jdbc", "data-jdbc", "data-jpa"};
        JDBC_IDS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"flyway", "liquibase"};
        JDBC_REQUIRE_IDS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"h2", SpringBootR2dbcCustomizerKt::ADDITIONAL_DEPENDENCIES$lambda$0), TuplesKt.to((Object)"mariadb", SpringBootR2dbcCustomizerKt::ADDITIONAL_DEPENDENCIES$lambda$1), TuplesKt.to((Object)"mysql", SpringBootR2dbcCustomizerKt::ADDITIONAL_DEPENDENCIES$lambda$2), TuplesKt.to((Object)"postgresql", SpringBootR2dbcCustomizerKt::ADDITIONAL_DEPENDENCIES$lambda$3), TuplesKt.to((Object)"sqlserver", SpringBootR2dbcCustomizerKt::ADDITIONAL_DEPENDENCIES$lambda$4), TuplesKt.to((Object)"oracle", SpringBootR2dbcCustomizerKt::ADDITIONAL_DEPENDENCIES$lambda$5)};
        ADDITIONAL_DEPENDENCIES = CollectionsKt.listOf((Object[])objectArray);
    }
}

