/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.starters.customizers;

import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.microservices.jvm.starters.WebStarterDependency;
import com.intellij.openapi.module.Module;
import com.intellij.spring.boot.run.starters.SpringBootStarterModificationContext;
import com.intellij.spring.boot.run.starters.SpringBootStartersModuleBuilder;
import com.intellij.spring.boot.run.starters.SpringBootStartersModuleBuilderKt;
import com.intellij.spring.boot.run.starters.customizers.SpringBootSessionCustomizerKt;
import com.intellij.spring.boot.run.starters.customizers.SpringBootStarterCustomizer;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/intellij/spring/boot/run/starters/customizers/SpringBootSessionCustomizer;", "Lcom/intellij/spring/boot/run/starters/customizers/SpringBootStarterCustomizer;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "customizeMetadata", "Lcom/intellij/spring/boot/run/starters/SpringBootStartersModuleBuilder$SpringBootCoordinates;", "module", "Lcom/intellij/openapi/module/Module;", "coordinates", "customize", "", "context", "Lcom/intellij/spring/boot/run/starters/SpringBootStarterModificationContext;", "customizeAdding", "customizeRemoving", "getJdbcDependency", "Lcom/intellij/microservices/jvm/starters/WebStarterDependency;", "getRedisDependency", "intellij.spring.boot.run"})
@SourceDebugExtension(value={"SMAP\nSpringBootSessionCustomizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBootSessionCustomizer.kt\ncom/intellij/spring/boot/run/starters/customizers/SpringBootSessionCustomizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,100:1\n1755#2,3:101\n19#3:104\n*S KotlinDebug\n*F\n+ 1 SpringBootSessionCustomizer.kt\ncom/intellij/spring/boot/run/starters/customizers/SpringBootSessionCustomizer\n*L\n48#1:101,3\n89#1:104\n*E\n"})
public final class SpringBootSessionCustomizer
implements SpringBootStarterCustomizer {
    @Override
    @NotNull
    public String getId() {
        return "session";
    }

    @Override
    @NotNull
    public SpringBootStartersModuleBuilder.SpringBootCoordinates customizeMetadata(@NotNull Module module, @NotNull SpringBootStartersModuleBuilder.SpringBootCoordinates coordinates) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)((Object)coordinates), (String)"coordinates");
        String jdbcArtifactId = SpringBootSessionCustomizerKt.access$getArtifactId("jdbc");
        if (JavaLibraryUtil.hasLibraryJar((Module)module, (String)("org.springframework.session:" + jdbcArtifactId))) {
            return new SpringBootStartersModuleBuilder.SpringBootCoordinates("org.springframework.session", jdbcArtifactId, coordinates.getVersion(), coordinates.getScope(), coordinates.getBom());
        }
        String redisArtifactId = SpringBootSessionCustomizerKt.access$getArtifactId("data-redis");
        if (JavaLibraryUtil.hasLibraryJar((Module)module, (String)("org.springframework.session:" + redisArtifactId))) {
            return new SpringBootStartersModuleBuilder.SpringBootCoordinates("org.springframework.session", redisArtifactId, coordinates.getVersion(), coordinates.getScope(), coordinates.getBom());
        }
        return coordinates;
    }

    @Override
    public void customize(@NotNull SpringBootStarterModificationContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        this.customizeAdding(context);
        this.customizeRemoving(context);
    }

    private final void customizeAdding(SpringBootStarterModificationContext context) {
        SmartList substitutors = new SmartList();
        if (context.isAdded(this.getId())) {
            boolean bl;
            block13: {
                if (context.has("jdbc")) {
                    substitutors.add((Object)this.getJdbcDependency());
                }
                Iterable $this$any$iv = SpringBootSessionCustomizerKt.access$getREDIS_IDS$p();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!context.has(it)) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            if (bl) {
                substitutors.add((Object)this.getRedisDependency());
            }
        } else if (context.has(this.getId())) {
            if (context.isAdded("jdbc")) {
                substitutors.add((Object)this.getJdbcDependency());
            }
            if (context.isFirstAdded(SpringBootSessionCustomizerKt.access$getREDIS_IDS$p())) {
                substitutors.add((Object)this.getRedisDependency());
            }
        }
        if (!((Collection)substitutors).isEmpty()) {
            WebStarterDependency dependency = context.find(this.getId());
            if (dependency != null) {
                context.removeDependency(dependency);
            }
            Iterator iterator = substitutors.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                WebStarterDependency substitutor = (WebStarterDependency)iterator2.next();
                Intrinsics.checkNotNull((Object)substitutor);
                context.addDependency(substitutor);
            }
        }
    }

    private final void customizeRemoving(SpringBootStarterModificationContext context) {
        if (context.has(this.getId())) {
            boolean substitute = false;
            if (context.isRemoved("jdbc")) {
                substitute = true;
                context.removeDependency(this.getJdbcDependency());
            }
            if (context.isLastRemoved(SpringBootSessionCustomizerKt.access$getREDIS_IDS$p())) {
                substitute = true;
                context.removeDependency(this.getRedisDependency());
            }
            if (substitute && !context.has("jdbc") && !context.has("data-redis") && !context.has("data-redis-reactive")) {
                WebStarterDependency webStarterDependency = context.find(this.getId());
                SpringBootStartersModuleBuilder.SpringBootStarterDependency springBootStarterDependency = webStarterDependency instanceof SpringBootStartersModuleBuilder.SpringBootStarterDependency ? (SpringBootStartersModuleBuilder.SpringBootStarterDependency)webStarterDependency : null;
                if (springBootStarterDependency == null || (springBootStarterDependency = springBootStarterDependency.getCoordinates()) == null) {
                    return;
                }
                SpringBootStartersModuleBuilder.SpringBootStarterDependency coordinates = springBootStarterDependency;
                String string = coordinates.getGroupId();
                String string2 = SpringBootSessionCustomizerKt.access$getArtifactId("core");
                String string3 = coordinates.getVersion();
                String string4 = coordinates.getScope();
                SpringBootStartersModuleBuilder.SpringBootStarterDependency $this$asSafely$iv = coordinates;
                boolean $i$f$asSafely = false;
                SpringBootStartersModuleBuilder.SpringBootStarterDependency springBootStarterDependency2 = $this$asSafely$iv;
                if (!(springBootStarterDependency2 instanceof SpringBootStartersModuleBuilder.SpringBootCoordinates)) {
                    springBootStarterDependency2 = null;
                }
                SpringBootStartersModuleBuilder.SpringBootCoordinates springBootCoordinates = (SpringBootStartersModuleBuilder.SpringBootCoordinates)((Object)springBootStarterDependency2);
                WebStarterDependency coreDependency = SpringBootStartersModuleBuilderKt.createStarterDependency("session-original", string, string2, string3, string4, springBootCoordinates != null ? springBootCoordinates.getBom() : null);
                context.addDependency(coreDependency);
            }
        }
    }

    private final WebStarterDependency getJdbcDependency() {
        return SpringBootStartersModuleBuilderKt.createStarterDependency$default("session-jdbc", "org.springframework.session", SpringBootSessionCustomizerKt.access$getArtifactId("jdbc"), null, null, null, 56, null);
    }

    private final WebStarterDependency getRedisDependency() {
        return SpringBootStartersModuleBuilderKt.createStarterDependency$default("session-data-redis", "org.springframework.session", SpringBootSessionCustomizerKt.access$getArtifactId("data-redis"), null, null, null, 56, null);
    }
}

