/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.starters.customizers;

import com.intellij.microservices.jvm.starters.WebStarterDependency;
import com.intellij.spring.boot.run.starters.SpringBootStarterModificationContext;
import com.intellij.spring.boot.run.starters.SpringBootStartersModuleBuilderKt;
import com.intellij.spring.boot.run.starters.customizers.SpringBootStarterCustomizer;
import com.intellij.spring.boot.run.starters.customizers.SpringBootTestContainersCustomizerKt;
import com.intellij.spring.boot.run.starters.customizers.VersionRangesKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/spring/boot/run/starters/customizers/SpringBootTestContainersCustomizer;", "Lcom/intellij/spring/boot/run/starters/customizers/SpringBootStarterCustomizer;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "customize", "", "context", "Lcom/intellij/spring/boot/run/starters/SpringBootStarterModificationContext;", "customizeAdding", "customizeRemoving", "getDependency", "Lcom/intellij/microservices/jvm/starters/WebStarterDependency;", "getTestDependency", "intellij.spring.boot.run"})
@SourceDebugExtension(value={"SMAP\nSpringBootTestContainersCustomizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBootTestContainersCustomizer.kt\ncom/intellij/spring/boot/run/starters/customizers/SpringBootTestContainersCustomizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1755#2,3:77\n*S KotlinDebug\n*F\n+ 1 SpringBootTestContainersCustomizer.kt\ncom/intellij/spring/boot/run/starters/customizers/SpringBootTestContainersCustomizer\n*L\n42#1:77,3\n*E\n"})
public final class SpringBootTestContainersCustomizer
implements SpringBootStarterCustomizer {
    @Override
    @NotNull
    public String getId() {
        return "testcontainers";
    }

    @Override
    public void customize(@NotNull SpringBootStarterModificationContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        if (!VersionRangesKt.getSPRING_BOOT_3_1_OR_LATER().match(context.getFrameworkVersion())) {
            return;
        }
        this.customizeAdding(context);
        this.customizeRemoving(context);
    }

    private final void customizeAdding(SpringBootStarterModificationContext context) {
        block7: {
            block6: {
                if (!context.isAdded(this.getId())) break block6;
                context.addDependency(this.getTestDependency());
                for (Pair additionalDependency : SpringBootTestContainersCustomizerKt.access$getADDITIONAL_DEPENDENCIES$p()) {
                    boolean bl;
                    block5: {
                        Iterable $this$any$iv = (Iterable)additionalDependency.getSecond();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                String it = (String)element$iv;
                                boolean bl2 = false;
                                if (!context.has(it)) continue;
                                bl = true;
                                break block5;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    context.addDependency(this.getDependency((String)additionalDependency.getFirst()));
                }
                break block7;
            }
            if (!context.has(this.getId())) break block7;
            for (Pair additionalDependency : SpringBootTestContainersCustomizerKt.access$getADDITIONAL_DEPENDENCIES$p()) {
                if (!context.isFirstAdded((List)additionalDependency.getSecond())) continue;
                context.addDependency(this.getDependency((String)additionalDependency.getFirst()));
            }
        }
    }

    private final void customizeRemoving(SpringBootStarterModificationContext context) {
        if (context.isRemoved(this.getId())) {
            context.removeDependency(this.getTestDependency());
            for (Pair additionalDependency : SpringBootTestContainersCustomizerKt.access$getADDITIONAL_DEPENDENCIES$p()) {
                context.removeDependency(this.getDependency((String)additionalDependency.getFirst()));
            }
        } else {
            for (Pair additionalDependency : SpringBootTestContainersCustomizerKt.access$getADDITIONAL_DEPENDENCIES$p()) {
                if (!context.isLastRemoved((List)additionalDependency.getSecond())) continue;
                context.removeDependency(this.getDependency((String)additionalDependency.getFirst()));
            }
        }
    }

    private final WebStarterDependency getDependency(String id) {
        return SpringBootStartersModuleBuilderKt.createStarterDependency$default(this.getId() + "-" + id, "org.testcontainers", id, null, "test", null, 40, null);
    }

    private final WebStarterDependency getTestDependency() {
        return SpringBootStartersModuleBuilderKt.createStarterDependency$default("spring-boot-testcontainers", "org.springframework.boot", "spring-boot-testcontainers", null, "test", null, 40, null);
    }
}

