/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.spi;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.spi.SpringBootImportsFileIndexKt;
import com.intellij.spring.boot.spi.SpringBootImportsManager;
import com.intellij.spring.spi.SpringSpiManager;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J.\u0010\r\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\b0\u0010H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/spring/boot/spi/SpringBootImportsManagerImpl;", "Lcom/intellij/spring/boot/spi/SpringBootImportsManager;", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/module/Module;)V", "getClasses", "", "Lcom/intellij/psi/PsiClass;", "includeTests", "", "key", "", "processValues", "valueHint", "processor", "Lcom/intellij/util/PairProcessor;", "Lcom/intellij/psi/PsiElement;", "getAutoConfigurationClasses", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getScope", "intellij.spring.boot.core"})
public final class SpringBootImportsManagerImpl
extends SpringBootImportsManager {
    @NotNull
    private final Module module;

    public SpringBootImportsManagerImpl(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.module = module;
    }

    @Override
    @NotNull
    public List<PsiClass> getClasses(boolean includeTests, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Project project = this.module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return SpringBootImportsFileIndexKt.getSpringBootImportsClasses(project, this.getScope(includeTests), key);
    }

    @Override
    public boolean processValues(boolean includeTests, @Nullable String valueHint, @NotNull PairProcessor<PsiElement, PsiClass> processor) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Project project = this.module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return SpringBootImportsFileIndexKt.processSpringBootImportsValues(project, this.getScope(includeTests), valueHint, processor);
    }

    @Override
    @NotNull
    public List<PsiClass> getAutoConfigurationClasses(boolean includeTests) {
        return this.getAutoConfigurationClasses(this.getScope(includeTests));
    }

    @Override
    @NotNull
    public List<PsiClass> getAutoConfigurationClasses(@NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        ArrayList result = new ArrayList();
        if (SpringBootLibraryUtil.isBelowVersion(this.module, SpringBootLibraryUtil.SpringBootVersion.VERSION_3_0_0)) {
            result.addAll(SpringSpiManager.getInstance((Module)this.module).getClassesListValue("org.springframework.boot.autoconfigure.EnableAutoConfiguration", scope));
        }
        if (SpringBootLibraryUtil.isAtLeastVersion(this.module, SpringBootLibraryUtil.SpringBootVersion.VERSION_2_7_0)) {
            Project project = this.module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            result.addAll(SpringBootImportsFileIndexKt.getSpringBootImportsClasses(project, scope, "org.springframework.boot.autoconfigure.AutoConfiguration"));
        }
        ContainerUtil.removeDuplicates((Collection)result);
        return result;
    }

    private final GlobalSearchScope getScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleRuntimeScope((Module)this.module, (boolean)includeTests);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"moduleRuntimeScope(...)");
        return globalSearchScope;
    }
}

