/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.spi;

import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.spi.SpringBootImportsManager;
import com.intellij.spring.spi.SpringSpiClassesListJamConverter;
import com.intellij.spring.spi.SpringSpiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J+\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/spring/boot/spi/SpringBootSpiClassesListJamConverter;", "Lcom/intellij/spring/spi/SpringSpiClassesListJamConverter;", "configKey", "", "importKey", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "createReferences", "", "Lcom/intellij/psi/PsiReference;", "context", "Lcom/intellij/jam/JamStringAttributeElement;", "Lcom/intellij/psi/PsiClass;", "injectionHost", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "(Lcom/intellij/jam/JamStringAttributeElement;Lcom/intellij/psi/PsiLanguageInjectionHost;)[Lcom/intellij/psi/PsiReference;", "SpringBootSpiClassReference", "intellij.spring.boot"})
public final class SpringBootSpiClassesListJamConverter
extends SpringSpiClassesListJamConverter {
    @NotNull
    private final String importKey;

    public SpringBootSpiClassesListJamConverter(@NotNull String configKey, @NotNull String importKey) {
        Intrinsics.checkNotNullParameter((Object)configKey, (String)"configKey");
        Intrinsics.checkNotNullParameter((Object)importKey, (String)"importKey");
        super(configKey);
        this.importKey = importKey;
    }

    @NotNull
    public PsiReference[] createReferences(@NotNull JamStringAttributeElement<PsiClass> context, @NotNull PsiLanguageInjectionHost injectionHost) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)injectionHost, (String)"injectionHost");
        PsiReference[] psiReferenceArray = new PsiReference[1];
        String string = this.myConfigKey;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myConfigKey");
        psiReferenceArray[0] = new SpringBootSpiClassReference(string, this.importKey, (PsiElement)injectionHost, null, context.getStringValue());
        return psiReferenceArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0014R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/spring/boot/spi/SpringBootSpiClassesListJamConverter$SpringBootSpiClassReference;", "Lcom/intellij/spring/spi/SpringSpiClassesListJamConverter$SpringSpiClassReference;", "configKey", "", "importKey", "literal", "Lcom/intellij/psi/PsiElement;", "rangeInElement", "Lcom/intellij/openapi/util/TextRange;", "text", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;Ljava/lang/String;)V", "getRelevantClasses", "", "Lcom/intellij/psi/PsiClass;", "intellij.spring.boot"})
    public static final class SpringBootSpiClassReference
    extends SpringSpiClassesListJamConverter.SpringSpiClassReference {
        @NotNull
        private final String importKey;

        public SpringBootSpiClassReference(@NotNull String configKey, @NotNull String importKey, @NotNull PsiElement literal, @Nullable TextRange rangeInElement, @Nullable String text) {
            Intrinsics.checkNotNullParameter((Object)configKey, (String)"configKey");
            Intrinsics.checkNotNullParameter((Object)importKey, (String)"importKey");
            Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
            super(configKey, literal, rangeInElement, text);
            this.importKey = importKey;
        }

        @NotNull
        protected List<PsiClass> getRelevantClasses(@Nullable PsiElement literal, @NotNull String configKey) {
            Intrinsics.checkNotNullParameter((Object)configKey, (String)"configKey");
            if (literal == null) {
                return CollectionsKt.emptyList();
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)literal);
            if (module == null) {
                return CollectionsKt.emptyList();
            }
            Module module2 = module;
            VirtualFile containingFile = literal.getContainingFile().getOriginalFile().getVirtualFile();
            boolean isInTest = containingFile != null && ModuleRootManager.getInstance((Module)module2).getFileIndex().isInTestSourceContent(containingFile);
            List result = SpringSpiManager.getInstance((Module)module2).getClassesListValue(isInTest, configKey);
            if (!SpringBootLibraryUtil.isAtLeastVersion(module2, SpringBootLibraryUtil.SpringBootVersion.VERSION_2_7_0)) {
                Intrinsics.checkNotNull((Object)result);
                return result;
            }
            List<PsiClass> imports = SpringBootImportsManager.Companion.getInstance(module2).getClasses(isInTest, this.importKey);
            List list = ContainerUtil.concat((List)result, imports);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"concat(...)");
            return list;
        }
    }
}

