/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.ide;

import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import io.ktor.ide.KtorUtilsKt;
import io.ktor.ide.utils.KotlinResolveKt;
import io.ktor.ide.utils.KtorVersionModel;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u001a\u0012\u0010\t\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u001a\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0000\u001a\u0012\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0000\u001a\u0012\u0010\f\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0000\u001a\u0012\u0010\f\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u001a\u0012\u0010\r\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0000\u001a\u0012\u0010\u000e\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0000\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a \u0010\u0012\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"KTOR_SERVER_LIBRARIES", "", "", "KTOR_CLIENT_LIBRARIES", "KTOR_YAML_CONFIGURATION_LIBRARIES", "hasKtorServerLibrary", "", "project", "Lcom/intellij/openapi/project/Project;", "hasKtorClientLibrary", "module", "Lcom/intellij/openapi/module/Module;", "hasKtorServerOrClientLibrary", "hasKtorYamlLibrary", "hasKtorConfiguration", "getKtorServerVersion", "Lio/ktor/ide/utils/KtorVersionModel;", "getKtorClientVersion", "getKtorVersionModel", "ktorLibraryCoords", "", "isEmbeddedServerCall", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "isApplicationExtension", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "intellij.ktor.starter"})
@SourceDebugExtension(value={"SMAP\nKtorLibraryUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorLibraryUtil.kt\nio/ktor/ide/KtorLibraryUtilKt\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n28#2,2:64\n36#3,13:66\n1755#4,3:79\n*S KotlinDebug\n*F\n+ 1 KtorLibraryUtil.kt\nio/ktor/ide/KtorLibraryUtilKt\n*L\n54#1:64,2\n54#1:66,13\n58#1:79,3\n*E\n"})
public final class KtorLibraryUtilKt {
    @NotNull
    private static final List<String> KTOR_SERVER_LIBRARIES;
    @NotNull
    private static final List<String> KTOR_CLIENT_LIBRARIES;
    @NotNull
    private static final List<String> KTOR_YAML_CONFIGURATION_LIBRARIES;

    public static final boolean hasKtorServerLibrary(@Nullable Project project) {
        return JavaLibraryUtil.hasAnyLibraryJar((Project)project, (Collection)KTOR_SERVER_LIBRARIES);
    }

    public static final boolean hasKtorClientLibrary(@Nullable Project project) {
        return JavaLibraryUtil.hasAnyLibraryJar((Project)project, (Collection)KTOR_CLIENT_LIBRARIES);
    }

    public static final boolean hasKtorServerLibrary(@Nullable Module module) {
        return JavaLibraryUtil.hasAnyLibraryJar((Module)module, (Collection)KTOR_SERVER_LIBRARIES);
    }

    public static final boolean hasKtorClientLibrary(@Nullable Module module) {
        return JavaLibraryUtil.hasAnyLibraryJar((Module)module, (Collection)KTOR_CLIENT_LIBRARIES);
    }

    public static final boolean hasKtorServerOrClientLibrary(@Nullable Module module) {
        return KtorLibraryUtilKt.hasKtorServerLibrary(module) || KtorLibraryUtilKt.hasKtorClientLibrary(module);
    }

    public static final boolean hasKtorServerOrClientLibrary(@Nullable Project project) {
        return KtorLibraryUtilKt.hasKtorServerLibrary(project) || KtorLibraryUtilKt.hasKtorClientLibrary(project);
    }

    public static final boolean hasKtorYamlLibrary(@Nullable Module module) {
        return JavaLibraryUtil.hasAnyLibraryJar((Module)module, (Collection)KTOR_YAML_CONFIGURATION_LIBRARIES);
    }

    public static final boolean hasKtorConfiguration(@Nullable Module module) {
        return KtorLibraryUtilKt.hasKtorYamlLibrary(module) || KtorLibraryUtilKt.hasKtorServerOrClientLibrary(module);
    }

    @Nullable
    public static final KtorVersionModel getKtorServerVersion(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return KtorLibraryUtilKt.getKtorVersionModel(module, (Collection<String>)KTOR_SERVER_LIBRARIES);
    }

    @Nullable
    public static final KtorVersionModel getKtorClientVersion(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return KtorLibraryUtilKt.getKtorVersionModel(module, (Collection<String>)KTOR_CLIENT_LIBRARIES);
    }

    private static final KtorVersionModel getKtorVersionModel(Module module, Collection<String> ktorLibraryCoords) {
        KtorVersionModel ktorVersionModel;
        block1: {
            for (String coords : (Iterable)ktorLibraryCoords) {
                String version;
                boolean bl = false;
                KtorVersionModel ktorVersionModel2 = JavaLibraryUtil.getLibraryVersion((Module)module, (String)coords) == null ? null : KtorVersionModel.Companion.parseVersion$default(KtorVersionModel.Companion, version, false, 2, null);
                if (ktorVersionModel2 == null) continue;
                ktorVersionModel = ktorVersionModel2;
                break block1;
            }
            ktorVersionModel = null;
        }
        return ktorVersionModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isEmbeddedServerCall(@NotNull KtCallExpression callExpression) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
        boolean $i$f$analyze = false;
        Project project = ((KtElement)callExpression).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KaSessionProvider this_$iv$iv = KaSessionProvider.Companion.getInstance(project);
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)callExpression);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)callExpression);
        try {
            boolean bl2;
            Object lock$iv$iv;
            Object object = lock$iv$iv = new Object();
            synchronized (object) {
                boolean bl3 = false;
                KaSession $this$isEmbeddedServerCall_u24lambda_u241 = analysisSession$iv$iv;
                boolean bl4 = false;
                bl2 = KotlinResolveKt.isOneOfAcceptedFunction($this$isEmbeddedServerCall_u24lambda_u241, (KtCallElement)callExpression, KtorUtilsKt.getEMBEDDED_SERVER_FUNCTIONS_BY_VERSION().values());
            }
            bl = bl2;
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)callExpression);
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isApplicationExtension(@NotNull KtNamedFunction function) {
        String string;
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        KtTypeReference ktTypeReference = function.getReceiverTypeReference();
        if (!Intrinsics.areEqual((Object)(ktTypeReference != null ? ktTypeReference.getText() : null), (Object)"Application")) return false;
        Iterable $this$any$iv = function.getContainingKtFile().getImportDirectives();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            KtImportDirective it = (KtImportDirective)element$iv;
            boolean bl = false;
            FqName fqName = it.getImportedFqName();
            string = fqName != null ? fqName.asString() : null;
            if (string != null) continue;
            string = "";
        } while (!StringsKt.contains$default((CharSequence)string, (CharSequence)"io.ktor.server.application", (boolean)false, (int)2, null));
        return true;
    }

    static {
        Object[] objectArray = new String[]{"io.ktor:ktor-server-core", "io.ktor:ktor-server-core-jvm"};
        KTOR_SERVER_LIBRARIES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"io.ktor:ktor-client-core", "io.ktor:ktor-client-core-jvm"};
        KTOR_CLIENT_LIBRARIES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"io.ktor:ktor-server-config-yaml", "io.ktor:ktor-server-config-yaml-jvm"};
        KTOR_YAML_CONFIGURATION_LIBRARIES = CollectionsKt.listOf((Object[])objectArray);
    }
}

