/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.ide;

import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.EndpointsUrlTargetProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.microservices.endpoints.presentation.HttpMethodPresentation;
import com.intellij.microservices.oas.OpenApiSpecification;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.uast.UastModificationTracker;
import io.ktor.ide.KtorLibraryUtilKt;
import io.ktor.ide.KtorOasUrlMapping;
import io.ktor.ide.KtorServerEndpointsProviderKt;
import io.ktor.ide.KtorStarterBundle;
import io.ktor.ide.KtorStarterIcons;
import io.ktor.ide.KtorUrlMapping;
import io.ktor.ide.KtorUrlTargetInfo;
import io.ktor.ide.KtorUtilsKt;
import io.ktor.ide.actions.swagger.ModuleWithoutDependenciesFilter;
import io.ktor.ide.oas.KtorOasRouteSupportKt;
import io.ktor.ide.url.UrlUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00132\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010#\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0003H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006%"}, d2={"Lio/ktor/ide/KtorServerEndpointsProvider;", "Lcom/intellij/microservices/endpoints/EndpointsUrlTargetProvider;", "Lcom/intellij/psi/PsiFile;", "Lio/ktor/ide/KtorOasUrlMapping;", "<init>", "()V", "endpointType", "Lcom/intellij/microservices/endpoints/EndpointType;", "getEndpointType", "()Lcom/intellij/microservices/endpoints/EndpointType;", "presentation", "Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getPresentation", "()Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getStatus", "Lcom/intellij/microservices/endpoints/EndpointsProvider$Status;", "project", "Lcom/intellij/openapi/project/Project;", "getEndpointGroups", "", "filter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "getEndpoints", "group", "isValidEndpoint", "", "endpoint", "getEndpointPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getUrlTargetInfo", "Lcom/intellij/microservices/url/UrlTargetInfo;", "getDocumentationElement", "Lcom/intellij/psi/PsiElement;", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getOpenApiSpecification", "Lcom/intellij/microservices/oas/OpenApiSpecification;", "intellij.ktor.starter"})
@SourceDebugExtension(value={"SMAP\nKtorServerEndpointsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorServerEndpointsProvider.kt\nio/ktor/ide/KtorServerEndpointsProvider\n+ 2 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n207#2:138\n1368#3:139\n1454#3,5:140\n*S KotlinDebug\n*F\n+ 1 KtorServerEndpointsProvider.kt\nio/ktor/ide/KtorServerEndpointsProvider\n*L\n54#1:138\n55#1:139\n55#1:140,5\n*E\n"})
public final class KtorServerEndpointsProvider
implements EndpointsUrlTargetProvider<PsiFile, KtorOasUrlMapping> {
    @NotNull
    private final EndpointType endpointType = EndpointTypes.HTTP_SERVER_TYPE;
    @NotNull
    private final FrameworkPresentation presentation = new FrameworkPresentation("Ktor-HTTP-Server", KtorStarterBundle.INSTANCE.message("ktor.endpoints.presentation.title", new Object[0]), KtorStarterIcons.Ktor);

    @NotNull
    public EndpointType getEndpointType() {
        return this.endpointType;
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        return this.presentation;
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return KtorLibraryUtilKt.hasKtorServerLibrary(project) ? EndpointsProvider.Status.HAS_ENDPOINTS : EndpointsProvider.Status.UNAVAILABLE;
    }

    @NotNull
    public Iterable<PsiFile> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (filter instanceof ModuleEndpointsFilter) {
            if (!KtorLibraryUtilKt.hasKtorServerLibrary(((ModuleEndpointsFilter)filter).getModule())) {
                iterable = CollectionsKt.emptyList();
            } else {
                PsiFile[] psiFileArray = CacheManager.getInstance((Project)project).getFilesWithWord("routing", (short)1, ((ModuleEndpointsFilter)filter).getTransitiveSearchScope(), true);
                Intrinsics.checkNotNullExpressionValue((Object)psiFileArray, (String)"getFilesWithWord(...)");
                iterable = ArraysKt.asIterable((Object[])psiFileArray);
            }
        } else if (filter instanceof ModuleWithoutDependenciesFilter) {
            if (!KtorLibraryUtilKt.hasKtorServerLibrary(((ModuleWithoutDependenciesFilter)filter).getModule())) {
                iterable = CollectionsKt.emptyList();
            } else {
                PsiFile[] psiFileArray = CacheManager.getInstance((Project)project).getFilesWithWord("routing", (short)1, ((ModuleWithoutDependenciesFilter)filter).getTransitiveSearchScope(), true);
                Intrinsics.checkNotNullExpressionValue((Object)psiFileArray, (String)"getFilesWithWord(...)");
                iterable = ArraysKt.asIterable((Object[])psiFileArray);
            }
        } else {
            iterable = CollectionsKt.emptyList();
        }
        return iterable;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterable<KtorOasUrlMapping> getEndpoints(@NotNull PsiFile group) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        PsiElement $this$getUastParentOfType_u24default$iv = (PsiElement)group;
        boolean strict$iv = false;
        boolean $i$f$getUastParentOfType22 = false;
        Iterable $this$flatMap$iv = KtorServerEndpointsProviderKt.collectUrlMappingsInside$default(UastContextKt.getUastParentOfType((PsiElement)$this$getUastParentOfType_u24default$iv, UFile.class, (boolean)strict$iv), false, 2, null);
        boolean $i$f$flatMap = false;
        Iterable $i$f$getUastParentOfType22 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            KtorUrlMapping it = (KtorUrlMapping)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = KtorOasRouteSupportKt.asOasUrlMappings(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public boolean isValidEndpoint(@NotNull PsiFile group, @NotNull KtorOasUrlMapping endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        PsiElement psiElement = endpoint.getKtorUrlMapping().getNavigationTarget();
        return psiElement != null ? psiElement.isValid() : false;
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull PsiFile group, @NotNull KtorOasUrlMapping endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        String string = KtorUtilsKt.getFullPresentation(endpoint.getKtorUrlMapping().getUrlPath());
        List list = CollectionsKt.listOf((Object)endpoint.getKtorUrlMapping().getMethod());
        Object object = endpoint.getKtorUrlMapping().getNavigationTarget();
        if (object == null || (object = object.getContainingFile()) == null || (object = object.getName()) == null) {
            object = "unknown";
        }
        return (ItemPresentation)new HttpMethodPresentation(string, list, (String)object, KtorStarterIcons.Ktor, null, 16, null);
    }

    @NotNull
    public Iterable<UrlTargetInfo> getUrlTargetInfo(@NotNull PsiFile group, @NotNull KtorOasUrlMapping endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return CollectionsKt.listOf((Object)new KtorUrlTargetInfo(endpoint.getKtorUrlMapping(), UrlUtilsKt.getAuthoritiesByModule(GenericPsiUtils.getModule((PsiElement)((PsiElement)group)))));
    }

    @Nullable
    public PsiElement getDocumentationElement(@NotNull PsiFile group, @NotNull KtorOasUrlMapping endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return endpoint.getKtorUrlMapping().getNavigationTarget();
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (ModificationTracker)UastModificationTracker.Companion.getInstance(project);
    }

    @NotNull
    public OpenApiSpecification getOpenApiSpecification(@NotNull PsiFile group, @NotNull KtorOasUrlMapping endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return endpoint.getOasInfo();
    }
}

