/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.ide.actions.swagger;

import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.oas.OpenApiSpecification;
import com.intellij.microservices.oas.serialization.OasExportUtilsKt;
import com.intellij.microservices.oas.serialization.OasSerializationUtilsKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import io.ktor.ide.KtorLibraryUtilKt;
import io.ktor.ide.KtorOasUrlMapping;
import io.ktor.ide.KtorServerEndpointsProvider;
import io.ktor.ide.KtorStarterBundle;
import io.ktor.ide.KtorStarterIcons;
import io.ktor.ide.actions.swagger.ModuleWithoutDependenciesFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u00012\u00020\u0002:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000f"}, d2={"Lio/ktor/ide/actions/swagger/KtorGenerateOpenApiAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "retrieveFile", "Lcom/intellij/psi/PsiFile;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "", "actionPerformed", "Companion", "intellij.ktor.starter"})
public final class KtorGenerateOpenApiAction
extends AnAction
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final PsiFile retrieveFile(AnActionEvent event) {
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        return (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext2);
    }

    public void update(@NotNull AnActionEvent event) {
        Module module;
        PsiFile file;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Presentation presentation = event.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        PsiFile psiFile = file = this.retrieveFile(event);
        if (psiFile != null) {
            PsiFile it = psiFile;
            boolean bl = false;
            v2 = ModuleUtilCore.findModuleForFile((VirtualFile)it.getVirtualFile(), (Project)file.getProject());
        } else {
            v2 = module = null;
        }
        if (module == null) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        presentation2.setEnabledAndVisible(KtorLibraryUtilKt.hasKtorServerLibrary(module));
        Object[] objectArray = new Object[]{module.getName()};
        presentation2.setText(KtorStarterBundle.INSTANCE.message("action.KtorGenerateOpenApiAction.MainMenu.text.named", objectArray));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        PsiFile psiFile = this.retrieveFile(event);
        if (psiFile == null) {
            return;
        }
        PsiFile file = psiFile;
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file.getVirtualFile(), (Project)file.getProject());
        if (module == null) {
            return;
        }
        Module module2 = module;
        Companion.generateOpenApiAndShowNotifications(module2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007J(\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\r2\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012J \u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u001d"}, d2={"Lio/ktor/ide/actions/swagger/KtorGenerateOpenApiAction$Companion;", "", "<init>", "()V", "findOpenApiFile", "Lcom/intellij/psi/PsiFile;", "module", "Lcom/intellij/openapi/module/Module;", "openApiFileExists", "", "prepareOpenApiForModule", "Lcom/intellij/microservices/oas/OpenApiSpecification;", "prepareOpenApiTextForModule", "", "dumpOpenApiForModule", "Lcom/intellij/openapi/vfs/VirtualFile;", "content", "continueIfExists", "Lkotlin/Function0;", "generateNewOpenApiFile", "generateOpenApiAndShowNotifications", "", "openFile", "project", "Lcom/intellij/openapi/project/Project;", "file", "findResourcesRoot", "getOrCreateResourcesRoot", "Lcom/intellij/psi/PsiDirectory;", "intellij.ktor.starter"})
    @SourceDebugExtension(value={"SMAP\nKtorGenerateOpenApiAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorGenerateOpenApiAction.kt\nio/ktor/ide/actions/swagger/KtorGenerateOpenApiAction$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,224:1\n1368#2:225\n1454#2,2:226\n1557#2:228\n1628#2,3:229\n1456#2,3:232\n*S KotlinDebug\n*F\n+ 1 KtorGenerateOpenApiAction.kt\nio/ktor/ide/actions/swagger/KtorGenerateOpenApiAction$Companion\n*L\n101#1:225\n101#1:226,2\n104#1:228\n104#1:229,3\n101#1:232,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PsiFile findOpenApiFile(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            VirtualFile virtualFile = this.findResourcesRoot(module);
            if (virtualFile == null) {
                return null;
            }
            VirtualFile resources = virtualFile;
            PsiDirectory psiDirectory = PsiManager.getInstance((Project)module.getProject()).findDirectory(resources);
            if (psiDirectory == null) {
                return null;
            }
            PsiDirectory resourcesDirPsi = psiDirectory;
            PsiDirectory psiDirectory2 = resourcesDirPsi.findSubdirectory("openapi");
            if (psiDirectory2 == null) {
                return null;
            }
            PsiDirectory openapiDir = psiDirectory2;
            return openapiDir.findFile("documentation.yaml");
        }

        public final boolean openApiFileExists(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            return this.findOpenApiFile(module) != null;
        }

        /*
         * WARNING - void declaration
         */
        private final OpenApiSpecification prepareOpenApiForModule(Module module) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            KtorServerEndpointsProvider provider = new KtorServerEndpointsProvider();
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Iterable<PsiFile> iterable = provider.getEndpointGroups(project, (EndpointsFilter)new ModuleWithoutDependenciesFilter(module));
            boolean $i$f$flatMap = false;
            void var6_5 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                PsiFile file = (PsiFile)element$iv$iv;
                boolean bl = false;
                Iterable<KtorOasUrlMapping> iterable2 = provider.getEndpoints(file);
                boolean $i$f$map = false;
                void var15_14 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void endpoint;
                    KtorOasUrlMapping ktorOasUrlMapping = (KtorOasUrlMapping)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(provider.getOpenApiSpecification(file, (KtorOasUrlMapping)endpoint));
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List endpoints = (List)destination$iv$iv;
            return OasExportUtilsKt.squashOpenApiSpecifications((List)CollectionsKt.toList((Iterable)endpoints));
        }

        @NotNull
        public final String prepareOpenApiTextForModule(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            OpenApiSpecification openApiSpecification = this.prepareOpenApiForModule(module);
            String string = module.getProject().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return OasSerializationUtilsKt.generateOasDraft((String)string, (OpenApiSpecification)openApiSpecification);
        }

        @Nullable
        public final VirtualFile dumpOpenApiForModule(@NotNull Module module, @NotNull String content, @NotNull Function0<Boolean> continueIfExists) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter(continueIfExists, (String)"continueIfExists");
            PsiDirectory psiDirectory = this.getOrCreateResourcesRoot(module);
            if (psiDirectory == null) {
                return null;
            }
            PsiDirectory resources = psiDirectory;
            PsiDirectory openApiDir = (PsiDirectory)ActionsKt.runWriteAction(() -> Companion.dumpOpenApiForModule$lambda$3(resources));
            PsiFile existingFile = openApiDir.findFile("documentation.yaml");
            boolean shouldOverwriteSwaggerFile = existingFile != null && (Boolean)continueIfExists.invoke() != false;
            Object[] objectArray = new Object[]{module.getName()};
            return (VirtualFile)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> Companion.dumpOpenApiForModule$lambda$6(existingFile, shouldOverwriteSwaggerFile, module, openApiDir, content), KtorStarterBundle.INSTANCE.message("ktor.generate.openapi.progress.message", objectArray), false, module.getProject());
        }

        public static /* synthetic */ VirtualFile dumpOpenApiForModule$default(Companion companion, Module module, String string, Function0 function0, int n, Object object) {
            if ((n & 4) != 0) {
                function0 = Companion::dumpOpenApiForModule$lambda$2;
            }
            return companion.dumpOpenApiForModule(module, string, (Function0<Boolean>)function0);
        }

        @Nullable
        public final VirtualFile generateNewOpenApiFile(@NotNull Module module, @NotNull Function0<Boolean> continueIfExists) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter(continueIfExists, (String)"continueIfExists");
            Object[] objectArray = new Object[]{module.getName()};
            String openapiContent = (String)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> Companion.generateNewOpenApiFile$lambda$9(module), KtorStarterBundle.INSTANCE.message("ktor.generate.openapi.progress.message", objectArray), true, module.getProject());
            Intrinsics.checkNotNull((Object)openapiContent);
            return this.dumpOpenApiForModule(module, openapiContent, continueIfExists);
        }

        public static /* synthetic */ VirtualFile generateNewOpenApiFile$default(Companion companion, Module module, Function0 function0, int n, Object object) {
            if ((n & 2) != 0) {
                function0 = Companion::generateNewOpenApiFile$lambda$7;
            }
            return companion.generateNewOpenApiFile(module, (Function0<Boolean>)function0);
        }

        public final void generateOpenApiAndShowNotifications(@NotNull Module module) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                VirtualFile virtualFile = this.generateNewOpenApiFile(module, (Function0<Boolean>)((Function0)Companion::generateOpenApiAndShowNotifications$lambda$10));
                if (virtualFile == null) break block0;
                VirtualFile swaggerFile = virtualFile;
                boolean bl = false;
                Project project = module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Companion.openFile(project, swaggerFile);
            }
        }

        private final void openFile(Project project, VirtualFile file) {
            FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, file, 0), true);
        }

        private final VirtualFile findResourcesRoot(Module module) {
            List list = ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSourceRoots(...)");
            return (VirtualFile)CollectionsKt.firstOrNull((List)list);
        }

        private final PsiDirectory getOrCreateResourcesRoot(Module module) {
            VirtualFile virtualFile = this.findResourcesRoot(module);
            if (virtualFile == null && (virtualFile = io.ktor.ide.actions.swagger.KtorGenerateOpenApiAction$Companion.getOrCreateResourcesRoot$createResourcesRoot(module)) == null) {
                return null;
            }
            VirtualFile resourcesRoot = virtualFile;
            return PsiManager.getInstance((Project)module.getProject()).findDirectory(resourcesRoot);
        }

        private static final boolean dumpOpenApiForModule$lambda$2() {
            return true;
        }

        private static final PsiDirectory dumpOpenApiForModule$lambda$3(PsiDirectory $resources) {
            PsiDirectory psiDirectory = $resources.findSubdirectory("openapi");
            if (psiDirectory == null) {
                PsiDirectory psiDirectory2 = $resources.createSubdirectory("openapi");
                psiDirectory = psiDirectory2;
                Intrinsics.checkNotNullExpressionValue((Object)psiDirectory2, (String)"createSubdirectory(...)");
            }
            return psiDirectory;
        }

        private static final PsiFile dumpOpenApiForModule$lambda$6$lambda$4(PsiDirectory $openApiDir) {
            return $openApiDir.createFile("documentation.yaml");
        }

        private static final void dumpOpenApiForModule$lambda$6$lambda$5(VirtualFile $swaggerFile, String $content) {
            VfsUtil.saveText((VirtualFile)$swaggerFile, (String)$content);
        }

        private static final VirtualFile dumpOpenApiForModule$lambda$6(PsiFile $existingFile, boolean $shouldOverwriteSwaggerFile, Module $module, PsiDirectory $openApiDir, String $content) {
            PsiFile psiFile;
            if ($existingFile != null) {
                if (!$shouldOverwriteSwaggerFile) {
                    return null;
                }
                psiFile = $existingFile;
            } else {
                Object object = WriteCommandAction.runWriteCommandAction((Project)$module.getProject(), () -> Companion.dumpOpenApiForModule$lambda$6$lambda$4($openApiDir));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runWriteCommandAction(...)");
                psiFile = (PsiFile)object;
            }
            PsiFile swaggerFilePsi = psiFile;
            VirtualFile swaggerFile = swaggerFilePsi.getVirtualFile();
            Object[] objectArray = new Object[]{$module.getName()};
            WriteCommandAction.runWriteCommandAction((Project)$module.getProject(), (String)KtorStarterBundle.INSTANCE.message("ktor.generate.openapi.documentation.progress.message.title", objectArray), null, () -> Companion.dumpOpenApiForModule$lambda$6$lambda$5(swaggerFile, $content), (PsiFile[])new PsiFile[0]);
            return swaggerFile;
        }

        private static final boolean generateNewOpenApiFile$lambda$7() {
            return true;
        }

        private static final String generateNewOpenApiFile$lambda$9$lambda$8(Module $module) {
            return Companion.prepareOpenApiTextForModule($module);
        }

        private static final String generateNewOpenApiFile$lambda$9(Module $module) {
            return (String)ApplicationUtilsKt.runReadAction(() -> Companion.generateNewOpenApiFile$lambda$9$lambda$8($module));
        }

        private static final boolean generateOpenApiAndShowNotifications$lambda$10() {
            return Messages.showYesNoDialog((String)KtorStarterBundle.INSTANCE.message("ktor.swagger.already.exists.message", new Object[0]), (String)KtorStarterBundle.INSTANCE.message("ktor.swagger.already.exists.title", new Object[0]), (Icon)KtorStarterIcons.Ktor) == 0;
        }

        private static final Void getOrCreateResourcesRoot$reportError(Module $module, @Nls String message) {
            Object[] objectArray = new Object[]{message};
            Notification notification = new Notification(KtorStarterBundle.INSTANCE.message("ktor.notification.groups.errors", new Object[0]), KtorStarterBundle.INSTANCE.message("ktor.swagger.action.notification.title.cannot.create.resources.root.for.swagger.file", new Object[0]), KtorStarterBundle.INSTANCE.message("ktor.swagger.action.notification.content.cannot.create.resources.root.for.swagger.file", objectArray), NotificationType.ERROR);
            Notifications.Bus.notify((Notification)notification, (Project)$module.getProject());
            return null;
        }

        private static final Unit getOrCreateResourcesRoot$createResourcesRoot$lambda$14$lambda$12(VirtualFile $resourcesDir, ModifiableRootModel it) {
            ContentEntry[] contentEntryArray = it.getContentEntries();
            Intrinsics.checkNotNullExpressionValue((Object)contentEntryArray, (String)"getContentEntries(...)");
            ((ContentEntry)ArraysKt.single((Object[])contentEntryArray)).addSourceFolder($resourcesDir, (JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
            return Unit.INSTANCE;
        }

        private static final void getOrCreateResourcesRoot$createResourcesRoot$lambda$14$lambda$13(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final VirtualFile getOrCreateResourcesRoot$createResourcesRoot$lambda$14(VirtualFile $contentRoot, String $resourcesDirName, Module $module) {
            VirtualFile virtualFile = $contentRoot.createChildDirectory((Object)Companion, $resourcesDirName);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"createChildDirectory(...)");
            VirtualFile resourcesDir = virtualFile;
            ModuleRootModificationUtil.updateModel((Module)$module, arg_0 -> Companion.getOrCreateResourcesRoot$createResourcesRoot$lambda$14$lambda$13(arg_0 -> Companion.getOrCreateResourcesRoot$createResourcesRoot$lambda$14$lambda$12(resourcesDir, arg_0), arg_0));
            return resourcesDir;
        }

        private static final VirtualFile getOrCreateResourcesRoot$createResourcesRoot(Module $module) {
            VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)$module).getContentRoots();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
            VirtualFile virtualFile = (VirtualFile)ArraysKt.singleOrNull((Object[])virtualFileArray);
            if (virtualFile == null) {
                Object[] objectArray = new Object[]{$module.getName()};
                return (VirtualFile)io.ktor.ide.actions.swagger.KtorGenerateOpenApiAction$Companion.getOrCreateResourcesRoot$reportError($module, KtorStarterBundle.INSTANCE.message("ktor.swagger.action.multiple.content.roots.for.module", objectArray));
            }
            VirtualFile contentRoot = virtualFile;
            String resourcesDirName = "resources";
            if (contentRoot.findChild(resourcesDirName) != null) {
                Object[] objectArray = new Object[]{resourcesDirName, contentRoot.getPath()};
                return (VirtualFile)io.ktor.ide.actions.swagger.KtorGenerateOpenApiAction$Companion.getOrCreateResourcesRoot$reportError($module, KtorStarterBundle.INSTANCE.message("ktor.swagger.action.openapi.folder.already.exists", objectArray));
            }
            if (ProjectFileIndex.getInstance((Project)$module.getProject()).isInSource(contentRoot)) {
                Object[] objectArray = new Object[]{contentRoot.getPath()};
                return (VirtualFile)io.ktor.ide.actions.swagger.KtorGenerateOpenApiAction$Companion.getOrCreateResourcesRoot$reportError($module, KtorStarterBundle.INSTANCE.message("ktor.swagger.action.openapi.under.sources.root", objectArray));
            }
            return (VirtualFile)ActionsKt.runWriteAction(() -> Companion.getOrCreateResourcesRoot$createResourcesRoot$lambda$14(contentRoot, resourcesDirName, $module));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

