/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.ide.client.generator;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.microservices.client.generator.AvailableClientSettings;
import com.intellij.microservices.client.generator.ClientExample;
import com.intellij.microservices.client.generator.ClientGenerator;
import com.intellij.microservices.client.generator.ClientGeneratorSetting;
import com.intellij.microservices.oas.OpenApiSpecification;
import com.intellij.openapi.project.Project;
import io.ktor.ide.KtorStarterBundle;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010\u0012\u001a\u00020\r2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u000e\u001a\u00020\u000fR\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lio/ktor/ide/client/generator/KtorClientGenerator;", "Lcom/intellij/microservices/client/generator/ClientGenerator;", "<init>", "()V", "title", "", "getTitle", "()Ljava/lang/String;", "availableClientSettings", "Lcom/intellij/microservices/client/generator/AvailableClientSettings;", "getAvailableClientSettings", "()Lcom/intellij/microservices/client/generator/AvailableClientSettings;", "generate", "Lcom/intellij/microservices/client/generator/ClientExample;", "project", "Lcom/intellij/openapi/project/Project;", "openApiSpecification", "Lcom/intellij/microservices/oas/OpenApiSpecification;", "build", "properties", "", "", "intellij.ktor.starter"})
public final class KtorClientGenerator
implements ClientGenerator {
    @NotNull
    private final AvailableClientSettings availableClientSettings = new AvailableClientSettings(){
        private final boolean boilerplateAvailable;
        private final ClientGeneratorSetting actualClientSettings;
        {
            this.boilerplateAvailable = true;
            this.actualClientSettings = new ClientGeneratorSetting(false, null, null);
        }

        public boolean getBoilerplateAvailable() {
            return this.boilerplateAvailable;
        }

        public ClientGeneratorSetting getActualClientSettings() {
            return this.actualClientSettings;
        }
    };

    @NotNull
    public String getTitle() {
        return KtorStarterBundle.INSTANCE.message("ktor.client.generator.title", new Object[0]);
    }

    @NotNull
    public AvailableClientSettings getAvailableClientSettings() {
        return this.availableClientSettings;
    }

    @NotNull
    public ClientExample generate(@NotNull Project project, @NotNull OpenApiSpecification openApiSpecification) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)openApiSpecification, (String)"openApiSpecification");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"openApiSpecification", (Object)openApiSpecification), TuplesKt.to((Object)"WITH_BOILERPLATE", (Object)this.getAvailableClientSettings().getActualClientSettings().getBoilerplate())};
        return this.build(MapsKt.mapOf((Pair[])pairArray), project);
    }

    @NotNull
    public final ClientExample build(@NotNull Map<String, ? extends Object> properties, @NotNull Project project) {
        FileTemplate template;
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)project).getCodeTemplate("Ktor Client Generator.kt");
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getCodeTemplate(...)");
        FileTemplate $this$build_u24lambda_u240 = template = fileTemplate;
        boolean bl = false;
        $this$build_u24lambda_u240.setReformatCode(true);
        String string = $this$build_u24lambda_u240.getText(properties);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"run(...)");
        String text = ((Object)StringsKt.trimEnd((CharSequence)string)).toString();
        return ClientExample.Companion.fromFileExtension(text, "kt");
    }
}

