/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.ide.configurations.common.file;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\t"}, d2={"findConfigFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "module", "Lcom/intellij/openapi/module/Module;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getConfigFileSearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "intellij.ktor.starter"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\nio/ktor/ide/configurations/common/file/UtilsKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,28:1\n37#2,2:29\n*S KotlinDebug\n*F\n+ 1 utils.kt\nio/ktor/ide/configurations/common/file/UtilsKt\n*L\n24#1:29,2\n*E\n"})
public final class UtilsKt {
    @NotNull
    public static final Collection<VirtualFile> findConfigFiles(@NotNull Module module, @NotNull FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        GlobalSearchScope configFileSearchScope = UtilsKt.getConfigFileSearchScope(module);
        Collection collection = FileTypeIndex.getFiles((FileType)fileType, (GlobalSearchScope)configFileSearchScope);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getFiles(...)");
        return collection;
    }

    private static final GlobalSearchScope getConfigFileSearchScope(Module module) {
        GlobalSearchScope globalSearchScope;
        if (module.isDisposed()) {
            GlobalSearchScope globalSearchScope2 = GlobalSearchScope.EMPTY_SCOPE;
            globalSearchScope = globalSearchScope2;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"EMPTY_SCOPE");
        } else if (ApplicationManager.getApplication().isUnitTestMode()) {
            GlobalSearchScope globalSearchScope3 = module.getModuleScope();
            globalSearchScope = globalSearchScope3;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope3, (String)"getModuleScope(...)");
        } else {
            List list = ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSourceRoots(...)");
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            VirtualFile[] configDirectories = thisCollection$iv.toArray(new VirtualFile[0]);
            GlobalSearchScope globalSearchScope4 = GlobalSearchScopesCore.directoriesScope((Project)module.getProject(), (boolean)false, (VirtualFile[])Arrays.copyOf(configDirectories, configDirectories.length));
            Intrinsics.checkNotNull((Object)globalSearchScope4);
            globalSearchScope = globalSearchScope4;
        }
        return globalSearchScope;
    }
}

