/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.ide.configurations.meta.key.parser;

import com.intellij.codeWithMe.ClientId;
import com.intellij.json.psi.JsonFile;
import com.intellij.microservices.jvm.config.utils.MetaConfigFileUtilsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import io.ktor.ide.configurations.meta.key.KtorMetaConfigKey;
import io.ktor.ide.configurations.meta.key.parser.MetaConfigKeyParser;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lio/ktor/ide/configurations/meta/key/parser/KtorMetaConfigKeyService;", "", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCs", "()Lkotlinx/coroutines/CoroutineScope;", "parseJsonFile", "", "Lio/ktor/ide/configurations/meta/key/KtorMetaConfigKey;", "project", "Lcom/intellij/openapi/project/Project;", "jsonFile", "Lcom/intellij/json/psi/JsonFile;", "parseDefault", "inputStream", "Ljava/io/InputStream;", "Companion", "intellij.ktor.starter"})
public final class KtorMetaConfigKeyService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope cs;

    public KtorMetaConfigKeyService(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.cs = cs;
    }

    @NotNull
    public final CoroutineScope getCs() {
        return this.cs;
    }

    @NotNull
    public final List<KtorMetaConfigKey> parseJsonFile(@NotNull Project project, @NotNull JsonFile jsonFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)jsonFile, (String)"jsonFile");
        VirtualFile virtualFile = jsonFile.getVirtualFile();
        Intrinsics.checkNotNull((Object)virtualFile);
        String string = MetaConfigFileUtilsKt.getLibraryOrContainingJarName((Project)project, (VirtualFile)virtualFile);
        if (string == null) {
            string = "<unknown>";
        }
        String libraryName = string;
        InputStream inputStream = virtualFile.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        return new MetaConfigKeyParser(project, inputStream, libraryName, (PsiElement)jsonFile).getKtorMetaConfigKeys();
    }

    @NotNull
    public final List<KtorMetaConfigKey> parseDefault(@NotNull Project project, @NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        return new MetaConfigKeyParser(project, inputStream, "ktor-library", null, 8, null).getKtorMetaConfigKeys();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lio/ktor/ide/configurations/meta/key/parser/KtorMetaConfigKeyService$Companion;", "", "<init>", "()V", "getInstance", "Lio/ktor/ide/configurations/meta/key/parser/KtorMetaConfigKeyService;", "intellij.ktor.starter"})
    @SourceDebugExtension(value={"SMAP\nKtorMetaConfigKeyParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorMetaConfigKeyParser.kt\nio/ktor/ide/configurations/meta/key/parser/KtorMetaConfigKeyService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,86:1\n40#2,3:87\n*S KotlinDebug\n*F\n+ 1 KtorMetaConfigKeyParser.kt\nio/ktor/ide/configurations/meta/key/parser/KtorMetaConfigKeyService$Companion\n*L\n40#1:87,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KtorMetaConfigKeyService getInstance() {
            boolean $i$f$service = false;
            Class<KtorMetaConfigKeyService> serviceClass$iv = KtorMetaConfigKeyService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (KtorMetaConfigKeyService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

