/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.ide.configurations.yaml.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.microservices.jvm.config.MicroservicesConfigUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.MultiMap;
import io.ktor.ide.KtorStarterBundle;
import io.ktor.ide.configurations.meta.key.highlighting.DeprecationHighlightingUtilsKt;
import io.ktor.ide.configurations.meta.key.reference.value.module.KtorModuleMetaConfigKeyReference;
import io.ktor.ide.configurations.meta.key.reference.value.module.ModuleHighlightingUtilsKt;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YamlRecursivePsiElementVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/ktor/ide/configurations/yaml/highlighting/KtorConfigYamlRecursivePsiElementVisitor;", "Lorg/jetbrains/yaml/psi/YamlRecursivePsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "duplicateModuleValues", "Lcom/intellij/util/containers/MultiMap;", "", "Lcom/intellij/psi/PsiElement;", "visitFile", "", "file", "Lcom/intellij/psi/PsiFile;", "highlightDuplicateModules", "moduleName", "duplicatedModules", "", "visitKeyValue", "keyValue", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "visitScalar", "scalar", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "visitModuleReference", "moduleReference", "Lio/ktor/ide/configurations/meta/key/reference/value/module/KtorModuleMetaConfigKeyReference;", "intellij.ktor.starter"})
@SourceDebugExtension(value={"SMAP\nKtorYamlConfigInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorYamlConfigInspection.kt\nio/ktor/ide/configurations/yaml/highlighting/KtorConfigYamlRecursivePsiElementVisitor\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,80:1\n26#2,2:81\n*S KotlinDebug\n*F\n+ 1 KtorYamlConfigInspection.kt\nio/ktor/ide/configurations/yaml/highlighting/KtorConfigYamlRecursivePsiElementVisitor\n*L\n70#1:81,2\n*E\n"})
final class KtorConfigYamlRecursivePsiElementVisitor
extends YamlRecursivePsiElementVisitor {
    @NotNull
    private final ProblemsHolder holder;
    @NotNull
    private final MultiMap<String, PsiElement> duplicateModuleValues;

    public KtorConfigYamlRecursivePsiElementVisitor(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
        this.duplicateModuleValues = new MultiMap();
    }

    public void visitFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super.visitFile(file);
        for (Map.Entry entry : this.duplicateModuleValues.entrySet()) {
            Intrinsics.checkNotNull((Object)entry);
            String moduleName = (String)entry.getKey();
            Collection values = (Collection)entry.getValue();
            if (values.size() == 1) continue;
            Intrinsics.checkNotNull((Object)moduleName);
            Intrinsics.checkNotNull((Object)values);
            this.highlightDuplicateModules(moduleName, values);
        }
    }

    private final void highlightDuplicateModules(String moduleName, Collection<? extends PsiElement> duplicatedModules) {
        for (PsiElement psiElement : duplicatedModules) {
            Object[] objectArray = new Object[]{moduleName};
            this.holder.registerProblem(psiElement, KtorStarterBundle.INSTANCE.message("ktor.config.property.module.duplicated", objectArray), new LocalQuickFix[0]);
        }
    }

    public void visitKeyValue(@NotNull YAMLKeyValue keyValue) {
        Intrinsics.checkNotNullParameter((Object)keyValue, (String)"keyValue");
        super.visitKeyValue(keyValue);
        if (keyValue.getKey() == null) {
            return;
        }
        DeprecationHighlightingUtilsKt.highlightDeprecationIfNeeded(this.holder, (PsiElement)keyValue);
    }

    public void visitScalar(@NotNull YAMLScalar scalar) {
        Object object;
        block2: {
            Intrinsics.checkNotNullParameter((Object)scalar, (String)"scalar");
            super.visitScalar(scalar);
            MicroservicesConfigUtils.highlightValueReferences((PsiElement)((PsiElement)scalar), (ProblemsHolder)this.holder);
            PsiReference[] psiReferenceArray = scalar.getReferences();
            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
            Object[] $this$firstIsInstanceOrNull$iv = psiReferenceArray;
            boolean $i$f$firstIsInstanceOrNull = false;
            for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                if (!(element$iv instanceof KtorModuleMetaConfigKeyReference)) continue;
                object = element$iv;
                break block2;
            }
            object = null;
        }
        KtorModuleMetaConfigKeyReference ktorModuleMetaConfigKeyReference = (KtorModuleMetaConfigKeyReference)((Object)object);
        if (ktorModuleMetaConfigKeyReference == null) {
            return;
        }
        KtorModuleMetaConfigKeyReference moduleReference = ktorModuleMetaConfigKeyReference;
        this.visitModuleReference(moduleReference);
    }

    private final void visitModuleReference(KtorModuleMetaConfigKeyReference moduleReference) {
        this.duplicateModuleValues.putValue((Object)moduleReference.getCanonicalText(), (Object)moduleReference.getElement());
        ModuleHighlightingUtilsKt.highlightModuleReference(this.holder, moduleReference);
    }
}

